/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.CompatVersion;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.ext.jruby.JRubyLibrary;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.MethodBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;

@JRubyClass(name={"Method"})
public class RubyMethod
extends RubyObject
implements DataType {
    protected RubyModule implementationModule;
    protected String methodName;
    protected RubyModule originModule;
    protected String originName;
    protected DynamicMethod method;
    protected IRubyObject receiver;

    protected RubyMethod(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static RubyClass createMethodClass(Ruby runtime) {
        RubyClass methodClass = runtime.defineClass("Method", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setMethod(methodClass);
        methodClass.index = 34;
        methodClass.setReifiedClass(RubyMethod.class);
        methodClass.defineAnnotatedMethods(RubyMethod.class);
        return methodClass;
    }

    public static RubyMethod newMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, DynamicMethod method2, IRubyObject receiver2) {
        Ruby runtime = implementationModule.getRuntime();
        RubyMethod newMethod = new RubyMethod(runtime, runtime.getMethod());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method2;
        newMethod.receiver = receiver2;
        return newMethod;
    }

    public DynamicMethod getMethod() {
        return this.method;
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, IRubyObject arg2, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, arg2, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, arg0, arg1, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, arg0, arg1, arg2, block);
    }

    @JRubyMethod(name={"call", "[]"}, rest=true)
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, args2, block);
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.method.getArity().getValue());
    }

    @JRubyMethod(name={"=="}, required=1)
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyMethod)) {
            return context.getRuntime().getFalse();
        }
        if (this.method instanceof ProcMethod) {
            return context.getRuntime().newBoolean(((ProcMethod)this.method).isSame(((RubyMethod)other).getMethod()));
        }
        RubyMethod otherMethod = (RubyMethod)other;
        return context.getRuntime().newBoolean(this.receiver == otherMethod.receiver && this.originModule == otherMethod.originModule && this.method.getRealMethod().getSerialNumber() == otherMethod.method.getRealMethod().getSerialNumber());
    }

    @JRubyMethod(name={"eql?"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_eql19(ThreadContext context, IRubyObject other) {
        return this.op_equal(context, other);
    }

    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        return RubyMethod.newMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method, this.receiver);
    }

    @JRubyMethod
    public IRubyObject to_proc(ThreadContext context, Block unusedBlock) {
        Ruby runtime = context.getRuntime();
        DynamicScope currentScope = context.getCurrentScope();
        MethodBlock mb = new MethodBlock(this, currentScope.getStaticScope()){

            public IRubyObject callback(IRubyObject value2, IRubyObject method2, IRubyObject self, Block block) {
                return RubyMethod.bmcall(value2, method2, self, block);
            }
        };
        Block block = MethodBlock.createMethodBlock(context, runtime.getTopSelf(), context.getCurrentScope(), mb);
        while (true) {
            try {
                return this.mproc(context, block);
            }
            catch (JumpException.BreakJump bj) {
                return (IRubyObject)bj.getValue();
            }
            catch (JumpException.ReturnJump rj) {
                return (IRubyObject)rj.getValue();
            }
            catch (JumpException.RetryJump rj) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject mproc(ThreadContext context, Block block) {
        try {
            context.preMproc();
            RubyProc rubyProc = RubyKernel.proc(context, context.getRuntime().getNil(), block);
            Object var5_4 = null;
            context.postMproc();
            return rubyProc;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.postMproc();
            throw throwable;
        }
    }

    public static IRubyObject bmcall(IRubyObject blockArg, IRubyObject arg1, IRubyObject self, Block block) {
        ThreadContext context = arg1.getRuntime().getCurrentContext();
        if (blockArg == null) {
            return ((RubyMethod)arg1).call(context, IRubyObject.NULL_ARRAY, block);
        }
        if (blockArg instanceof RubyArray) {
            return ((RubyMethod)arg1).call(context, ((RubyArray)blockArg).toJavaArray(), block);
        }
        return ((RubyMethod)arg1).call(context, new IRubyObject[]{blockArg}, block);
    }

    @JRubyMethod
    public RubyUnboundMethod unbind() {
        RubyUnboundMethod unboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
        unboundMethod.infectBy(this);
        return unboundMethod;
    }

    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect() {
        StringBuilder buf = new StringBuilder("#<");
        int delimeter = 35;
        buf.append(this.getMetaClass().getRealClass().getName()).append(": ");
        if (this.implementationModule.isSingleton()) {
            IRubyObject attached = ((MetaClass)this.implementationModule).getAttached();
            if (this.receiver == null) {
                buf.append(this.implementationModule.inspect().toString());
            } else if (this.receiver == attached) {
                buf.append(attached.inspect().toString());
                delimeter = 46;
            } else {
                buf.append(this.receiver.inspect().toString());
                buf.append('(').append(attached.inspect().toString()).append(')');
                delimeter = 46;
            }
        } else {
            buf.append(this.originModule.getName());
            if (this.implementationModule != this.originModule) {
                buf.append('(').append(this.implementationModule.getName()).append(')');
            }
        }
        buf.append((char)delimeter).append(this.methodName).append('>');
        RubyString str = this.getRuntime().newString(buf.toString());
        str.setTaint(this.isTaint());
        return str;
    }

    @JRubyMethod(name={"name"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject name(ThreadContext context) {
        return context.getRuntime().newString(this.methodName);
    }

    @JRubyMethod(name={"name"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject name19(ThreadContext context) {
        return context.getRuntime().newSymbol(this.methodName);
    }

    public String getMethodName() {
        return this.methodName;
    }

    @JRubyMethod(name={"receiver"})
    public IRubyObject receiver(ThreadContext context) {
        return this.receiver;
    }

    @JRubyMethod(name={"owner"})
    public IRubyObject owner(ThreadContext context) {
        return this.implementationModule;
    }

    @JRubyMethod(name={"source_location"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject source_location(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        String filename2 = this.getFilename();
        if (filename2 != null) {
            return runtime.newArray((IRubyObject)runtime.newString(filename2), (IRubyObject)runtime.newFixnum(this.getLine()));
        }
        return context.getRuntime().getNil();
    }

    public String getFilename() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return poser.getFile();
        }
        return null;
    }

    public int getLine() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return poser.getLine() + 1;
        }
        return -1;
    }

    @JRubyMethod(name={"parameters"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject parameters(ThreadContext context) {
        return JRubyLibrary.MethodExtensions.methodArgs(this);
    }
}

