/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.SimpleSampler;
import org.jruby.util.cli.OutputStrings;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final Logger LOG = LoggerFactory.getLogger("Main");
    private final RubyInstanceConfig config;

    public Main(RubyInstanceConfig config) {
        this(config, false);
    }

    public Main(final InputStream in, final PrintStream out, final PrintStream err) {
        this(new RubyInstanceConfig(){
            {
                this.setInput(in);
                this.setOutput(out);
                this.setError(err);
            }
        });
    }

    public Main() {
        this(new RubyInstanceConfig());
    }

    private Main(RubyInstanceConfig config, boolean hardExit) {
        this.config = config;
        config.setHardExit(hardExit);
    }

    private Main(boolean hardExit) {
        Main.processDotfile();
        this.config = new RubyInstanceConfig();
        this.config.setHardExit(hardExit);
    }

    private static List<String> getDotfileDirectories() {
        ArrayList<String> searchList = new ArrayList<String>();
        for (String homeProp : new String[]{"user.dir", "user.home"}) {
            String home2 = SafePropertyAccessor.getProperty(homeProp);
            if (home2 == null) continue;
            searchList.add(home2);
        }
        if (Platform.IS_WINDOWS) {
            String homeDrive = System.getenv("HOMEDRIVE");
            String homePath = System.getenv("HOMEPATH");
            if (homeDrive != null && homePath != null) {
                searchList.add(1, (homeDrive + homePath).replace('\\', '/'));
            }
        }
        return searchList;
    }

    public static void processDotfile() {
        for (String home2 : Main.getDotfileDirectories()) {
            File dotfile = new File(home2 + "/.jrubyrc");
            if (!dotfile.exists()) continue;
            Main.loadJRubyProperties(dotfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadJRubyProperties(File dotfile) {
        FileInputStream fis = null;
        try {
            Properties sysProps = System.getProperties();
            Properties newProps = new Properties();
            fis = new FileInputStream(dotfile);
            newProps.load(fis);
            for (Map.Entry<Object, Object> entry : newProps.entrySet()) {
                sysProps.put("jruby." + entry.getKey(), entry.getValue());
            }
        }
        catch (IOException ioe) {
            LOG.debug("exception loading " + dotfile, ioe);
        }
        catch (SecurityException se) {
            LOG.debug("exception loading " + dotfile, se);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void main(String[] args2) {
        Main.doGCJCheck();
        Main main2 = new Main(true);
        try {
            Status status2 = main2.run(args2);
            if (status2.isExit()) {
                System.exit(status2.getStatus());
            }
        }
        catch (RaiseException rj) {
            System.exit(Main.handleRaiseException(rj));
        }
        catch (Throwable t) {
            System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(t));
            while ((t = t.getCause()) != null) {
                System.err.println("Caused by:");
                System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(t));
            }
            System.exit(1);
        }
    }

    public Status run(String[] args2) {
        try {
            this.config.processArguments(args2);
            return this.run();
        }
        catch (MainExitException mee) {
            return this.handleMainExit(mee);
        }
        catch (OutOfMemoryError oome) {
            return this.handleOutOfMemory(oome);
        }
        catch (StackOverflowError soe) {
            return this.handleStackOverflow(soe);
        }
        catch (UnsupportedClassVersionError ucve) {
            return this.handleUnsupportedClassVersion(ucve);
        }
        catch (ThreadKill kill2) {
            return new Status();
        }
    }

    @Deprecated
    public Status run() {
        return this.internalRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status internalRun() {
        this.doShowVersion();
        this.doShowCopyright();
        if (!this.config.getShouldRunInterpreter()) {
            this.doPrintUsage(false);
            this.doPrintProperties();
            return new Status();
        }
        InputStream in = this.config.getScriptSource();
        String filename2 = this.config.displayedFileName();
        this.doProcessArguments(in);
        Ruby runtime = Ruby.newInstance(this.config);
        try {
            this.doSetContextClassLoader(runtime);
            if (in == null) {
                Status status2 = new Status();
                return status2;
            }
            if (this.config.isXFlag() && !this.config.hasShebangLine()) {
                throw new MainExitException(1, "jruby: no Ruby script found in input (LoadError)");
            }
            if (this.config.getShouldCheckSyntax()) {
                Status status3 = this.doCheckSyntax(runtime, in, filename2);
                return status3;
            }
            Status status4 = this.doRunFromMain(runtime, in, filename2);
            return status4;
        }
        finally {
            runtime.tearDown();
        }
    }

    private Status handleUnsupportedClassVersion(UnsupportedClassVersionError ucve) {
        this.config.getError().println("Error: Some library (perhaps JRuby) was built with a later JVM version.");
        this.config.getError().println("Please use libraries built with the version you intend to use or an earlier one.");
        if (this.config.isVerbose()) {
            this.config.getError().println("Exception trace follows:");
            ucve.printStackTrace();
        } else {
            this.config.getError().println("Specify -w for full UnsupportedClassVersionError stack trace");
        }
        return new Status(1);
    }

    private Status handleStackOverflow(StackOverflowError soe) {
        String memoryMax = this.getRuntimeFlagValue("-Xss");
        if (memoryMax != null) {
            this.config.getError().println("Error: Your application used more stack memory than the safety cap of " + memoryMax + ".");
        } else {
            this.config.getError().println("Error: Your application used more stack memory than the default safety cap.");
        }
        this.config.getError().println("Specify -J-Xss####k to increase it (#### = cap size in KB).");
        if (this.config.isVerbose()) {
            this.config.getError().println("Exception trace follows:");
            soe.printStackTrace(this.config.getError());
        } else {
            this.config.getError().println("Specify -w for full StackOverflowError stack trace");
        }
        return new Status(1);
    }

    private Status handleOutOfMemory(OutOfMemoryError oome) {
        System.gc();
        String oomeMessage = oome.getMessage();
        if (oomeMessage.contains("PermGen")) {
            this.config.getError().println("Error: Your application exhausted PermGen area of the heap.");
            this.config.getError().println("Specify -J-XX:MaxPermSize=###M to increase it (### = PermGen size in MB).");
        } else {
            String memoryMax = this.getRuntimeFlagValue("-Xmx");
            if (memoryMax != null) {
                this.config.getError().println("Error: Your application used more memory than the safety cap of " + memoryMax + ".");
            } else {
                this.config.getError().println("Error: Your application used more memory than the default safety cap.");
            }
            this.config.getError().println("Specify -J-Xmx####m to increase it (#### = cap size in MB).");
        }
        if (this.config.isVerbose()) {
            this.config.getError().println("Exception trace follows:");
            oome.printStackTrace(this.config.getError());
        } else {
            this.config.getError().println("Specify -w for full OutOfMemoryError stack trace");
        }
        return new Status(1);
    }

    private String getRuntimeFlagValue(String prefix) {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        for (String param : runtime.getInputArguments()) {
            if (!param.startsWith(prefix)) continue;
            return param.substring(prefix.length()).toUpperCase();
        }
        return null;
    }

    private Status handleMainExit(MainExitException mee) {
        if (!mee.isAborted()) {
            this.config.getOutput().println(mee.getMessage());
            if (mee.isUsageError()) {
                this.doPrintUsage(true);
            }
        }
        return new Status(mee.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status doRunFromMain(Ruby runtime, InputStream in, String filename2) {
        long now = -1L;
        try {
            if (this.config.isBenchmarking()) {
                now = System.currentTimeMillis();
            }
            if (this.config.isSamplingEnabled()) {
                SimpleSampler.startSampleThread();
            }
            this.doCheckSecurityManager();
            try {
                runtime.runFromMain(in, filename2);
            }
            finally {
                if (this.config.isBenchmarking()) {
                    this.config.getOutput().println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
                }
                if (this.config.isSamplingEnabled()) {
                    SimpleSampler.report();
                }
            }
        }
        catch (RaiseException rj) {
            return new Status(Main.handleRaiseException(rj));
        }
        return new Status();
    }

    private Status doCheckSyntax(Ruby runtime, InputStream in, String filename2) throws RaiseException {
        boolean status2 = this.checkStreamSyntax(runtime, in, filename2);
        String[] argv = this.config.getArgv();
        if (argv.length > 0) {
            for (String arg2 : argv) {
                status2 = status2 && this.checkFileSyntax(runtime, arg2);
            }
        }
        return new Status(status2 ? 0 : -1);
    }

    private boolean checkFileSyntax(Ruby runtime, String filename2) {
        File file2 = new File(filename2);
        if (file2.exists()) {
            try {
                return this.checkStreamSyntax(runtime, new FileInputStream(file2), filename2);
            }
            catch (FileNotFoundException fnfe) {
                this.config.getError().println("File not found: " + filename2);
                return false;
            }
        }
        return false;
    }

    private boolean checkStreamSyntax(Ruby runtime, InputStream in, String filename2) {
        PrintStream error2 = this.config.getError();
        try {
            runtime.parseFromMain(in, filename2);
            error2.println("Syntax OK for " + filename2);
            return true;
        }
        catch (RaiseException re) {
            if (!re.getException().getMetaClass().getBaseName().equals("SyntaxError")) {
                throw re;
            }
            error2.println("SyntaxError in " + re.getException().message(runtime.getCurrentContext()));
            return false;
        }
    }

    private void doSetContextClassLoader(Ruby runtime) {
        block2: {
            try {
                Thread.currentThread().setContextClassLoader(runtime.getJRubyClassLoader());
            }
            catch (SecurityException se) {
                if (!runtime.getInstanceConfig().isVerbose()) break block2;
                this.config.getError().println("WARNING: Security restrictions disallowed setting context classloader for main thread.");
            }
        }
    }

    private void doProcessArguments(InputStream in) {
        String[] args2 = this.config.parseShebangOptions(in);
        if (args2.length > 0) {
            this.config.processArguments(args2);
        }
    }

    private void doPrintProperties() {
        if (this.config.getShouldPrintProperties()) {
            this.config.getOutput().print(OutputStrings.getPropertyHelp());
        }
    }

    private void doPrintUsage(boolean force) {
        if (this.config.getShouldPrintUsage() || force) {
            this.config.getOutput().print(OutputStrings.getBasicUsageHelp());
        }
    }

    private void doShowCopyright() {
        if (this.config.isShowCopyright()) {
            this.config.getOutput().println(OutputStrings.getCopyrightString());
        }
    }

    private void doShowVersion() {
        if (this.config.isShowVersion()) {
            this.config.getOutput().println(OutputStrings.getVersionString(this.config.getCompatVersion()));
        }
    }

    private static void doGCJCheck() {
        if (Platform.IS_GCJ) {
            System.err.println("Fatal: GCJ (GNU Compiler for Java) is not supported by JRuby.");
            System.exit(1);
        }
    }

    private void doCheckSecurityManager() {
        if (Main.class.getClassLoader() == null && System.getSecurityManager() != null) {
            System.err.println("Warning: security manager and JRuby running from boot classpath.\nRun from jruby.jar or set env VERIFY_JRUBY=true to enable security.");
        }
    }

    private static int handleRaiseException(RaiseException rj) {
        RubyException raisedException = rj.getException();
        Ruby runtime = raisedException.getRuntime();
        if (runtime.getSystemExit().isInstance(raisedException)) {
            IRubyObject status2 = raisedException.callMethod(runtime.getCurrentContext(), "status");
            if (status2 != null && !status2.isNil()) {
                return RubyNumeric.fix2int(status2);
            }
            return 0;
        }
        System.err.print(runtime.getInstanceConfig().getTraceType().printBacktrace(raisedException, runtime.getPosix().isatty(FileDescriptor.err)));
        return 1;
    }

    public static class Status {
        private boolean isExit = false;
        private int status = 0;

        Status(int status2) {
            this.isExit = true;
            this.status = status2;
        }

        Status() {
        }

        public boolean isExit() {
            return this.isExit;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

