/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Collections;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyString;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.runtime.builtin.InternalVariables;
import org.jruby.runtime.builtin.RubyJavaObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.util.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BasicObjectStub {
    public static final InternalVariables DUMMY_INTERNAL_VARIABLES = new DummyInternalVariables();

    public static IRubyObject callSuper(IRubyObject self, ThreadContext context, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.invokeSuper(context, self, args2, block);
    }

    public static IRubyObject callMethod(IRubyObject self, ThreadContext context, String name2) {
        return RuntimeHelpers.invoke(context, self, name2);
    }

    public static IRubyObject callMethod(IRubyObject self, ThreadContext context, String name2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, self, name2, arg2);
    }

    public static IRubyObject callMethod(IRubyObject self, ThreadContext context, String name2, IRubyObject[] args2) {
        return RuntimeHelpers.invoke(context, self, name2, args2);
    }

    public static IRubyObject callMethod(IRubyObject self, ThreadContext context, String name2, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.invoke(context, self, name2, args2, block);
    }

    public static IRubyObject callMethod(IRubyObject self, ThreadContext context, int methodIndex, String name2) {
        return RuntimeHelpers.invoke(context, self, name2);
    }

    public static IRubyObject callMethod(IRubyObject self, ThreadContext context, int methodIndex, String name2, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, self, name2, arg2);
    }

    public static boolean isNil(IRubyObject self) {
        return false;
    }

    public static boolean isTrue(IRubyObject self) {
        return true;
    }

    public static boolean isTaint(IRubyObject self) {
        return false;
    }

    public static void setTaint(IRubyObject self, boolean b) {
    }

    public static IRubyObject infectBy(IRubyObject self, IRubyObject obj) {
        return self;
    }

    public static boolean isFrozen(IRubyObject self) {
        return false;
    }

    public static void setFrozen(IRubyObject self, boolean b) {
    }

    public static boolean isUntrusted(IRubyObject self) {
        return false;
    }

    public static void setUntrusted(IRubyObject self, boolean b) {
    }

    public static boolean isImmediate(IRubyObject self) {
        return false;
    }

    public static RubyClass getMetaClass(IRubyObject self) {
        if (self instanceof RubyBasicObject) {
            return ((RubyBasicObject)self).getMetaClass();
        }
        if (self instanceof RubyJavaObject) {
            return ((RubyJavaObject)((Object)self)).getMetaClass();
        }
        throw new RuntimeException("unknown object type in BasicObjectStuff.getMetaClass: " + self.getClass());
    }

    public static RubyClass getSingletonClass(IRubyObject self) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static RubyClass getType(IRubyObject self) {
        return BasicObjectStub.getMetaClass(self).getRealClass();
    }

    public static boolean respondsTo(IRubyObject self, String name2) {
        if (BasicObjectStub.getMetaClass(self).searchMethod("respond_to?") == BasicObjectStub.getRuntime(self).getRespondToMethod()) {
            return BasicObjectStub.getMetaClass(self).isMethodBound(name2, false);
        }
        return BasicObjectStub.callMethod(self, BasicObjectStub.getRuntime(self).getCurrentContext(), "respond_to?", BasicObjectStub.getRuntime(self).newSymbol(name2)).isTrue();
    }

    public static Ruby getRuntime(IRubyObject self) {
        return BasicObjectStub.getMetaClass(self).getClassRuntime();
    }

    public static Class getJavaClass(IRubyObject self) {
        return self.getClass();
    }

    public static String asJavaString(IRubyObject self) {
        IRubyObject asString = BasicObjectStub.checkStringType(self);
        if (!asString.isNil()) {
            return ((RubyString)asString).asJavaString();
        }
        throw BasicObjectStub.getRuntime(self).newTypeError(BasicObjectStub.inspect(self).toString() + " is not a string");
    }

    public static RubyString asString(IRubyObject self) {
        IRubyObject str = RuntimeHelpers.invoke(BasicObjectStub.getRuntime(self).getCurrentContext(), self, "to_s");
        if (!(str instanceof RubyString)) {
            return (RubyString)BasicObjectStub.anyToString(self);
        }
        if (BasicObjectStub.isTaint(self)) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    public static RubyArray convertToArray(IRubyObject self) {
        return (RubyArray)TypeConverter.convertToType(self, BasicObjectStub.getRuntime(self).getArray(), "to_ary");
    }

    public static RubyHash convertToHash(IRubyObject self) {
        return (RubyHash)TypeConverter.convertToType(self, BasicObjectStub.getRuntime(self).getHash(), "to_hash");
    }

    public static RubyFloat convertToFloat(IRubyObject self) {
        return (RubyFloat)TypeConverter.convertToType(self, BasicObjectStub.getRuntime(self).getFloat(), "to_f");
    }

    public static RubyInteger convertToInteger(IRubyObject self) {
        return BasicObjectStub.convertToInteger(self, "to_int");
    }

    public static RubyInteger convertToInteger(IRubyObject self, int convertMethodIndex, String convertMethod) {
        return BasicObjectStub.convertToInteger(self, convertMethod);
    }

    public static RubyInteger convertToInteger(IRubyObject self, String convertMethod) {
        IRubyObject val = TypeConverter.convertToType(self, BasicObjectStub.getRuntime(self).getInteger(), convertMethod, true);
        if (!(val instanceof RubyInteger)) {
            throw BasicObjectStub.getRuntime(self).newTypeError(BasicObjectStub.getMetaClass(self).getName() + "#" + convertMethod + " should return Integer");
        }
        return (RubyInteger)val;
    }

    public static RubyString convertToString(IRubyObject self) {
        return (RubyString)TypeConverter.convertToType(self, BasicObjectStub.getRuntime(self).getString(), "to_str");
    }

    public static IRubyObject anyToString(IRubyObject self) {
        String cname = BasicObjectStub.getMetaClass(self).getRealClass().getName();
        RubyString str = BasicObjectStub.getRuntime(self).newString("#<" + cname + ":0x" + Integer.toHexString(System.identityHashCode(self)) + ">");
        str.setTaint(BasicObjectStub.isTaint(self));
        return str;
    }

    public static IRubyObject checkStringType(IRubyObject self) {
        IRubyObject str = TypeConverter.convertToTypeWithCheck(self, BasicObjectStub.getRuntime(self).getString(), "to_str");
        if (!str.isNil() && !(str instanceof RubyString)) {
            str = RubyString.newEmptyString(BasicObjectStub.getRuntime(self));
        }
        return str;
    }

    public static IRubyObject checkArrayType(IRubyObject self) {
        return TypeConverter.convertToTypeWithCheck(self, BasicObjectStub.getRuntime(self).getArray(), "to_ary");
    }

    public static Object toJava(IRubyObject self, Class cls) {
        if (cls.isAssignableFrom(self.getClass())) {
            return self;
        }
        throw BasicObjectStub.getRuntime(self).newTypeError("could not convert " + self.getClass() + " to " + cls);
    }

    public static IRubyObject dup(IRubyObject self) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject inspect(IRubyObject self) {
        Ruby runtime = BasicObjectStub.getRuntime(self);
        if (BasicObjectStub.hasVariables(self)) {
            StringBuilder part = new StringBuilder();
            String cname = BasicObjectStub.getMetaClass(self).getRealClass().getName();
            part.append("#<").append(cname).append(":0x");
            part.append(Integer.toHexString(System.identityHashCode(self)));
            if (runtime.isInspecting(self)) {
                part.append(" ...>");
                return runtime.newString(part.toString());
            }
            try {
                runtime.registerInspecting(self);
                RubyString rubyString = runtime.newString(BasicObjectStub.inspectObj(self, part).toString());
                return rubyString;
            }
            finally {
                runtime.unregisterInspecting(self);
            }
        }
        return RuntimeHelpers.invoke(runtime.getCurrentContext(), self, "to_s");
    }

    private static StringBuilder inspectObj(IRubyObject self, StringBuilder part) {
        ThreadContext context = BasicObjectStub.getRuntime(self).getCurrentContext();
        String sep = "";
        for (Variable<IRubyObject> ivar : BasicObjectStub.getInstanceVariables(self).getInstanceVariableList()) {
            part.append(sep).append(" ").append(ivar.getName()).append("=");
            part.append(ivar.getValue().callMethod(context, "inspect"));
            sep = ",";
        }
        part.append(">");
        return part;
    }

    public static IRubyObject rbClone(IRubyObject self) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static boolean isModule(IRubyObject self) {
        return false;
    }

    public static boolean isClass(IRubyObject self) {
        return false;
    }

    public static void dataWrapStruct(IRubyObject self, Object obj) {
    }

    public static Object dataGetStruct(IRubyObject self) {
        return null;
    }

    public static Object dataGetStructChecked(IRubyObject self) {
        return null;
    }

    public static IRubyObject id(IRubyObject self) {
        return BasicObjectStub.getRuntime(self).newFixnum(System.identityHashCode(self));
    }

    public static IRubyObject op_equal(IRubyObject self, ThreadContext context, IRubyObject other) {
        return BasicObjectStub.getRuntime(self).newBoolean(self == other);
    }

    public static IRubyObject op_eqq(IRubyObject self, ThreadContext context, IRubyObject other) {
        return BasicObjectStub.getRuntime(self).newBoolean(self == other);
    }

    public static boolean eql(IRubyObject self, IRubyObject other) {
        return self == other;
    }

    public static void addFinalizer(IRubyObject self, IRubyObject finalizer) {
    }

    public static void removeFinalizers(IRubyObject self) {
    }

    public static boolean hasVariables(IRubyObject self) {
        return false;
    }

    public static int getVariableCount(IRubyObject self) {
        return 0;
    }

    public static void syncVariables(IRubyObject self, List<Variable<Object>> variables) {
    }

    public static List<Variable<Object>> getVariableList(IRubyObject self) {
        return Collections.EMPTY_LIST;
    }

    public static InstanceVariables getInstanceVariables(IRubyObject self) {
        return new DummyInstanceVariables(BasicObjectStub.getRuntime(self).getNil());
    }

    public static InternalVariables getInternalVariables(IRubyObject self) {
        return DUMMY_INTERNAL_VARIABLES;
    }

    public static List<String> getVariableNameList(IRubyObject self) {
        return Collections.EMPTY_LIST;
    }

    public static void copySpecialInstanceVariables(IRubyObject self, IRubyObject clone) {
    }

    public static Object getVariable(IRubyObject self, int index2) {
        return null;
    }

    public static void setVariable(IRubyObject self, int index2, Object value2) {
    }

    public static class DummyInternalVariables
    implements InternalVariables {
        public boolean hasInternalVariable(String name2) {
            return false;
        }

        public boolean fastHasInternalVariable(String internedName) {
            return false;
        }

        public Object getInternalVariable(String name2) {
            return null;
        }

        public Object fastGetInternalVariable(String internedName) {
            return null;
        }

        public void setInternalVariable(String name2, Object value2) {
        }

        public void fastSetInternalVariable(String internedName, Object value2) {
        }

        public Object removeInternalVariable(String name2) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DummyInstanceVariables
    implements InstanceVariables {
        private final IRubyObject nil;

        public DummyInstanceVariables(IRubyObject nil) {
            this.nil = nil;
        }

        @Override
        public boolean hasInstanceVariable(String name2) {
            return false;
        }

        @Override
        public boolean fastHasInstanceVariable(String internedName) {
            return false;
        }

        @Override
        public IRubyObject getInstanceVariable(String name2) {
            return this.nil;
        }

        @Override
        public IRubyObject fastGetInstanceVariable(String internedName) {
            return this.nil;
        }

        @Override
        public IRubyObject setInstanceVariable(String name2, IRubyObject value2) {
            return value2;
        }

        @Override
        public IRubyObject fastSetInstanceVariable(String internedName, IRubyObject value2) {
            return value2;
        }

        @Override
        public IRubyObject removeInstanceVariable(String name2) {
            return this.nil;
        }

        @Override
        public List<Variable<IRubyObject>> getInstanceVariableList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List<String> getInstanceVariableNameList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public void copyInstanceVariablesInto(InstanceVariables other) {
        }
    }
}

