/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.util.Arrays;

public class DERInteger
extends ASN1Object {
    byte[] bytes;

    public static DERInteger getInstance(Object object) {
        if (object == null || object instanceof DERInteger) {
            return (DERInteger)object;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERInteger getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        DERObject dERObject = aSN1TaggedObject.getObject();
        if (bl || dERObject instanceof DERInteger) {
            return DERInteger.getInstance(dERObject);
        }
        return new ASN1Integer(ASN1OctetString.getInstance(aSN1TaggedObject.getObject()).getOctets());
    }

    public DERInteger(int n) {
        this.bytes = BigInteger.valueOf(n).toByteArray();
    }

    public DERInteger(BigInteger bigInteger) {
        this.bytes = bigInteger.toByteArray();
    }

    public DERInteger(byte[] byArray) {
        this.bytes = byArray;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(2, this.bytes);
    }

    public int hashCode() {
        int n = 0;
        for (int j = 0; j != this.bytes.length; ++j) {
            n ^= (this.bytes[j] & 0xFF) << j % 4;
        }
        return n;
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERInteger)) {
            return false;
        }
        DERInteger dERInteger = (DERInteger)dERObject;
        return Arrays.areEqual(this.bytes, dERInteger.bytes);
    }

    public String toString() {
        return this.getValue().toString();
    }
}

