/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.NativeType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Type {
    public static final Type VOID = Type.builtin(NativeType.VOID);
    public static final Type FLOAT = Type.builtin(NativeType.FLOAT);
    public static final Type DOUBLE = Type.builtin(NativeType.DOUBLE);
    public static final Type LONGDOUBLE = Type.builtin(NativeType.LONGDOUBLE);
    public static final Type UINT8 = Type.builtin(NativeType.UINT8);
    public static final Type SINT8 = Type.builtin(NativeType.SINT8);
    public static final Type UINT16 = Type.builtin(NativeType.UINT16);
    public static final Type SINT16 = Type.builtin(NativeType.SINT16);
    public static final Type UINT32 = Type.builtin(NativeType.UINT32);
    public static final Type SINT32 = Type.builtin(NativeType.SINT32);
    public static final Type UINT64 = Type.builtin(NativeType.UINT64);
    public static final Type SINT64 = Type.builtin(NativeType.SINT64);
    public static final Type POINTER = Type.builtin(NativeType.POINTER);
    public static final Type UCHAR = UINT8;
    public static final Type SCHAR = SINT8;
    public static final Type USHORT = UINT16;
    public static final Type SSHORT = SINT16;
    public static final Type UINT = UINT32;
    public static final Type SINT = SINT32;
    public static final Type ULONG = Type.builtin(NativeType.ULONG);
    public static final Type SLONG = Type.builtin(NativeType.SLONG);
    public static final Type ULONG_LONG = UINT64;
    public static final Type SLONG_LONG = SINT64;

    public abstract int type();

    abstract long handle();

    public abstract int size();

    public abstract int alignment();

    public boolean equals(Object obj) {
        return obj instanceof Type && ((Type)obj).handle() == this.handle();
    }

    public int hashCode() {
        int hash2 = 3;
        hash2 = 67 * hash2 + (int)(this.handle() ^ this.handle() >>> 32);
        return hash2;
    }

    static final long[] nativeHandles(Type[] types) {
        long[] nativeTypes = new long[types.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            nativeTypes[i2] = types[i2].handle();
        }
        return nativeTypes;
    }

    static final long[] nativeHandles(List<Type> types) {
        long[] nativeTypes = new long[types.size()];
        for (int i2 = 0; i2 < nativeTypes.length; ++i2) {
            nativeTypes[i2] = types.get(i2).handle();
        }
        return nativeTypes;
    }

    private static final Type builtin(NativeType nativeType) {
        return new Builtin(nativeType);
    }

    private static final class BuiltinTypeInfo {
        public static final BuiltinTypeInfo[] typeMap;
        final int type;
        final int size;
        final int alignment;
        final long handle;

        static BuiltinTypeInfo find(NativeType t) {
            return typeMap[t.ordinal()];
        }

        private BuiltinTypeInfo(long handle, int type2, int size2, int alignment2) {
            this.handle = handle;
            this.type = type2;
            this.size = size2;
            this.alignment = alignment2;
        }

        static {
            NativeType[] nativeTypes = NativeType.values();
            typeMap = new BuiltinTypeInfo[nativeTypes.length];
            for (int i2 = 0; i2 < typeMap.length; ++i2) {
                int alignment2;
                int size2;
                int type2;
                long h = Foreign.getInstance().lookupBuiltinType(nativeTypes[i2].ffiType);
                if (h != 0L) {
                    type2 = Foreign.getInstance().getTypeType(h);
                    size2 = Foreign.getInstance().getTypeSize(h);
                    alignment2 = Foreign.getInstance().getTypeAlign(h);
                } else {
                    type2 = nativeTypes[i2].ffiType;
                    size2 = 0;
                    alignment2 = 0;
                }
                BuiltinTypeInfo.typeMap[i2] = new BuiltinTypeInfo(h, type2, size2, alignment2);
            }
        }
    }

    static final class Builtin
    extends Type {
        private final NativeType nativeType;

        private Builtin(NativeType nativeType) {
            this.nativeType = nativeType;
        }

        public final int type() {
            return BuiltinTypeInfo.find((NativeType)this.nativeType).type;
        }

        public final long handle() {
            long handle = BuiltinTypeInfo.find((NativeType)this.nativeType).handle;
            if (handle != 0L) {
                return handle;
            }
            throw new RuntimeException("invalid handle for native type " + (Object)((Object)this.nativeType));
        }

        public final int size() {
            return BuiltinTypeInfo.find((NativeType)this.nativeType).size;
        }

        public final int alignment() {
            return BuiltinTypeInfo.find((NativeType)this.nativeType).alignment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Builtin builtin = (Builtin)o;
            return this.nativeType == builtin.nativeType;
        }

        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.nativeType.hashCode();
            return result2;
        }
    }
}

