/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefineClassInstr
extends Instr
implements ResultInstr {
    private IRClassBody newIRClassBody;
    private Operand container;
    private Operand superClass;
    private Variable result;

    public DefineClassInstr(Variable result2, IRClassBody newIRClassBody, Operand container, Operand superClass) {
        super(Operation.DEF_CLASS);
        assert (result2 != null) : "DefineClassInstr result is null";
        this.container = container;
        this.superClass = superClass == null ? newIRClassBody.getManager().getNil() : superClass;
        this.newIRClassBody = newIRClassBody;
        this.result = result2;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.container, this.superClass};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.container = this.container.getSimplifiedOperand(valueMap, force);
        this.superClass = this.superClass.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.newIRClassBody.getName() + ", " + this.container + ", " + this.superClass + ", " + this.newIRClassBody.getFileName() + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new DefineClassInstr(ii.getRenamedVariable(this.result), this.newIRClassBody, this.container.cloneForInlining(ii), this.superClass.cloneForInlining(ii));
    }

    private RubyModule newClass(ThreadContext context, IRubyObject self, RubyModule classContainer, DynamicScope currDynScope, Object[] temp) {
        RubyClass sc;
        if (this.newIRClassBody instanceof IRMetaClassBody) {
            return classContainer.getMetaClass();
        }
        if (this.superClass == context.runtime.getIRManager().getNil()) {
            sc = null;
        } else {
            Object o = this.superClass.retrieve(context, self, currDynScope, temp);
            if (!(o instanceof RubyClass)) {
                throw context.runtime.newTypeError("superclass must be Class (" + o + " given)");
            }
            sc = (RubyClass)o;
        }
        return classContainer.defineOrGetClassUnder(this.newIRClassBody.getName(), sc);
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        Object rubyContainer = this.container.retrieve(context, self, currDynScope, temp);
        if (!(rubyContainer instanceof RubyModule)) {
            throw context.runtime.newTypeError("no outer class/module");
        }
        RubyModule newRubyClass = this.newClass(context, self, (RubyModule)rubyContainer, currDynScope, temp);
        this.newIRClassBody.getStaticScope().setModule(newRubyClass);
        return new InterpretedIRMethod(this.newIRClassBody, Visibility.PUBLIC, newRubyClass);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DefineClassInstr(this);
    }

    public IRClassBody getNewIRClassBody() {
        return this.newIRClassBody;
    }

    public Operand getContainer() {
        return this.container;
    }

    public Operand getSuperClass() {
        return this.superClass;
    }
}

