/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.osgi;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EvalFailedException;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.osgi.internal.JRubyOSGiBundleClassLoader;
import org.jruby.embed.osgi.internal.OSGiLoadService;
import org.jruby.embed.osgi.utils.OSGiFileLocator;
import org.osgi.framework.Bundle;

public class OSGiScriptingContainer
extends ScriptingContainer {
    public OSGiScriptingContainer(Bundle creator) {
        this(creator, LocalContextScope.SINGLETHREAD, LocalVariableBehavior.TRANSIENT);
    }

    public OSGiScriptingContainer(Bundle creator, LocalContextScope scope, LocalVariableBehavior behavior) {
        super(scope, behavior);
        if (creator != null) {
            super.setClassLoader(new JRubyOSGiBundleClassLoader(creator));
        } else {
            super.setClassLoader(new JRubyOSGiBundleClassLoader());
        }
        super.setLoadServiceCreator(OSGiLoadService.OSGI_DEFAULT);
        try {
            super.setHomeDirectory(OSGiFileLocator.getJRubyHomeFolder().getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object runScriptlet(String bundleSymbolicName, String path2) {
        Bundle bundle = OSGiFileLocator.getBundle(bundleSymbolicName);
        if (bundle == null) {
            throw new IllegalArgumentException("Unable to find the bundle '" + bundleSymbolicName + "'");
        }
        return this.runScriptlet(bundle, path2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object runScriptlet(Bundle bundle, String path2) {
        Object object;
        URL url = bundle.getEntry(path2);
        if (url == null) {
            throw new IllegalArgumentException("Unable to find the entry '" + path2 + "' in the bundle " + bundle.getSymbolicName());
        }
        this.addToClassPath(bundle);
        BufferedInputStream istream = null;
        try {
            try {
                istream = new BufferedInputStream(url.openStream());
                object = this.runScriptlet(istream, this.getFilename(bundle, path2));
                Object var7_7 = null;
                if (istream == null) return object;
            }
            catch (IOException ioe) {
                throw new EvalFailedException(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (istream == null) throw throwable;
            try {
                ((InputStream)istream).close();
                throw throwable;
            }
            catch (IOException ioe2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe2) {
            // empty catch block
            return object;
        }
        ((InputStream)istream).close();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EmbedEvalUnit parse(Bundle bundle, String path2, int ... lines2) throws IOException {
        EmbedEvalUnit embedEvalUnit;
        URL url = bundle.getEntry(path2);
        BufferedInputStream istream = null;
        try {
            try {
                istream = new BufferedInputStream(url.openStream());
                embedEvalUnit = super.parse(istream, this.getFilename(bundle, path2), new int[0]);
                Object var8_8 = null;
                if (istream == null) return embedEvalUnit;
            }
            catch (IOException ioe) {
                throw new EvalFailedException(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (istream == null) throw throwable;
            try {
                ((InputStream)istream).close();
                throw throwable;
            }
            catch (IOException ioe2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe2) {
            // empty catch block
            return embedEvalUnit;
        }
        ((InputStream)istream).close();
        return embedEvalUnit;
    }

    private String getFilename(Bundle bundle, String path2) {
        return "bundle:/" + bundle.getSymbolicName() + (path2.charAt(0) == '/' ? path2 : "/" + path2);
    }

    public void addToClassPath(Bundle bundle) {
        this.getOSGiBundleClassLoader().addBundle(bundle);
    }

    public JRubyOSGiBundleClassLoader getOSGiBundleClassLoader() {
        return (JRubyOSGiBundleClassLoader)super.getClassLoader();
    }
}

