/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.ReflectedCompiledMethod;
import org.jruby.internal.runtime.methods.ReflectedJavaMethod;
import org.jruby.internal.runtime.methods.ReflectedJavaMultiMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.CompiledBlockCallback19;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionMethodFactory
extends MethodFactory {
    @Override
    public DynamicMethod getCompiledMethodLazily(RubyModule implementationClass, String methodName, Arity arity2, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig, ISourcePosition position, String parameterDesc) {
        return this.getCompiledMethod(implementationClass, methodName, arity2, visibility, scope, scriptObject, callConfig, position, parameterDesc);
    }

    @Override
    public DynamicMethod getCompiledMethod(RubyModule implementationClass, String methodName, Arity arity2, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig, ISourcePosition position, String parameterDesc) {
        try {
            Class<?> scriptClass = scriptObject.getClass();
            Method method2 = scriptClass.getMethod(methodName, scriptClass, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
            return new ReflectedCompiledMethod(implementationClass, arity2, visibility, scope, scriptObject, method2, callConfig, position, parameterDesc);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("No method with name " + methodName + " found in " + scriptObject.getClass());
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, JavaMethodDescriptor desc) {
        try {
            if (!Modifier.isPublic(desc.getDeclaringClass().getModifiers())) {
                System.err.println("warning: binding non-public class" + desc.declaringClassName + "; reflected handles won't work");
            }
            Method method2 = desc.getDeclaringClass().getDeclaredMethod(desc.name, desc.getParameterClasses());
            ReflectedJavaMethod ic = new ReflectedJavaMethod(implementationClass, method2, desc.anno);
            ic.setIsBuiltin(true);
            ic.setJavaName(method2.getName());
            ic.setSingleton(Modifier.isStatic(method2.getModifiers()));
            ic.setCallConfig(CallConfiguration.getCallConfigByAnno(desc.anno));
            return ic;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, List<JavaMethodDescriptor> descs) {
        try {
            if (!Modifier.isPublic(descs.get(0).getDeclaringClass().getModifiers())) {
                System.err.println("warning: binding non-public class" + descs.get((int)0).declaringClassName + "; reflected handles won't work");
            }
            ArrayList<Method> methods2 = new ArrayList<Method>();
            ArrayList<JRubyMethod> annotations2 = new ArrayList<JRubyMethod>();
            for (JavaMethodDescriptor desc : descs) {
                methods2.add(desc.getDeclaringClass().getDeclaredMethod(desc.name, desc.getParameterClasses()));
                annotations2.add(desc.anno);
            }
            Method method0 = (Method)methods2.get(0);
            JRubyMethod anno0 = (JRubyMethod)annotations2.get(0);
            ReflectedJavaMultiMethod ic = new ReflectedJavaMultiMethod(implementationClass, methods2, annotations2);
            ic.setIsBuiltin(true);
            ic.setJavaName(method0.getName());
            ic.setSingleton(Modifier.isStatic(method0.getModifiers()));
            ic.setCallConfig(CallConfiguration.getCallConfigByAnno(anno0));
            return ic;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompiledBlockCallback getBlockCallback(String method2, final String file2, final int line, final Object scriptObject) {
        try {
            Class<?> scriptClass = scriptObject.getClass();
            final Method blockMethod = scriptClass.getMethod(method2, scriptClass, ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class);
            return new CompiledBlockCallback(){

                public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject args2, Block block) {
                    try {
                        return (IRubyObject)blockMethod.invoke(null, scriptObject, context, self, args2, block);
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (InvocationTargetException ex) {
                        Throwable cause2 = ex.getCause();
                        if (cause2 instanceof RuntimeException) {
                            throw (RuntimeException)cause2;
                        }
                        if (cause2 instanceof Error) {
                            throw (Error)cause2;
                        }
                        throw new RuntimeException(ex);
                    }
                }

                public String getFile() {
                    return file2;
                }

                public int getLine() {
                    return line;
                }
            };
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    @Override
    public CompiledBlockCallback19 getBlockCallback19(String method2, final String file2, final int line, final Object scriptObject) {
        try {
            Class<?> scriptClass = scriptObject.getClass();
            final Method blockMethod = scriptClass.getMethod(method2, scriptClass, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
            return new CompiledBlockCallback19(){

                public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
                    try {
                        return (IRubyObject)blockMethod.invoke(null, scriptObject, context, self, args2, block);
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (InvocationTargetException ex) {
                        Throwable cause2 = ex.getCause();
                        if (cause2 instanceof RuntimeException) {
                            throw (RuntimeException)cause2;
                        }
                        if (cause2 instanceof Error) {
                            throw (Error)cause2;
                        }
                        throw new RuntimeException(ex);
                    }
                }

                public String getFile() {
                    return file2;
                }

                public int getLine() {
                    return line;
                }
            };
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }
}

