/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.List;
import org.jruby.RubyString;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.MultiOperandInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrAssignInstr
extends MultiOperandInstr {
    private static Operand[] buildArgsArray(Operand obj, Operand attr2, Operand v, List<Operand> args2) {
        Operand[] argsArray = new Operand[args2.size() + (v == null ? 2 : 3)];
        int i2 = 2;
        argsArray[0] = obj;
        argsArray[1] = attr2;
        if (v != null) {
            argsArray[2] = v;
            ++i2;
        }
        for (Operand o : args2) {
            argsArray[i2++] = o;
        }
        return argsArray;
    }

    public AttrAssignInstr(Operand obj, Operand attr2, List<Operand> args2) {
        super(Operation.ATTR_ASSIGN, null, AttrAssignInstr.buildArgsArray(obj, attr2, null, args2));
    }

    public AttrAssignInstr(Operand obj, Operand attr2, List<Operand> args2, Operand value2) {
        super(Operation.ATTR_ASSIGN, null, AttrAssignInstr.buildArgsArray(obj, attr2, value2, args2));
    }

    private AttrAssignInstr(Operand[] args2) {
        super(Operation.ATTR_ASSIGN, null, args2);
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        int i2 = 0;
        Operand[] clonedArgs = new Operand[this._args.length];
        for (Operand a : this._args) {
            clonedArgs[i2++] = a.cloneForInlining(ii);
        }
        return new AttrAssignInstr(clonedArgs);
    }

    @Override
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        Operand[] operands = this.getOperands();
        IRubyObject receiver2 = (IRubyObject)operands[0].retrieve(interp);
        String attr2 = ((RubyString)operands[1].retrieve(interp)).asJavaString();
        IRubyObject[] args2 = new IRubyObject[operands.length - 2];
        for (int i2 = 2; i2 < operands.length; ++i2) {
            args2[i2 - 2] = (IRubyObject)operands[i2].retrieve(interp);
        }
        receiver2.callMethod(interp.getContext(), attr2, args2);
        return null;
    }
}

