/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;
import org.jruby.util.PhantomReferenceReaper;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

@JRubyClass(name={"Tempfile"}, parent="File")
public class RubyTempfile
extends RubyFile {
    private static final ConcurrentMap<Reaper, Boolean> referenceSet;
    private volatile transient Reaper reaper;
    private static ObjectAllocator TEMPFILE_ALLOCATOR;
    private static final String DEFAULT_TMP_DIR;
    private static final Object tmpFileLock;
    private static int counter;
    private static final Random RND;
    private File tmpFile = null;

    public static RubyClass createTempfileClass(Ruby runtime2) {
        RubyClass tempfileClass = runtime2.defineClass("Tempfile", runtime2.getFile(), TEMPFILE_ALLOCATOR);
        RubyKernel.require(tempfileClass, runtime2.newString("tmpdir"), Block.NULL_BLOCK);
        tempfileClass.defineAnnotatedMethods(RubyTempfile.class);
        return tempfileClass;
    }

    public RubyTempfile(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(required=1, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        Ruby runtime2 = this.getRuntime();
        IRubyObject basename2 = args2[0];
        IRubyObject dir = this.defaultTmpDir(runtime2, args2);
        JRubyFile tmp = null;
        Object object = tmpFileLock;
        synchronized (object) {
            try {
                IRubyObject tmpname;
                do {
                    if (counter == -1) {
                        counter = RND.nextInt() & 0xFFFF;
                    }
                    tmpname = this.callMethod(runtime2.getCurrentContext(), "make_tmpname", new IRubyObject[]{basename2, runtime2.newFixnum(++counter)});
                } while (!((File)(tmp = JRubyFile.create(this.getRuntime().getCurrentDirectory(), new File(dir.convertToString().toString(), tmpname.convertToString().toString()).getPath()))).createNewFile());
                this.tmpFile = tmp;
                this.path = ((File)tmp).getPath();
                try {
                    this.tmpFile.deleteOnExit();
                }
                catch (NullPointerException npe) {
                }
                catch (IllegalStateException ise) {
                    // empty catch block
                }
                this.initializeOpen();
                this.reaper = new Reaper(this, runtime2, this.tmpFile, this.openFile);
                referenceSet.put(this.reaper, Boolean.TRUE);
                return this;
            }
            catch (IOException e) {
                throw runtime2.newIOErrorFromException(e);
            }
        }
    }

    private IRubyObject defaultTmpDir(Ruby runtime2, IRubyObject[] args2) {
        IRubyObject dir = null;
        if (args2.length == 2) {
            dir = args2[1];
        } else {
            runtime2.getLoadService().require("tmpdir");
            dir = runtime2.getDir().callMethod(runtime2.getCurrentContext(), "tmpdir");
        }
        if (runtime2.getSafeLevel() > 0 && dir.isTaint()) {
            dir = runtime2.newString(DEFAULT_TMP_DIR);
        }
        return dir;
    }

    private void initializeOpen() {
        try {
            ModeFlags modeFlags = new ModeFlags(ModeFlags.RDWR | ModeFlags.EXCL);
            this.getRuntime().getPosix().chmod(this.path, 384);
            this.sysopenInternal(this.path, modeFlags, 384);
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject make_tmpname(ThreadContext context, IRubyObject basename2, IRubyObject n, Block block) {
        IRubyObject suffix;
        IRubyObject base;
        Ruby runtime2 = context.getRuntime();
        IRubyObject[] newargs = new IRubyObject[5];
        if (basename2 instanceof RubyArray) {
            RubyArray array = (RubyArray)basename2;
            int length2 = array.getLength();
            base = length2 > 0 ? array.eltInternal(0) : runtime2.getNil();
            suffix = length2 > 0 ? array.eltInternal(1) : runtime2.getNil();
        } else {
            base = basename2;
            suffix = runtime2.newString("");
        }
        newargs[0] = runtime2.newString("%s.%d.%d%s");
        newargs[1] = base;
        newargs[2] = runtime2.getGlobalVariables().get("$$");
        newargs[3] = n;
        newargs[4] = suffix;
        return this.callMethod(context, "sprintf", newargs);
    }

    @JRubyMethod(visibility=Visibility.PUBLIC)
    public IRubyObject open() {
        if (!this.isClosed()) {
            this.close();
        }
        try {
            this.openInternal(this.path, "r+");
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PROTECTED)
    public IRubyObject _close(ThreadContext context) {
        return !this.isClosed() ? super.close() : context.getRuntime().getNil();
    }

    @JRubyMethod(optional=1, visibility=Visibility.PUBLIC)
    public IRubyObject close(ThreadContext context, IRubyObject[] args2, Block block) {
        boolean unlink2 = args2.length == 1 ? args2[0].isTrue() : false;
        return unlink2 ? this.close_bang(context) : this._close(context);
    }

    @JRubyMethod(name={"close!"}, visibility=Visibility.PUBLIC)
    public IRubyObject close_bang(ThreadContext context) {
        referenceSet.remove(this.reaper);
        this.reaper.released = true;
        this._close(context);
        this.tmpFile.delete();
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"unlink", "delete"})
    public IRubyObject unlink(ThreadContext context) {
        if (!this.tmpFile.exists() || this.tmpFile.delete()) {
            referenceSet.remove(this.reaper);
            this.reaper.released = true;
            this.path = null;
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size(ThreadContext context) {
        if (!this.isClosed()) {
            this.flush();
            return context.getRuntime().newFileStat(this.path, false).size();
        }
        return RubyFixnum.zero(context.getRuntime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyTempfile tempfile;
        block4: {
            Ruby runtime2 = context.getRuntime();
            RubyClass klass = (RubyClass)recv2;
            tempfile = (RubyTempfile)klass.newInstance(context, args2, block);
            if (!block.isGiven()) break block4;
            try {
                block.yield(context, tempfile);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (!tempfile.isClosed()) {
                    tempfile.close();
                }
                throw throwable;
            }
            if (!tempfile.isClosed()) {
                tempfile.close();
            }
            return runtime2.getNil();
        }
        return tempfile;
    }

    static {
        String tmpDir;
        referenceSet = new ConcurrentHashMap<Reaper, Boolean>();
        TEMPFILE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                RubyTempfile instance = new RubyTempfile(runtime2, klass);
                instance.setMetaClass(klass);
                return instance;
            }
        };
        tmpFileLock = new Object();
        counter = -1;
        RND = new Random();
        if (Platform.IS_WINDOWS) {
            tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null) {
                tmpDir = System.getenv("TEMP");
            }
            if (tmpDir == null) {
                tmpDir = System.getenv("TMP");
            }
            if (tmpDir == null) {
                tmpDir = "C:\\Windows\\Temp";
            }
        } else {
            tmpDir = "/tmp";
        }
        DEFAULT_TMP_DIR = tmpDir;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Reaper
    extends PhantomReferenceReaper<RubyTempfile>
    implements Runnable {
        private volatile boolean released = false;
        private final Ruby runtime;
        private final File tmpFile;
        private final OpenFile openFile;

        Reaper(RubyTempfile file2, Ruby runtime2, File tmpFile, OpenFile openFile) {
            super(file2);
            this.runtime = runtime2;
            this.tmpFile = tmpFile;
            this.openFile = openFile;
        }

        @Override
        public final void run() {
            referenceSet.remove(this);
            this.release();
            this.clear();
        }

        final void release() {
            if (!this.released) {
                this.released = true;
                if (this.openFile != null) {
                    this.openFile.cleanup(this.runtime, false);
                }
                if (this.tmpFile.exists()) {
                    boolean deleted = this.tmpFile.delete();
                    if (this.runtime.getDebug().isTrue()) {
                        String msg = "removing " + this.tmpFile.getPath() + " ... ";
                        if (deleted) {
                            this.runtime.getErr().println(msg + "done");
                        } else {
                            this.runtime.getErr().println(msg + "can't delete");
                        }
                    }
                }
            }
        }
    }
}

