/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import java.dyn.CallSite;
import java.dyn.Linkage;
import java.dyn.MethodHandle;
import java.dyn.MethodHandles;
import java.dyn.MethodType;
import java.dyn.MutableCallSite;
import java.dyn.NoAccessException;
import jruby.objectweb.asm.MethodVisitor;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.util.CodegenUtils;

public class InvokeDynamicSupport {
    private static final MethodType BOOTSTRAP_TYPE = MethodType.methodType(CallSite.class, Class.class, (Class[])new Class[]{String.class, MethodType.class});
    public static final MethodHandle BOOTSTRAP = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "bootstrap", BOOTSTRAP_TYPE);
    private static final MethodHandle GETMETHOD;
    private static final MethodHandle PGC;
    private static final MethodHandle TEST;
    private static final MethodHandle PGC_0;
    private static final MethodHandle GETMETHOD_0;
    private static final MethodHandle TEST_0;
    private static final MethodHandle TARGET_0;
    private static final MethodHandle FALLBACK_0;
    private static final MethodHandle PGC_1;
    private static final MethodHandle GETMETHOD_1;
    private static final MethodHandle TEST_1;
    private static final MethodHandle TARGET_1;
    private static final MethodHandle FALLBACK_1;
    private static final MethodHandle PGC_2;
    private static final MethodHandle GETMETHOD_2;
    private static final MethodHandle TEST_2;
    private static final MethodHandle TARGET_2;
    private static final MethodHandle FALLBACK_2;
    private static final MethodHandle PGC_3;
    private static final MethodHandle GETMETHOD_3;
    private static final MethodHandle TEST_3;
    private static final MethodHandle TARGET_3;
    private static final MethodHandle FALLBACK_3;
    private static final MethodHandle PGC_N;
    private static final MethodHandle GETMETHOD_N;
    private static final MethodHandle TEST_N;
    private static final MethodHandle TARGET_N;
    private static final MethodHandle FALLBACK_N;
    private static final MethodHandle BREAKJUMP;
    private static final MethodHandle RETRYJUMP;
    private static final MethodHandle PGC_0_B;
    private static final MethodHandle GETMETHOD_0_B;
    private static final MethodHandle TEST_0_B;
    private static final MethodHandle TARGET_0_B;
    private static final MethodHandle FALLBACK_0_B;
    private static final MethodHandle PGC_1_B;
    private static final MethodHandle GETMETHOD_1_B;
    private static final MethodHandle TEST_1_B;
    private static final MethodHandle TARGET_1_B;
    private static final MethodHandle FALLBACK_1_B;
    private static final MethodHandle PGC_2_B;
    private static final MethodHandle GETMETHOD_2_B;
    private static final MethodHandle TEST_2_B;
    private static final MethodHandle TARGET_2_B;
    private static final MethodHandle FALLBACK_2_B;
    private static final MethodHandle PGC_3_B;
    private static final MethodHandle GETMETHOD_3_B;
    private static final MethodHandle TEST_3_B;
    private static final MethodHandle TARGET_3_B;
    private static final MethodHandle FALLBACK_3_B;
    private static final MethodHandle PGC_N_B;
    private static final MethodHandle GETMETHOD_N_B;
    private static final MethodHandle TEST_N_B;
    private static final MethodHandle TARGET_N_B;
    private static final MethodHandle FALLBACK_N_B;

    public static CallSite bootstrap(Class caller2, String name2, MethodType type2) {
        JRubyCallSite site = name2 == "call" ? new JRubyCallSite(type2, CallType.NORMAL) : new JRubyCallSite(type2, CallType.FUNCTIONAL);
        MethodType fallbackType = type2.insertParameterTypes(0, new Class[]{JRubyCallSite.class});
        MethodHandle myFallback = MethodHandles.insertArguments((MethodHandle)InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "fallback", fallbackType), (int)0, (Object[])new Object[]{site});
        site.setTarget(myFallback);
        return site;
    }

    public static void installBytecode(MethodVisitor method2, String classname) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(method2);
        mv.ldc(CodegenUtils.c(classname));
        mv.invokestatic(CodegenUtils.p(Class.class), "forName", CodegenUtils.sig(Class.class, CodegenUtils.params(String.class)));
        mv.getstatic(CodegenUtils.p(InvokeDynamicSupport.class), "BOOTSTRAP", CodegenUtils.ci(MethodHandle.class));
        mv.invokestatic(CodegenUtils.p(Linkage.class), "registerBootstrapMethod", CodegenUtils.sig(Void.TYPE, Class.class, MethodHandle.class));
    }

    private static MethodHandle createGWT(MethodHandle test2, MethodHandle target, MethodHandle fallback, CacheEntry entry, JRubyCallSite site) {
        DynamicMethod.NativeCall nativeCall;
        Class[] nativeSig;
        if (entry.method.getNativeCall() != null && InvokeDynamicSupport.getArgCount(nativeSig = (nativeCall = entry.method.getNativeCall()).getNativeSignature(), nativeCall.isStatic()) != -1 && nativeSig.length > 0 && nativeSig[0] == ThreadContext.class && nativeSig[nativeSig.length - 1] != Block.class) {
            return InvokeDynamicSupport.createNativeGWT(nativeCall, test2, fallback, entry, site);
        }
        MethodHandle myTest = MethodHandles.insertArguments((MethodHandle)test2, (int)0, (Object[])new Object[]{entry.token});
        MethodHandle myTarget = MethodHandles.insertArguments((MethodHandle)target, (int)0, (Object[])new Object[]{entry});
        MethodHandle myFallback = MethodHandles.insertArguments((MethodHandle)fallback, (int)0, (Object[])new Object[]{site});
        MethodHandle guardWithTest = MethodHandles.guardWithTest((MethodHandle)myTest, (MethodHandle)myTarget, (MethodHandle)myFallback);
        return MethodHandles.convertArguments((MethodHandle)guardWithTest, (MethodType)site.type());
    }

    private static MethodHandle createNativeGWT(DynamicMethod.NativeCall nativeCall, MethodHandle test2, MethodHandle fallback, CacheEntry entry, JRubyCallSite site) {
        try {
            boolean isStatic = nativeCall.isStatic();
            MethodHandle nativeTarget = isStatic ? MethodHandles.lookup().findStatic(nativeCall.getNativeTarget(), nativeCall.getNativeName(), MethodType.methodType((Class)nativeCall.getNativeReturn(), (Class[])nativeCall.getNativeSignature())) : MethodHandles.lookup().findVirtual(nativeCall.getNativeTarget(), nativeCall.getNativeName(), MethodType.methodType((Class)nativeCall.getNativeReturn(), (Class[])nativeCall.getNativeSignature()));
            int argCount = InvokeDynamicSupport.getArgCount(nativeCall.getNativeSignature(), nativeCall.isStatic());
            switch (argCount) {
                case 0: {
                    int[] nArray;
                    MethodType methodType = site.type();
                    if (isStatic) {
                        int[] nArray2 = new int[2];
                        nArray2[0] = 0;
                        nArray = nArray2;
                        nArray2[1] = 2;
                    } else {
                        int[] nArray3 = new int[2];
                        nArray3[0] = 2;
                        nArray = nArray3;
                        nArray3[1] = 0;
                    }
                    nativeTarget = MethodHandles.permuteArguments((MethodHandle)nativeTarget, (MethodType)methodType, (int[])nArray);
                    break;
                }
                case -1: 
                case 1: {
                    int[] nArray;
                    MethodType methodType = site.type();
                    if (isStatic) {
                        int[] nArray4 = new int[3];
                        nArray4[0] = 0;
                        nArray4[1] = 2;
                        nArray = nArray4;
                        nArray4[2] = 4;
                    } else {
                        int[] nArray5 = new int[3];
                        nArray5[0] = 2;
                        nArray5[1] = 0;
                        nArray = nArray5;
                        nArray5[2] = 4;
                    }
                    nativeTarget = MethodHandles.permuteArguments((MethodHandle)nativeTarget, (MethodType)methodType, (int[])nArray);
                    break;
                }
                case 2: {
                    int[] nArray;
                    MethodType methodType = site.type();
                    if (isStatic) {
                        int[] nArray6 = new int[4];
                        nArray6[0] = 0;
                        nArray6[1] = 2;
                        nArray6[2] = 4;
                        nArray = nArray6;
                        nArray6[3] = 5;
                    } else {
                        int[] nArray7 = new int[4];
                        nArray7[0] = 2;
                        nArray7[1] = 0;
                        nArray7[2] = 4;
                        nArray = nArray7;
                        nArray7[3] = 5;
                    }
                    nativeTarget = MethodHandles.permuteArguments((MethodHandle)nativeTarget, (MethodType)methodType, (int[])nArray);
                    break;
                }
                case 3: {
                    int[] nArray;
                    MethodType methodType = site.type();
                    if (isStatic) {
                        int[] nArray8 = new int[5];
                        nArray8[0] = 0;
                        nArray8[1] = 2;
                        nArray8[2] = 4;
                        nArray8[3] = 5;
                        nArray = nArray8;
                        nArray8[4] = 6;
                    } else {
                        int[] nArray9 = new int[5];
                        nArray9[0] = 2;
                        nArray9[1] = 0;
                        nArray9[2] = 4;
                        nArray9[3] = 5;
                        nArray = nArray9;
                        nArray9[4] = 6;
                    }
                    nativeTarget = MethodHandles.permuteArguments((MethodHandle)nativeTarget, (MethodType)methodType, (int[])nArray);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown arg count: " + argCount);
                }
            }
            MethodHandle myFallback = MethodHandles.insertArguments((MethodHandle)fallback, (int)0, (Object[])new Object[]{site});
            MethodHandle myTest = MethodHandles.insertArguments((MethodHandle)test2, (int)0, (Object[])new Object[]{entry.token});
            MethodHandle gwt = MethodHandles.guardWithTest((MethodHandle)myTest, (MethodHandle)nativeTarget, (MethodHandle)myFallback);
            return MethodHandles.convertArguments((MethodHandle)gwt, (MethodType)site.type());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int getArgCount(Class[] args2, boolean isStatic) {
        int length2 = args2.length;
        boolean hasContext = false;
        if (isStatic) {
            if (args2.length > 1 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            if (args2.length > 1 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 2) {
                if (hasContext && args2[2] == IRubyObject[].class) {
                    length2 = -1;
                } else if (args2[1] == IRubyObject[].class) {
                    length2 = -1;
                }
            }
        } else {
            if (args2.length > 0 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            if (args2.length > 0 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 1) {
                if (hasContext && args2[1] == IRubyObject[].class) {
                    length2 = -1;
                } else if (args2[0] == IRubyObject[].class) {
                    length2 = -1;
                }
            }
        }
        return length2;
    }

    public static boolean test(int token, IRubyObject self) {
        return token == ((RubyBasicObject)self).getMetaClass().getCacheToken();
    }

    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, String name2) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2);
        }
        site.setTarget(InvokeDynamicSupport.createGWT(TEST_0, TARGET_0, FALLBACK_0, entry, site));
        return entry.method.call(context, self, selfClass, name2);
    }

    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, String name2, IRubyObject arg0) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0);
        }
        site.setTarget(InvokeDynamicSupport.createGWT(TEST_1, TARGET_1, FALLBACK_1, entry, site));
        return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0);
    }

    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1);
        }
        site.setTarget(InvokeDynamicSupport.createGWT(TEST_2, TARGET_2, FALLBACK_2, entry, site));
        return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1);
    }

    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1, arg2);
        }
        site.setTarget(InvokeDynamicSupport.createGWT(TEST_3, TARGET_3, FALLBACK_3, entry, site));
        return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1, arg2);
    }

    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, String name2, IRubyObject[] args2) {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        CacheEntry entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, args2);
        }
        site.setTarget(InvokeDynamicSupport.createGWT(TEST_N, TARGET_N, FALLBACK_N, entry, site));
        return entry.method.call(context, self, (RubyModule)selfClass, name2, args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, String name2, Block block) {
        IRubyObject iRubyObject;
        block8: {
            RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
            CacheEntry entry = selfClass.searchWithCache(name2);
            try {
                IRubyObject iRubyObject2;
                block7: {
                    try {
                        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
                            iRubyObject2 = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, block);
                            Object var11_12 = null;
                            break block7;
                        }
                        site.setTarget(InvokeDynamicSupport.createGWT(TEST_0_B, TARGET_0_B, FALLBACK_0_B, entry, site));
                        iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, block);
                        break block8;
                    }
                    catch (JumpException.BreakJump bj) {
                        IRubyObject iRubyObject3 = InvokeDynamicSupport.handleBreakJump(context, bj);
                        Object var11_14 = null;
                        block.escape();
                        return iRubyObject3;
                    }
                    catch (JumpException.RetryJump rj) {
                        IRubyObject iRubyObject4 = InvokeDynamicSupport.retryJumpError(context);
                        Object var11_15 = null;
                        block.escape();
                        return iRubyObject4;
                    }
                }
                block.escape();
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                block.escape();
                throw throwable;
            }
        }
        Object var11_13 = null;
        block.escape();
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, String name2, IRubyObject arg0, Block block) {
        IRubyObject iRubyObject;
        block8: {
            RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
            CacheEntry entry = selfClass.searchWithCache(name2);
            try {
                IRubyObject iRubyObject2;
                block7: {
                    try {
                        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
                            iRubyObject2 = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, block);
                            Object var12_13 = null;
                            break block7;
                        }
                        site.setTarget(InvokeDynamicSupport.createGWT(TEST_1_B, TARGET_1_B, FALLBACK_1_B, entry, site));
                        iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, block);
                        break block8;
                    }
                    catch (JumpException.BreakJump bj) {
                        IRubyObject iRubyObject3 = InvokeDynamicSupport.handleBreakJump(context, bj);
                        Object var12_15 = null;
                        block.escape();
                        return iRubyObject3;
                    }
                    catch (JumpException.RetryJump rj) {
                        IRubyObject iRubyObject4 = InvokeDynamicSupport.retryJumpError(context);
                        Object var12_16 = null;
                        block.escape();
                        return iRubyObject4;
                    }
                }
                block.escape();
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                block.escape();
                throw throwable;
            }
        }
        Object var12_14 = null;
        block.escape();
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject iRubyObject;
        block8: {
            RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
            CacheEntry entry = selfClass.searchWithCache(name2);
            try {
                IRubyObject iRubyObject2;
                block7: {
                    try {
                        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
                            iRubyObject2 = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1, block);
                            Object var13_14 = null;
                            break block7;
                        }
                        site.setTarget(InvokeDynamicSupport.createGWT(TEST_2_B, TARGET_2_B, FALLBACK_2_B, entry, site));
                        iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1, block);
                        break block8;
                    }
                    catch (JumpException.BreakJump bj) {
                        IRubyObject iRubyObject3 = InvokeDynamicSupport.handleBreakJump(context, bj);
                        Object var13_16 = null;
                        block.escape();
                        return iRubyObject3;
                    }
                    catch (JumpException.RetryJump rj) {
                        IRubyObject iRubyObject4 = InvokeDynamicSupport.retryJumpError(context);
                        Object var13_17 = null;
                        block.escape();
                        return iRubyObject4;
                    }
                }
                block.escape();
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                block.escape();
                throw throwable;
            }
        }
        Object var13_15 = null;
        block.escape();
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        IRubyObject iRubyObject;
        block8: {
            RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
            CacheEntry entry = selfClass.searchWithCache(name2);
            try {
                IRubyObject iRubyObject2;
                block7: {
                    try {
                        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
                            iRubyObject2 = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1, arg2, block);
                            Object var14_15 = null;
                            break block7;
                        }
                        site.setTarget(InvokeDynamicSupport.createGWT(TEST_3_B, TARGET_3_B, FALLBACK_3_B, entry, site));
                        iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1, arg2, block);
                        break block8;
                    }
                    catch (JumpException.BreakJump bj) {
                        IRubyObject iRubyObject3 = InvokeDynamicSupport.handleBreakJump(context, bj);
                        Object var14_17 = null;
                        block.escape();
                        return iRubyObject3;
                    }
                    catch (JumpException.RetryJump rj) {
                        IRubyObject iRubyObject4 = InvokeDynamicSupport.retryJumpError(context);
                        Object var14_18 = null;
                        block.escape();
                        return iRubyObject4;
                    }
                }
                block.escape();
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                block.escape();
                throw throwable;
            }
        }
        Object var14_16 = null;
        block.escape();
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject fallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, String name2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        block8: {
            RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
            CacheEntry entry = selfClass.searchWithCache(name2);
            try {
                IRubyObject iRubyObject2;
                block7: {
                    try {
                        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
                            iRubyObject2 = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, args2, block);
                            Object var12_13 = null;
                            break block7;
                        }
                        site.setTarget(InvokeDynamicSupport.createGWT(TEST_N_B, TARGET_N_B, FALLBACK_N_B, entry, site));
                        iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, args2, block);
                        break block8;
                    }
                    catch (JumpException.BreakJump bj) {
                        IRubyObject iRubyObject3 = InvokeDynamicSupport.handleBreakJump(context, bj);
                        Object var12_15 = null;
                        block.escape();
                        return iRubyObject3;
                    }
                    catch (JumpException.RetryJump rj) {
                        IRubyObject iRubyObject4 = InvokeDynamicSupport.retryJumpError(context);
                        Object var12_16 = null;
                        block.escape();
                        return iRubyObject4;
                    }
                }
                block.escape();
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                block.escape();
                throw throwable;
            }
        }
        Object var12_14 = null;
        block.escape();
        return iRubyObject;
    }

    protected static boolean methodMissing(CacheEntry entry, CallType callType, String name2, IRubyObject caller2) {
        DynamicMethod method2 = entry.method;
        return method2.isUndefined() || callType == CallType.NORMAL && !name2.equals("method_missing") && !method2.isCallableFrom(caller2, callType);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, args2, Block.NULL_BLOCK);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, Block.NULL_BLOCK);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, block);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg2) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg2, Block.NULL_BLOCK);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, args2, block);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, block);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1, Block.NULL_BLOCK);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1, block);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1, arg2, Block.NULL_BLOCK);
    }

    private static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1, arg2, block);
    }

    public static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self) {
        context.callThreadPoll();
        RubyClass selfType = self.getMetaClass();
        return selfType;
    }

    public static IRubyObject handleBreakJump(JumpException.BreakJump bj, ThreadContext context) throws JumpException.BreakJump {
        if (context.getFrameJumpTarget() == bj.getTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    private static IRubyObject handleBreakJump(ThreadContext context, JumpException.BreakJump bj) throws JumpException.BreakJump {
        if (context.getFrameJumpTarget() == bj.getTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    public static IRubyObject retryJumpError(ThreadContext context) {
        throw context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.RETRY, context.getRuntime().getNil(), "retry outside of rescue not supported");
    }

    public static final DynamicMethod getMethod(CacheEntry entry) {
        return entry.method;
    }

    private static MethodHandle dropNameAndArgs(MethodHandle original, int index2, int count2, boolean block) {
        switch (count2) {
            case -1: {
                if (block) {
                    return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject[].class, Block.class});
                }
                return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject[].class});
            }
            case 0: {
                if (block) {
                    return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, Block.class});
                }
                return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class});
            }
            case 1: {
                if (block) {
                    return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject.class, Block.class});
                }
                return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject.class});
            }
            case 2: {
                if (block) {
                    return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject.class, IRubyObject.class, Block.class});
                }
                return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject.class, IRubyObject.class});
            }
            case 3: {
                if (block) {
                    return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class});
                }
                return MethodHandles.dropArguments((MethodHandle)original, (int)index2, (Class[])new Class[]{String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class});
            }
        }
        throw new RuntimeException("Invalid arg count (" + count2 + ") while preparing method handle:\n\t" + original);
    }

    private static MethodHandle findStatic(Class target, String name2, MethodType type2) {
        try {
            return MethodHandles.lookup().findStatic(target, name2, type2);
        }
        catch (NoAccessException nae) {
            throw new RuntimeException(nae);
        }
    }

    private static MethodHandle findVirtual(Class target, String name2, MethodType type2) {
        try {
            return MethodHandles.lookup().findVirtual(target, name2, type2);
        }
        catch (NoAccessException nae) {
            throw new RuntimeException(nae);
        }
    }

    static {
        MethodHandle getMethod = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "getMethod", MethodType.methodType(DynamicMethod.class, CacheEntry.class));
        getMethod = MethodHandles.dropArguments((MethodHandle)getMethod, (int)0, (Class[])new Class[]{RubyClass.class});
        GETMETHOD = getMethod = MethodHandles.dropArguments((MethodHandle)getMethod, (int)2, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class});
        PGC = MethodHandles.dropArguments((MethodHandle)MethodHandles.dropArguments((MethodHandle)InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "pollAndGetClass", MethodType.methodType(RubyClass.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class})), (int)1, (Class[])new Class[]{IRubyObject.class}), (int)0, (Class[])new Class[]{CacheEntry.class});
        TEST = MethodHandles.dropArguments((MethodHandle)InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "test", MethodType.methodType(Boolean.TYPE, Integer.TYPE, (Class[])new Class[]{IRubyObject.class})), (int)1, (Class[])new Class[]{ThreadContext.class, IRubyObject.class});
        PGC_0 = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 0, false);
        GETMETHOD_0 = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 0, false);
        TEST_0 = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 0, false);
        MethodHandle target = InvokeDynamicSupport.findVirtual(DynamicMethod.class, "call", MethodType.methodType(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class}), (int[])new int[]{0, 3, 5, 1, 6});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_0);
        TARGET_0 = target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_0);
        FALLBACK_0 = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "fallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class}));
        PGC_1 = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 1, false);
        GETMETHOD_1 = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 1, false);
        TEST_1 = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 1, false);
        target = InvokeDynamicSupport.findVirtual(DynamicMethod.class, "call", MethodType.methodType(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class}), (int[])new int[]{0, 3, 5, 1, 6, 7});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_1);
        TARGET_1 = target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_1);
        FALLBACK_1 = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "fallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class}));
        PGC_2 = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 2, false);
        GETMETHOD_2 = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 2, false);
        TEST_2 = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 2, false);
        target = InvokeDynamicSupport.findVirtual(DynamicMethod.class, "call", MethodType.methodType(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject.class, IRubyObject.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class}), (int[])new int[]{0, 3, 5, 1, 6, 7, 8});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_2);
        TARGET_2 = target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_2);
        FALLBACK_2 = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "fallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class}));
        PGC_3 = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 3, false);
        GETMETHOD_3 = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 3, false);
        TEST_3 = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 3, false);
        target = InvokeDynamicSupport.findVirtual(DynamicMethod.class, "call", MethodType.methodType(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class}), (int[])new int[]{0, 3, 5, 1, 6, 7, 8, 9});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_3);
        TARGET_3 = target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_3);
        FALLBACK_3 = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "fallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class}));
        PGC_N = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, -1, false);
        GETMETHOD_N = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, -1, false);
        TEST_N = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, -1, false);
        target = InvokeDynamicSupport.findVirtual(DynamicMethod.class, "call", MethodType.methodType(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject[].class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject[].class}), (int[])new int[]{0, 3, 5, 1, 6, 7});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_N);
        TARGET_N = target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_N);
        FALLBACK_N = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "fallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject[].class}));
        MethodHandle breakJump = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "handleBreakJump", MethodType.methodType(IRubyObject.class, JumpException.BreakJump.class, (Class[])new Class[]{ThreadContext.class}));
        BREAKJUMP = breakJump = MethodHandles.permuteArguments((MethodHandle)breakJump, (MethodType)MethodType.methodType(IRubyObject.class, JumpException.BreakJump.class, (Class[])new Class[]{CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class}), (int[])new int[]{0, 2});
        MethodHandle retryJump = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "retryJumpError", MethodType.methodType(IRubyObject.class, ThreadContext.class));
        RETRYJUMP = retryJump = MethodHandles.permuteArguments((MethodHandle)retryJump, (MethodType)MethodType.methodType(IRubyObject.class, JumpException.RetryJump.class, (Class[])new Class[]{CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class}), (int[])new int[]{2});
        PGC_0_B = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 0, true);
        GETMETHOD_0_B = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 0, true);
        TEST_0_B = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 0, true);
        target = InvokeDynamicSupport.findVirtual(DynamicMethod.class, "call", MethodType.methodType(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, Block.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, Block.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, Block.class}), (int[])new int[]{0, 3, 5, 1, 6, 7});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_0_B);
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_0_B);
        MethodHandle breakJump2 = InvokeDynamicSupport.dropNameAndArgs(BREAKJUMP, 5, 0, true);
        MethodHandle retryJump2 = InvokeDynamicSupport.dropNameAndArgs(RETRYJUMP, 5, 0, true);
        target = MethodHandles.catchException((MethodHandle)target, JumpException.BreakJump.class, (MethodHandle)breakJump2);
        TARGET_0_B = target = MethodHandles.catchException((MethodHandle)target, JumpException.RetryJump.class, (MethodHandle)retryJump2);
        FALLBACK_0_B = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "fallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, Block.class}));
        PGC_1_B = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 1, true);
        GETMETHOD_1_B = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 1, true);
        TEST_1_B = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 1, true);
        target = InvokeDynamicSupport.findVirtual(DynamicMethod.class, "call", MethodType.methodType(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, Block.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject.class, Block.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, Block.class}), (int[])new int[]{0, 3, 5, 1, 6, 7, 8});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_1_B);
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_1_B);
        breakJump2 = InvokeDynamicSupport.dropNameAndArgs(BREAKJUMP, 5, 1, true);
        retryJump2 = InvokeDynamicSupport.dropNameAndArgs(RETRYJUMP, 5, 1, true);
        target = MethodHandles.catchException((MethodHandle)target, JumpException.BreakJump.class, (MethodHandle)breakJump2);
        TARGET_1_B = target = MethodHandles.catchException((MethodHandle)target, JumpException.RetryJump.class, (MethodHandle)retryJump2);
        FALLBACK_1_B = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "fallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, Block.class}));
        PGC_2_B = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 2, true);
        GETMETHOD_2_B = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 2, true);
        TEST_2_B = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 2, true);
        target = InvokeDynamicSupport.findVirtual(DynamicMethod.class, "call", MethodType.methodType(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, Block.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject.class, IRubyObject.class, Block.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, Block.class}), (int[])new int[]{0, 3, 5, 1, 6, 7, 8, 9});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_2_B);
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_2_B);
        breakJump2 = InvokeDynamicSupport.dropNameAndArgs(BREAKJUMP, 5, 2, true);
        retryJump2 = InvokeDynamicSupport.dropNameAndArgs(RETRYJUMP, 5, 2, true);
        target = MethodHandles.catchException((MethodHandle)target, JumpException.BreakJump.class, (MethodHandle)breakJump2);
        TARGET_2_B = target = MethodHandles.catchException((MethodHandle)target, JumpException.RetryJump.class, (MethodHandle)retryJump2);
        FALLBACK_2_B = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "fallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, Block.class}));
        PGC_3_B = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, 3, true);
        GETMETHOD_3_B = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, 3, true);
        TEST_3_B = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, 3, true);
        target = InvokeDynamicSupport.findVirtual(DynamicMethod.class, "call", MethodType.methodType(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class}), (int[])new int[]{0, 3, 5, 1, 6, 7, 8, 9, 10});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_3_B);
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_3_B);
        breakJump2 = InvokeDynamicSupport.dropNameAndArgs(BREAKJUMP, 5, 3, true);
        retryJump2 = InvokeDynamicSupport.dropNameAndArgs(RETRYJUMP, 5, 3, true);
        target = MethodHandles.catchException((MethodHandle)target, JumpException.BreakJump.class, (MethodHandle)breakJump2);
        TARGET_3_B = target = MethodHandles.catchException((MethodHandle)target, JumpException.RetryJump.class, (MethodHandle)retryJump2);
        FALLBACK_3_B = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "fallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class}));
        PGC_N_B = InvokeDynamicSupport.dropNameAndArgs(PGC, 4, -1, true);
        GETMETHOD_N_B = InvokeDynamicSupport.dropNameAndArgs(GETMETHOD, 5, -1, true);
        TEST_N_B = InvokeDynamicSupport.dropNameAndArgs(TEST, 4, -1, true);
        target = InvokeDynamicSupport.findVirtual(DynamicMethod.class, "call", MethodType.methodType(IRubyObject.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class}));
        target = MethodHandles.convertArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, RubyClass.class, String.class, IRubyObject[].class, Block.class}));
        target = MethodHandles.permuteArguments((MethodHandle)target, (MethodType)MethodType.methodType(IRubyObject.class, DynamicMethod.class, (Class[])new Class[]{RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject[].class, Block.class}), (int[])new int[]{0, 3, 5, 1, 6, 7, 8});
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)GETMETHOD_N_B);
        target = MethodHandles.foldArguments((MethodHandle)target, (MethodHandle)PGC_N_B);
        breakJump2 = InvokeDynamicSupport.dropNameAndArgs(BREAKJUMP, 5, -1, true);
        retryJump2 = InvokeDynamicSupport.dropNameAndArgs(RETRYJUMP, 5, -1, true);
        target = MethodHandles.catchException((MethodHandle)target, JumpException.BreakJump.class, (MethodHandle)breakJump2);
        TARGET_N_B = target = MethodHandles.catchException((MethodHandle)target, JumpException.RetryJump.class, (MethodHandle)retryJump2);
        FALLBACK_N_B = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "fallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, (Class[])new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject[].class, Block.class}));
    }

    public static class JRubyCallSite
    extends MutableCallSite {
        private final CallType callType;
        private final MethodType type;

        public JRubyCallSite(MethodType type2, CallType callType) {
            super(type2);
            this.type = type2;
            this.callType = callType;
        }

        public CallType callType() {
            return this.callType;
        }

        public MethodType type() {
            return this.type;
        }
    }
}

