/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Map;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.OneOperandInstr;
import org.jruby.compiler.ir.operands.BooleanLiteral;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotInstr
extends OneOperandInstr {
    public NotInstr(Variable dst, Operand arg2) {
        super(Operation.NOT, dst, arg2);
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new NotInstr(ii.getRenamedVariable(this.result), this.argument.cloneForInlining(ii));
    }

    @Override
    public Operand simplifyAndGetResult(Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap);
        return this.argument instanceof BooleanLiteral ? ((BooleanLiteral)this.argument).logicalNot() : null;
    }

    @Override
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        boolean not = !((IRubyObject)this.getArg().retrieve(interp)).isTrue();
        this.getResult().store(interp, interp.getRuntime().newBoolean(not));
        return null;
    }
}

