/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jruby.runtime.profile.AbstractProfilePrinter;
import org.jruby.runtime.profile.IProfileData;
import org.jruby.runtime.profile.InvocationSet;
import org.jruby.runtime.profile.MethodData;
import org.jruby.runtime.profile.ProfileData;

public class GraphProfilePrinter
extends AbstractProfilePrinter {
    public static MethodData currentData;
    private ProfileData profileData;

    public GraphProfilePrinter(IProfileData iProfileData) {
        this.profileData = (ProfileData)iProfileData;
    }

    public void printProfile(PrintStream out) {
        this.profileData.getTopInvocation().setDuration(this.profileData.totalTime());
        out.println(" %total   %self    total        self    children                 calls  name");
        Map<Integer, MethodData> methods2 = this.profileData.methodData();
        MethodData[] sortedMethods = methods2.values().toArray(new MethodData[0]);
        Arrays.sort(sortedMethods, new Comparator<MethodData>(){

            @Override
            public int compare(MethodData md1, MethodData md2) {
                long time2;
                long time1 = md1.totalTime();
                return time1 == (time2 = md2.totalTime()) ? 0 : (time1 < time2 ? 1 : -1);
            }
        });
        MethodData[] arr$ = sortedMethods;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            MethodData data;
            currentData = data = arr$[i$];
            out.println("---------------------------------------------------------------------------------------------------------");
            int serial = data.serialNumber;
            int[] parentSerialsInts = data.parents();
            Integer[] parentSerials = new Integer[parentSerialsInts.length];
            for (int i = 0; i < parentSerialsInts.length; ++i) {
                parentSerials[i] = parentSerialsInts[i];
            }
            Arrays.sort(parentSerials, new Comparator<Integer>(){

                @Override
                public int compare(Integer parent1, Integer parent2) {
                    long time2;
                    long time1 = currentData.rootInvocationsFromParent(parent1).totalTime();
                    return time1 == (time2 = currentData.rootInvocationsFromParent(parent2).totalTime()) ? 0 : (time1 < time2 ? -1 : 1);
                }
            });
            if (parentSerials.length > 0) {
                Integer[] arr$2 = parentSerials;
                int len$2 = arr$2.length;
                for (int i$2 = 0; i$2 < len$2; ++i$2) {
                    int parentSerial = arr$2[i$2];
                    String callerName = this.methodName(parentSerial);
                    InvocationSet invs = data.rootInvocationsFromParent(parentSerial);
                    out.print("              ");
                    this.pad(out, 10, this.nanoString(invs.totalTime()));
                    out.print("  ");
                    this.pad(out, 10, this.nanoString(invs.selfTime()));
                    out.print("  ");
                    this.pad(out, 10, this.nanoString(invs.childTime()));
                    out.print("  ");
                    this.pad(out, 20, Integer.toString(data.invocationsFromParent(parentSerial).totalCalls()) + "/" + Integer.toString(data.totalCalls()));
                    out.print("  ");
                    out.print(callerName);
                    out.println("");
                }
            }
            String displayName = this.methodName(serial);
            this.pad(out, 4, Long.toString(data.totalTime() * 100L / this.profileData.totalTime()));
            out.print("%  ");
            this.pad(out, 4, Long.toString(data.selfTime() * 100L / this.profileData.totalTime()));
            out.print("%  ");
            this.pad(out, 10, this.nanoString(data.totalTime()));
            out.print("  ");
            this.pad(out, 10, this.nanoString(data.selfTime()));
            out.print("  ");
            this.pad(out, 10, this.nanoString(data.childTime()));
            out.print("  ");
            this.pad(out, 20, Integer.toString(data.totalCalls()));
            out.print("  ");
            out.print(displayName);
            out.println("");
            int[] childSerialsInts = data.children();
            Integer[] childSerials = new Integer[childSerialsInts.length];
            for (int i = 0; i < childSerialsInts.length; ++i) {
                childSerials[i] = childSerialsInts[i];
            }
            Arrays.sort(childSerials, new Comparator<Integer>(){

                @Override
                public int compare(Integer child1, Integer child2) {
                    long time2;
                    long time1 = currentData.rootInvocationsOfChild(child1).totalTime();
                    return time1 == (time2 = currentData.rootInvocationsOfChild(child2).totalTime()) ? 0 : (time1 < time2 ? 1 : -1);
                }
            });
            if (childSerials.length <= 0) continue;
            Integer[] arr$3 = childSerials;
            int len$3 = arr$3.length;
            for (int i$3 = 0; i$3 < len$3; ++i$3) {
                int childSerial = arr$3[i$3];
                String callerName = this.methodName(childSerial);
                InvocationSet invs = data.rootInvocationsOfChild(childSerial);
                out.print("              ");
                this.pad(out, 10, this.nanoString(invs.totalTime()));
                out.print("  ");
                this.pad(out, 10, this.nanoString(invs.selfTime()));
                out.print("  ");
                this.pad(out, 10, this.nanoString(invs.childTime()));
                out.print("  ");
                this.pad(out, 20, Integer.toString(data.invocationsOfChild(childSerial).totalCalls()) + "/" + Integer.toString(methods2.get(childSerial).totalCalls()));
                out.print("  ");
                out.print(callerName);
                out.println("");
            }
        }
    }
}

