/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.parser.EvalStaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class PersistentLocalVariable
extends AbstractVariable {
    private static String pattern = "([a-z]|_)([a-zA-Z]|_|\\d)*";

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.matches(pattern)) {
            return new PersistentLocalVariable(receiver2, name2, javaObject);
        }
        return null;
    }

    private PersistentLocalVariable(RubyObject receiver2, String name2, Object ... javaObject) {
        super(receiver2, name2, false, javaObject);
    }

    PersistentLocalVariable(IRubyObject origin, String name2, IRubyObject irubyObject) {
        super(origin, name2, true, irubyObject);
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.LocalVariable;
    }

    public static boolean isValidName(Object name2) {
        return PersistentLocalVariable.isValidName(pattern, name2);
    }

    public static void retrieve(RubyObject receiver2, BiVariableMap vars) {
        ManyVarsDynamicScope scope = (ManyVarsDynamicScope)receiver2.getRuntime().getCurrentContext().getCurrentScope();
        if (scope == null) {
            return;
        }
        String[] names2 = scope.getAllNamesInScope();
        IRubyObject[] values = scope.getValues();
        if (names2 == null || values == null || names2.length == 0 || values.length == 0) {
            return;
        }
        for (int i = 0; i < names2.length; ++i) {
            BiVariable var = vars.getVariable((RubyObject)receiver2.getRuntime().getTopSelf(), names2[i]);
            if (var != null && receiver2.getRuntime().getTopSelf() == var.getReceiver()) {
                var.setRubyObject(values[i]);
                continue;
            }
            var = new PersistentLocalVariable(receiver2.getRuntime().getTopSelf(), names2[i], values[i]);
            vars.update(names2[i], var);
        }
    }

    public void inject() {
    }

    public void remove(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        try {
            DynamicScope currentScope = context.getCurrentScope();
            ManyVarsDynamicScope scope = (ManyVarsDynamicScope)context.getCurrentScope();
            scope = new ManyVarsDynamicScope(new EvalStaticScope(currentScope.getStaticScope()), currentScope);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

