/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.runtime.builtin.IRubyObject;

public class GlobalVariable
extends AbstractVariable {
    private static String pattern = "\\$(([a-zA-Z]|_|\\d)*|-[a-zA-Z]|[!-~&&[^#%()-\\{\\}\\[\\]\\|\\^]])";

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.matches(pattern)) {
            GlobalVariable gvar = new GlobalVariable(receiver2, name2, javaObject);
            gvar.tryEagerInjection(receiver2.getRuntime(), null);
            return gvar;
        }
        return null;
    }

    protected GlobalVariable(RubyObject receiver2, String name2, Object ... javaObject) {
        super(receiver2, name2, false, javaObject);
    }

    GlobalVariable(IRubyObject receiver2, String name2, IRubyObject irubyObject) {
        super(receiver2, name2, true, irubyObject);
    }

    public static void retrieve(IRubyObject receiver2, BiVariableMap vars) {
        if (vars.isLazy()) {
            return;
        }
        GlobalVariables gvars = receiver2.getRuntime().getGlobalVariables();
        Set<String> names2 = gvars.getNames();
        for (String name2 : names2) {
            if (GlobalVariable.isPredefined(name2)) continue;
            IRubyObject value2 = gvars.get(name2);
            GlobalVariable.updateGlobalVar(vars, (RubyObject)receiver2.getRuntime().getTopSelf(), name2, value2);
        }
    }

    private static void updateGlobalVar(BiVariableMap vars, RubyObject receiver2, String name2, IRubyObject value2) {
        if (vars.containsKey(name2)) {
            BiVariable var = vars.getVariable(receiver2, name2);
            var.setRubyObject(value2);
        } else {
            GlobalVariable var = new GlobalVariable((IRubyObject)receiver2, name2, value2);
            vars.update(name2, var);
        }
    }

    public static void retrieveByKey(Ruby runtime2, BiVariableMap vars, String key2) {
        GlobalVariables gvars = runtime2.getGlobalVariables();
        if (!gvars.getNames().contains(key2)) {
            return;
        }
        IRubyObject value2 = gvars.get(key2);
        GlobalVariable.updateGlobalVar(vars, (RubyObject)runtime2.getTopSelf(), key2, value2);
    }

    protected static boolean isPredefined(String name2) {
        String[] patterns;
        for (String p2 : patterns = new String[]{"\\$([\\u0021-\\u0040]|\\u005c|[\\u005e-\\u0060]|\\u007e)", "\\$-(\\d|[A-z])", "\\$(DEBUG|F|FILENAME|KCODE|LOAD_PATH|SAFE|VERBOSE|CLASSPATH|LOADED_FEATURES|PROGRAM_NAME)", "\\$(configure_args|deferr|defout|expect_verbose|stderr|stdin|stdout)"}) {
            if (!name2.matches(p2)) continue;
            return true;
        }
        return false;
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.GlobalVariable;
    }

    public static boolean isValidName(Object name2) {
        return GlobalVariable.isValidName(pattern, name2);
    }

    public void setJavaObject(Ruby runtime2, Object javaObject) {
        this.updateJavaObject(runtime2, javaObject);
        this.tryEagerInjection(runtime2, null);
    }

    public void inject() {
    }

    public void tryEagerInjection(Ruby runtime2, IRubyObject receiver2) {
        this.name = this.name.startsWith("$") ? this.name : ("$" + this.name).intern();
        runtime2.getGlobalVariables().set(this.name, this.irubyObject);
    }

    public void remove(Ruby runtime2) {
        this.setJavaObject(runtime2, null);
        runtime2.getGlobalVariables().set(this.name, this.irubyObject);
    }
}

