/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.ast.CallNoArgBlockNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class CallNoArgNode
extends CallNode {
    public CallNoArgNode(ISourcePosition position, Node receiverNode, String name2) {
        super(position, receiverNode, name2, null, null);
    }

    public CallNoArgNode(ISourcePosition position, Node receiverNode, Node args2, String name2) {
        super(position, receiverNode, name2, args2, null);
    }

    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.callAdapter.call(context, self, this.getReceiverNode().interpret(runtime2, context, self, aBlock));
    }

    public Node setIterNode(Node iterNode) {
        return new CallNoArgBlockNode(this.getPosition(), this.getReceiverNode(), this.getName(), this.getArgsNode(), (IterNode)iterNode);
    }

    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        String definition = null;
        if (this.getReceiverNode().definition(runtime2, context, self, aBlock) != null) {
            try {
                IRubyObject receiver2 = this.getReceiverNode().interpret(runtime2, context, self, aBlock);
                RubyClass metaClass = receiver2.getMetaClass();
                DynamicMethod method2 = metaClass.searchMethod(this.getName());
                Visibility visibility = method2.getVisibility();
                if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || metaClass.getRealClass().isInstance(self)) && !method2.isUndefined()) {
                    definition = "method";
                }
                if (definition == null && context.getRuntime().is1_9() && receiver2.callMethod(context, "respond_to_missing?", new IRubyObject[]{context.getRuntime().newSymbol(this.getName()), context.getRuntime().getFalse()}).isTrue()) {
                    return "method";
                }
            }
            catch (JumpException excptn) {
                // empty catch block
            }
        }
        return definition;
    }
}

