/*
 * Decompiled with CFR 0.152.
 */
package org.yecht;

import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.yecht.DocStage;
import org.yecht.EmitterHandler;
import org.yecht.ImplicitScanner2;
import org.yecht.Level;
import org.yecht.LevelStatus;
import org.yecht.MapStyle;
import org.yecht.OutputHandler;
import org.yecht.Parser;
import org.yecht.Pointer;
import org.yecht.ScalarStyle;
import org.yecht.SeqStyle;
import org.yecht.YAML;

public class Emitter {
    public boolean headless = false;
    public boolean use_header = false;
    public boolean use_version = false;
    public boolean sort_keys = false;
    public String anchor_format = null;
    public boolean explicit_typing = false;
    public int best_width = 80;
    public ScalarStyle style = ScalarStyle.None;
    public DocStage stage = DocStage.open;
    public int level = -1;
    public int indent = 2;
    Map<Object, Long> markers = null;
    Map<Long, String> anchors = null;
    Map<String, Object> anchored = null;
    int bufsize = 4096;
    byte[] buffer = null;
    int marker = -1;
    int bufpos = 0;
    EmitterHandler emitter_handler = null;
    OutputHandler output_handler = null;
    Level[] levels = new Level[this.lvl_capa];
    int lvl_idx = 0;
    int lvl_capa = 8;
    public Object bonus;
    private static final Pointer NEWLINE = Pointer.create("\n");
    private static final Pointer TWO_NEWLINES = Pointer.create("\n\n");
    private static final Pointer SPACE = Pointer.create(" ");
    private static final Pointer SLASH = Pointer.create("/");
    private static final Pointer THREE_DASHES = Pointer.create("--- ");
    private static final Pointer QUESTION_MARK_SPACE = Pointer.create("? ");
    private static final Pointer BANG = Pointer.create("!");
    private static final Pointer BANG_SPACE = Pointer.create("! ");
    private static final Pointer TWO_BANGS = Pointer.create("!!");
    private static final Pointer BACKSLASH = Pointer.create("\\");
    private static final Pointer ZERO = Pointer.create("0");
    private static final Pointer X = Pointer.create("x");
    private static final Pointer SINGLE_QUOTE = Pointer.create("'");
    private static final Pointer DOUBLE_QUOTE = Pointer.create("\"");
    private static final Pointer PIPE = Pointer.create("|");
    private static final Pointer PLUS = Pointer.create("+");
    private static final Pointer MINUS = Pointer.create("-");
    private static final Pointer GT = Pointer.create(">");
    private static final Pointer SQUARE_OPEN = Pointer.create("[");
    private static final Pointer SQUARE_CLOSE = Pointer.create("]");
    private static final Pointer CURLY_OPEN = Pointer.create("{");
    private static final Pointer CURLY_CLOSE = Pointer.create("}");
    private static final Pointer DASH_SPACE = Pointer.create("- ");
    private static final Pointer COMMA_SPACE = Pointer.create(", ");
    private static final Pointer COLON_SPACE = Pointer.create(": ");
    private static final Pointer EMPTY_ARRAY = Pointer.create("[]\n");
    private static final Pointer EMPTY_HASH = Pointer.create("{}\n");
    private static final Pointer COLON = Pointer.create(":");
    private static final int SCAN_NONE = 0;
    private static final int SCAN_NONPRINT = 1;
    private static final int SCAN_INDENTED = 2;
    private static final int SCAN_WIDE = 4;
    private static final int SCAN_WHITEEDGE = 8;
    private static final int SCAN_NEWLINE = 16;
    private static final int SCAN_SINGLEQ = 32;
    private static final int SCAN_DOUBLEQ = 64;
    private static final int SCAN_INDIC_S = 128;
    private static final int SCAN_INDIC_C = 256;
    private static final int SCAN_NONL_E = 512;
    private static final int SCAN_MANYNL_E = 1024;
    private static final int SCAN_FLOWMAP = 2048;
    private static final int SCAN_FLOWSEQ = 4096;
    private static final int SCAN_DOCSEP = 8192;
    private static final Pointer EMPTY = Pointer.create(new byte[0], 0);
    private static final Pointer TILDE = Pointer.create("~");
    private static final Pointer hex_table = Pointer.create("0123456789ABCDEF");
    private static final Pointer SLASH_QUOTE = Pointer.create("\\\"");
    private static final Pointer SLASH_SLASH = Pointer.create("\\\\");
    private static final Pointer SLASH_ZERO = Pointer.create("\\0");
    private static final Pointer SLASH_A = Pointer.create("\\a");
    private static final Pointer SLASH_B = Pointer.create("\\b");
    private static final Pointer SLASH_F = Pointer.create("\\f");
    private static final Pointer SLASH_R = Pointer.create("\\r");
    private static final Pointer SLASH_T = Pointer.create("\\t");
    private static final Pointer SLASH_V = Pointer.create("\\v");
    private static final Pointer SLASH_E = Pointer.create("\\e");
    private static final Pointer SLASH_N = Pointer.create("\\n");

    public Emitter() {
        this.resetLevels();
        this.bonus = null;
    }

    public Level currentLevel() {
        return this.levels[this.lvl_idx - 1];
    }

    public Level parentLevel() {
        return this.levels[this.lvl_idx - 2];
    }

    public void popLevel() {
        if (this.lvl_idx <= 1) {
            return;
        }
        --this.lvl_idx;
    }

    public void addLevel(int len, LevelStatus status2) {
        if (this.lvl_idx + 1 > this.lvl_capa) {
            this.lvl_capa += 8;
            this.levels = YAML.realloc(this.levels, this.lvl_capa);
        }
        this.levels[this.lvl_idx] = new Level();
        this.levels[this.lvl_idx].spaces = len;
        this.levels[this.lvl_idx].ncount = 0;
        this.levels[this.lvl_idx].domain = this.levels[this.lvl_idx - 1].domain;
        this.levels[this.lvl_idx].status = status2;
        this.levels[this.lvl_idx].anctag = 0;
        ++this.lvl_idx;
    }

    public void resetLevels() {
        while (this.lvl_idx > 1) {
            this.popLevel();
        }
        if (this.lvl_idx < 1) {
            this.lvl_idx = 1;
            this.levels[0] = new Level();
            this.levels[0].spaces = -1;
            this.levels[0].ncount = 0;
            this.levels[0].domain = "";
            this.levels[0].anctag = 0;
        }
        this.levels[0].status = LevelStatus.header;
    }

    public void handler(EmitterHandler hdlr) {
        this.emitter_handler = hdlr;
    }

    public void outputHandler(OutputHandler hdlr) {
        this.output_handler = hdlr;
    }

    public void clear() {
        if (this.buffer == null) {
            this.buffer = new byte[this.bufsize];
        }
        this.buffer[0] = 0;
        this.marker = 0;
        this.bufpos = 0;
    }

    public void write(Pointer _str, int _len) {
        int at2;
        int len = _len;
        byte[] bstr = _str.buffer;
        int str = _str.start;
        if (this.buffer == null) {
            this.clear();
        }
        if (len + (at2 = this.marker) >= this.bufsize - 1) {
            int rest2;
            this.flush(0);
            while (len > (rest2 = this.bufsize - 1 - this.marker)) {
                System.arraycopy(bstr, str, this.buffer, this.marker, rest2);
                this.marker += rest2;
                str += rest2;
                len -= rest2;
                this.flush(0);
            }
        }
        System.arraycopy(bstr, str, this.buffer, this.marker, len);
        this.marker += len;
        this.buffer[this.marker] = 0;
    }

    public void flush(int check_room) {
        if (check_room > 0) {
            if (this.bufsize - 1 > this.marker + check_room) {
                return;
            }
        } else {
            check_room = this.bufsize - 1;
        }
        if (check_room > this.marker) {
            check_room = this.marker;
        }
        this.output_handler.handle(this, this.buffer, check_room);
        this.bufpos += check_room;
        this.marker -= check_room;
    }

    public void emit(Object n) {
        long oid;
        int indent = 0;
        boolean x = false;
        Level lvl = this.currentLevel();
        if (this.stage == DocStage.open && (!this.headless || this.use_header)) {
            if (this.use_version) {
                String header = "--- %YAML:1.0 ";
                this.write(Pointer.create(header), header.length());
            } else {
                this.write(THREE_DASHES, 4);
            }
            this.stage = DocStage.processing;
        }
        if (lvl.spaces >= 0) {
            indent = lvl.spaces + this.indent;
        }
        this.addLevel(indent, LevelStatus.open);
        Level parent = lvl;
        lvl = this.currentLevel();
        boolean handle = true;
        if (this.anchors != null && this.markers.containsKey(n) && this.anchors.containsKey(oid = this.markers.get(n).longValue())) {
            String anchor_name = this.anchors.get(oid);
            if (this.anchored == null) {
                this.anchored = new HashMap<String, Object>();
            }
            if (!this.anchored.containsKey(anchor_name)) {
                String an = "&" + anchor_name + " ";
                if (parent.status == LevelStatus.map && parent.ncount % 2 == 1) {
                    this.write(QUESTION_MARK_SPACE, 2);
                    parent.status = LevelStatus.mapx;
                }
                this.write(Pointer.create(an), an.length());
                this.anchored.put(anchor_name, null);
                lvl.anctag = 1;
            } else {
                String an = "*" + anchor_name;
                this.write(Pointer.create(an), an.length());
                handle = false;
            }
        }
        if (handle) {
            this.emitter_handler.handle(this, n);
        }
        this.popLevel();
        if (this.lvl_idx == 1) {
            this.write(NEWLINE, 1);
            this.headless = false;
            this.stage = DocStage.open;
        }
    }

    public void emitTag(String tag, String ignore) {
        if (tag == null) {
            return;
        }
        if (ignore != null && ImplicitScanner2.tagcmp(tag, ignore) && !this.explicit_typing) {
            return;
        }
        Level lvl = this.currentLevel();
        if (tag.length() == 0) {
            this.write(BANG_SPACE, 2);
        } else if (tag.startsWith("tag:")) {
            int taglen = tag.length();
            Pointer ptag = Pointer.create(tag);
            this.write(BANG, 1);
            if (tag.substring(4).startsWith("yaml.org,2002")) {
                int skip2 = 4 + "yaml.org,2002".length() + 1;
                this.write(ptag.withStart(skip2), taglen - skip2);
            } else {
                int subd;
                for (subd = 4; subd < taglen && tag.charAt(subd) != ':'; ++subd) {
                }
                if (subd < taglen && tag.charAt(subd) == ':') {
                    if (subd > "yaml.org,2002".length() + 5 && tag.substring(subd - "yaml.org,2002".length()).startsWith("yaml.org,2002")) {
                        this.write(ptag.withStart(4), subd - "yaml.org,2002".length() - 5);
                        this.write(SLASH, 1);
                        this.write(ptag.withStart(subd + 1), taglen - (subd + 1));
                    } else {
                        this.write(ptag.withStart(4), subd - 4);
                        this.write(SLASH, 1);
                        this.write(ptag.withStart(subd + 1), taglen - (subd + 1));
                    }
                } else {
                    return;
                }
            }
            this.write(SPACE, 1);
        } else if (tag.startsWith("x-private:")) {
            this.write(TWO_BANGS, 2);
            this.write(Pointer.create(tag.substring(10)), tag.length() - 10);
            this.write(SPACE, 1);
        }
        lvl.anctag = 1;
    }

    public void emitIndent() {
        Level lvl = this.currentLevel();
        if (this.bufpos == 0 && this.marker == 0) {
            return;
        }
        if (lvl.spaces >= 0) {
            byte[] spcs = new byte[lvl.spaces + 2];
            spcs[0] = 10;
            spcs[lvl.spaces + 1] = 0;
            for (int i = 0; i < lvl.spaces; ++i) {
                spcs[i + 1] = 32;
            }
            this.write(Pointer.create(spcs, 0), lvl.spaces + 1);
        }
    }

    public int scanScalar(int req_width, Pointer _cursor, int len) {
        byte[] cursorb = _cursor.buffer;
        int cursor = _cursor.start;
        int start2 = 0;
        int flags = 0;
        if (len < 1) {
            return flags;
        }
        switch (cursorb[cursor]) {
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 62: 
            case 64: 
            case 91: 
            case 93: 
            case 96: 
            case 123: 
            case 124: 
            case 125: {
                flags |= 0x80;
                break;
            }
            case 44: 
            case 45: 
            case 58: 
            case 63: {
                if (len != 1 && cursorb[cursor + 1] != 32 && cursorb[cursor + 1] != 10) break;
                flags |= 0x80;
            }
        }
        if (cursorb[cursor + len - 1] != 10) {
            flags |= 0x200;
        } else if (len > 1 && cursorb[cursor + len - 2] == 10) {
            flags |= 0x400;
        }
        if (len > 0 && (cursorb[cursor] == 32 || cursorb[cursor] == 9) || len > 1 && (cursorb[cursor + len - 1] == 32 || cursorb[cursor + len - 1] == 9)) {
            flags |= 8;
        }
        if (len >= 3 && cursorb[cursor] == 45 && cursorb[cursor + 1] == 45 && cursorb[cursor + 2] == 45) {
            flags |= 0x2000;
        }
        for (int i = 0; i < len; ++i) {
            int ci = cursorb[cursor + i] & 0xFF;
            if (ci != 9 && ci != 10 && ci != 13 && (ci < 32 || ci > 126)) {
                flags |= 1;
                continue;
            }
            if (ci == 10) {
                flags |= 0x10;
                if (len - i >= 3 && cursorb[cursor + i + 1] == 45 && cursorb[cursor + i + 2] == 45 && cursorb[cursor + i + 3] == 45) {
                    flags |= 0x2000;
                }
                if (i + 1 < len && (cursorb[cursor + i + 1] == 32 || cursorb[cursor + i + 1] == 9)) {
                    flags |= 2;
                }
                if (req_width > 0 && i - start2 > req_width) {
                    flags |= 4;
                }
                start2 = i;
                continue;
            }
            if (ci == 39) {
                flags |= 0x20;
                continue;
            }
            if (ci == 34) {
                flags |= 0x40;
                continue;
            }
            if (ci == 93) {
                flags |= 0x1000;
                continue;
            }
            if (ci == 125) {
                flags |= 0x800;
                continue;
            }
            if (ci == 32 && i + 1 < len && cursorb[cursor + i + 1] == 35 || ci == 58 && (i + 1 < len && cursorb[cursor + i + 1] == 32 || i + 1 < len && cursorb[cursor + i + 1] == 10 || i == len - 1)) {
                flags |= 0x100;
                continue;
            }
            if (ci != 44 || i != len - 1 && cursorb[cursor + i + 1] != 32 && cursorb[cursor + i + 1] != 10) continue;
            flags |= 0x800;
            flags |= 0x1000;
        }
        return flags;
    }

    public void emitScalar(String tag, ScalarStyle force_style, int force_indent, int force_width, int keep_nl, Pointer _str, int len) {
        if (_str == null) {
            _str = EMPTY;
        }
        byte[] bstr = _str.buffer;
        int str = _str.start;
        ScalarStyle favor_style = ScalarStyle.Literal;
        Level parent = this.parentLevel();
        Level lvl = this.currentLevel();
        if (len == 0 && (parent.status == LevelStatus.map || parent.status == LevelStatus.imap) && parent.ncount % 2 == 1 && ImplicitScanner2.tagcmp(tag, "tag:yaml.org,2002:null")) {
            _str = TILDE;
            bstr = _str.buffer;
            str = _str.start;
            len = 1;
        }
        int scan2 = this.scanScalar(force_width, _str, len);
        String implicit = Parser.taguri("yaml.org,2002", ImplicitScanner2.matchImplicit(_str, len));
        if (!ImplicitScanner2.tagcmp(tag, implicit) && ImplicitScanner2.tagcmp(tag, "tag:yaml.org,2002:str")) {
            force_style = ScalarStyle.TwoQuote;
        } else {
            if (parent.status == LevelStatus.map && parent.ncount % 2 == 1 && tag != null && (implicit == null || !ImplicitScanner2.tagcmp(tag, implicit) || this.explicit_typing)) {
                this.write(QUESTION_MARK_SPACE, 2);
                parent.status = LevelStatus.mapx;
            }
            this.emitTag(tag, implicit);
        }
        if (force_style == ScalarStyle.None) {
            force_style = (scan2 & 0x10) != 0 ? ScalarStyle.Literal : ScalarStyle.Plain;
        }
        if (this.style == ScalarStyle.Fold) {
            favor_style = ScalarStyle.Fold;
        }
        if ((scan2 & 1) != 0) {
            force_style = ScalarStyle.TwoQuote;
        } else if ((scan2 & 8) != 0) {
            force_style = ScalarStyle.TwoQuote;
        } else if (force_style != ScalarStyle.Fold && (scan2 & 2) != 0) {
            force_style = ScalarStyle.Literal;
        } else if (force_style == ScalarStyle.Plain && (scan2 & 0x10) != 0) {
            force_style = favor_style;
        } else if (force_style == ScalarStyle.Plain && parent.status == LevelStatus.iseq && (scan2 & 0x1000) != 0) {
            force_style = ScalarStyle.TwoQuote;
        } else if (force_style == ScalarStyle.Plain && parent.status == LevelStatus.imap && (scan2 & 0x800) != 0) {
            force_style = ScalarStyle.TwoQuote;
        } else if (force_style == ScalarStyle.Plain && ((scan2 & 0x80) != 0 || (scan2 & 0x100) != 0)) {
            force_style = (scan2 & 0x10) != 0 ? favor_style : ScalarStyle.TwoQuote;
        }
        if (force_indent > 0) {
            lvl.spaces = parent.spaces + force_indent;
        } else if ((scan2 & 0x2000) != 0) {
            lvl.spaces = parent.spaces + this.indent;
        }
        if ((parent.status == LevelStatus.map || parent.status == LevelStatus.mapx) && parent.ncount % 2 == 1 && force_style != ScalarStyle.Plain) {
            force_style = ScalarStyle.TwoQuote;
        }
        if ((parent.status == LevelStatus.imap || parent.status == LevelStatus.iseq) && force_style != ScalarStyle.Plain && force_style != ScalarStyle.OneQuote) {
            force_style = ScalarStyle.TwoQuote;
        }
        if ((scan2 & 0x200) != 0) {
            keep_nl = 40;
        } else if ((scan2 & 0x400) != 0) {
            keep_nl = 50;
        }
        switch (force_style) {
            case OneQuote: {
                this.emit1Quoted(force_width, _str, len);
                break;
            }
            case None: 
            case TwoQuote: {
                this.emit2Quoted(force_width, _str, len);
                break;
            }
            case Fold: {
                this.emitFolded(force_width, keep_nl, _str, len);
                break;
            }
            case Literal: {
                this.emitLiteral(keep_nl, _str, len);
                break;
            }
            case Plain: {
                this.write(_str, len);
            }
        }
        if (parent.status == LevelStatus.mapx) {
            this.write(NEWLINE, 1);
        }
    }

    public void escape(Pointer _src, int len) {
        byte[] bsrc = _src.buffer;
        int src = _src.start;
        for (int i = 0; i < len; ++i) {
            int curr = bsrc[src + i] & 0xFF;
            if (curr < 32 || 126 < curr) {
                this.write(BACKSLASH, 1);
                if (curr == 0) {
                    this.write(ZERO, 1);
                    continue;
                }
                this.write(X, 1);
                this.write(hex_table.withStart((curr & 0xF0) >> 4), 1);
                this.write(hex_table.withStart(curr & 0xF), 1);
                continue;
            }
            this.write(_src.withStart(src + i), 1);
            if (curr != 92) continue;
            this.write(BACKSLASH, 1);
        }
    }

    public void emit1Quoted(int width, Pointer _str, int len) {
        byte[] bstr = _str.buffer;
        int str = _str.start;
        boolean do_indent = false;
        int mark = str;
        int start2 = str;
        int end2 = str;
        this.write(SINGLE_QUOTE, 1);
        block5: while (mark < str + len) {
            if (do_indent) {
                this.emitIndent();
                do_indent = false;
            }
            switch (bstr[mark]) {
                case 39: {
                    this.write(SINGLE_QUOTE, 1);
                    continue block5;
                }
                case 10: {
                    end2 = mark + 1;
                    if (bstr[start2] != 32 && bstr[start2] != 10 && bstr[end2] != 10 && bstr[end2] != 32) {
                        this.write(TWO_NEWLINES, 2);
                    } else {
                        this.write(NEWLINE, 1);
                    }
                    do_indent = true;
                    start2 = mark + 1;
                    continue block5;
                }
                case 32: {
                    if (width > 0 && bstr[start2] != 32 && mark - end2 > width) {
                        do_indent = true;
                        end2 = mark + 1;
                        continue block5;
                    }
                    this.write(SPACE, 1);
                    continue block5;
                }
            }
            this.write(_str.withStart(mark), 1);
        }
        this.write(SINGLE_QUOTE, 1);
    }

    public void emit2Quoted(int width, Pointer _str, int len) {
        byte[] bstr = _str.buffer;
        int str = _str.start;
        int do_indent = 0;
        int start2 = str;
        int end2 = str;
        this.write(DOUBLE_QUOTE, 1);
        block14: for (int mark = str; mark < str + len; ++mark) {
            if (do_indent > 0) {
                if (do_indent == 2) {
                    this.write(BACKSLASH, 1);
                }
                this.emitIndent();
                do_indent = 0;
            }
            switch (bstr[mark]) {
                case 34: {
                    this.write(SLASH_QUOTE, 2);
                    continue block14;
                }
                case 92: {
                    this.write(SLASH_SLASH, 2);
                    continue block14;
                }
                case 0: {
                    this.write(SLASH_ZERO, 2);
                    continue block14;
                }
                case 7: {
                    this.write(SLASH_A, 2);
                    continue block14;
                }
                case 8: {
                    this.write(SLASH_B, 2);
                    continue block14;
                }
                case 12: {
                    this.write(SLASH_F, 2);
                    continue block14;
                }
                case 13: {
                    this.write(SLASH_R, 2);
                    continue block14;
                }
                case 9: {
                    this.write(SLASH_T, 2);
                    continue block14;
                }
                case 11: {
                    this.write(SLASH_V, 2);
                    continue block14;
                }
                case 27: {
                    this.write(SLASH_E, 2);
                    continue block14;
                }
                case 10: {
                    end2 = mark + 1;
                    this.write(SLASH_N, 2);
                    do_indent = 2;
                    start2 = mark + 1;
                    if (start2 >= str + len || bstr[start2] != 32 && bstr[start2] != 10) continue block14;
                    do_indent = 0;
                    continue block14;
                }
                case 32: {
                    if (width > 0 && bstr[start2] != 32 && mark - end2 > width) {
                        do_indent = 1;
                        end2 = mark + 1;
                        continue block14;
                    }
                    this.write(SPACE, 1);
                    continue block14;
                }
                default: {
                    this.escape(_str.withStart(mark), 1);
                }
            }
        }
        this.write(DOUBLE_QUOTE, 1);
    }

    public void emitLiteral(int keep_nl, Pointer _str, int len) {
        int str;
        byte[] bstr = _str.buffer;
        int mark = str = _str.start;
        int start2 = str;
        int end2 = str;
        this.write(PIPE, 1);
        if (keep_nl == 40) {
            this.write(MINUS, 1);
        } else if (keep_nl == 50) {
            this.write(PLUS, 1);
        }
        this.emitIndent();
        while (mark < str + len) {
            if (bstr[mark] == 10) {
                end2 = mark;
                if (bstr[start2] != 32 && bstr[start2] != 10 && bstr[end2] != 10 && bstr[end2] != 32) {
                    ++end2;
                }
                this.write(_str.withStart(start2), end2 - start2);
                if (mark + 1 == str + len) {
                    if (keep_nl != 50) {
                        this.write(NEWLINE, 1);
                    }
                } else {
                    this.emitIndent();
                }
                start2 = mark + 1;
            }
            ++mark;
        }
        end2 = str + len;
        if (start2 < end2) {
            this.write(_str.withStart(start2), end2 - start2);
        }
    }

    public void emitFolded(int width, int keep_nl, Pointer _str, int len) {
        int str;
        byte[] bstr = _str.buffer;
        int mark = str = _str.start;
        int start2 = str;
        int end2 = str;
        this.write(GT, 1);
        if (keep_nl == 40) {
            this.write(MINUS, 1);
        } else if (keep_nl == 50) {
            this.write(PLUS, 1);
        }
        this.emitIndent();
        if (width <= 0) {
            width = this.best_width;
        }
        while (mark < str + len) {
            switch (bstr[mark]) {
                case 10: {
                    this.write(_str.withStart(end2), mark - end2);
                    end2 = mark + 1;
                    if (bstr[start2] != 32 && bstr[start2] != 10 && bstr[end2] != 10 && bstr[end2] != 32) {
                        this.write(NEWLINE, 1);
                    }
                    if (mark + 1 == str + len) {
                        if (keep_nl != 50) {
                            this.write(NEWLINE, 1);
                        }
                    } else {
                        this.emitIndent();
                    }
                    start2 = mark + 1;
                    break;
                }
                case 32: {
                    if (bstr[start2] == 32 || mark - end2 <= width) break;
                    this.write(_str.withStart(end2), mark - end2);
                    this.emitIndent();
                    end2 = mark + 1;
                }
            }
            ++mark;
        }
        if (end2 < mark) {
            this.write(_str.withStart(end2), mark - end2);
        }
    }

    public void emitSeq(String tag, SeqStyle style) {
        Level parent = this.parentLevel();
        Level lvl = this.currentLevel();
        if (parent.status == LevelStatus.map && parent.ncount % 2 == 1) {
            this.write(QUESTION_MARK_SPACE, 2);
            parent.status = LevelStatus.mapx;
        }
        this.emitTag(tag, "tag:yaml.org,2002:seq");
        if (style == SeqStyle.Inline || parent.status == LevelStatus.imap || parent.status == LevelStatus.iseq) {
            this.write(SQUARE_OPEN, 1);
            lvl.status = LevelStatus.iseq;
        } else {
            lvl.status = LevelStatus.seq;
        }
    }

    public void emitMap(String tag, MapStyle style) {
        Level parent = this.parentLevel();
        Level lvl = this.currentLevel();
        if (parent.status == LevelStatus.map && parent.ncount % 2 == 1) {
            this.write(QUESTION_MARK_SPACE, 2);
            parent.status = LevelStatus.mapx;
        }
        this.emitTag(tag, "tag:yaml.org,2002:map");
        if (style == MapStyle.Inline || parent.status == LevelStatus.imap || parent.status == LevelStatus.iseq) {
            this.write(CURLY_OPEN, 1);
            lvl.status = LevelStatus.imap;
        } else {
            lvl.status = LevelStatus.map;
        }
    }

    public void emitItem(Object n) {
        Level lvl = this.currentLevel();
        switch (lvl.status) {
            case seq: {
                int spcs;
                Level parent = this.parentLevel();
                if (parent.status == LevelStatus.mapx && lvl.ncount == 0) {
                    if (parent.ncount % 2 == 0 && lvl.anctag == 0) {
                        lvl.spaces = parent.spaces;
                    }
                } else if (lvl.anctag == 0 && parent.status == LevelStatus.seq && lvl.ncount == 0 && (spcs = lvl.spaces - parent.spaces - 2) >= 0) {
                    for (int i = 0; i < spcs; ++i) {
                        this.write(SPACE, 1);
                    }
                    this.write(DASH_SPACE, 2);
                    break;
                }
                this.emitIndent();
                this.write(DASH_SPACE, 2);
                break;
            }
            case iseq: {
                if (lvl.ncount <= 0) break;
                this.write(COMMA_SPACE, 2);
                break;
            }
            case map: {
                int spcs;
                Level parent = this.parentLevel();
                if (lvl.anctag == 0 && parent.status == LevelStatus.seq && lvl.ncount == 0 && (spcs = lvl.spaces - parent.spaces - 2) >= 0) {
                    for (int i = 0; i < spcs; ++i) {
                        this.write(SPACE, 1);
                    }
                    break;
                }
                if (lvl.ncount % 2 == 0) {
                    this.emitIndent();
                    break;
                }
                this.write(COLON_SPACE, 2);
                break;
            }
            case mapx: {
                if (lvl.ncount % 2 == 0) {
                    this.emitIndent();
                    lvl.status = LevelStatus.map;
                    break;
                }
                if (lvl.spaces > 0) {
                    byte[] spcs = new byte[lvl.spaces];
                    Arrays.fill(spcs, (byte)32);
                    this.write(Pointer.create(spcs, 0), lvl.spaces);
                }
                this.write(COLON_SPACE, 2);
                break;
            }
            case imap: {
                if (lvl.ncount <= 0) break;
                if (lvl.ncount % 2 == 0) {
                    this.write(COMMA_SPACE, 2);
                    break;
                }
                this.write(COLON_SPACE, 2);
                break;
            }
        }
        ++lvl.ncount;
        this.emit(n);
    }

    public void emitEnd() {
        Level lvl = this.currentLevel();
        Level parent = this.parentLevel();
        switch (lvl.status) {
            case seq: {
                if (lvl.ncount == 0) {
                    this.write(EMPTY_ARRAY, 3);
                    break;
                }
                if (parent.status != LevelStatus.mapx) break;
                this.write(NEWLINE, 1);
                break;
            }
            case iseq: {
                this.write(SQUARE_CLOSE, 1);
                if (parent.status != LevelStatus.mapx) break;
                this.write(NEWLINE, 1);
                break;
            }
            case map: {
                if (lvl.ncount == 0) {
                    this.write(EMPTY_HASH, 3);
                    break;
                }
                if (lvl.ncount % 2 == 1) {
                    this.write(COLON, 1);
                    break;
                }
                if (parent.status != LevelStatus.mapx) break;
                this.write(NEWLINE, 1);
                break;
            }
            case imap: {
                this.write(CURLY_CLOSE, 1);
                if (parent.status != LevelStatus.mapx) break;
                this.write(NEWLINE, 1);
                break;
            }
        }
    }

    public long markNode(Object n) {
        long oid = 0L;
        if (this.markers == null) {
            this.markers = new IdentityHashMap<Object, Long>();
        }
        if (!this.markers.containsKey(n)) {
            oid = this.markers.size() + 1;
            this.markers.put(n, oid);
        } else {
            oid = this.markers.get(n);
            if (this.anchors == null) {
                this.anchors = new HashMap<Long, String>();
            }
            if (!this.anchors.containsKey(oid)) {
                int idx = 0;
                String anc = this.anchor_format == null ? "id%03d" : this.anchor_format;
                idx = this.anchors.size() + 1;
                String anchor_name = String.format(anc, idx);
                this.anchors.put(oid, anchor_name);
            }
        }
        return oid;
    }

    public static class Node {
        public int pos;
        public int indent;
        public boolean is_shortcut;
    }
}

