/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.builtin.IRubyObject;

abstract class MemoryOp {
    public static final MemoryOp BOOL = new BooleanOp();
    public static final MemoryOp INT8 = new Signed8();
    public static final MemoryOp UINT8 = new Unsigned8();
    public static final MemoryOp INT16 = new Signed16();
    public static final MemoryOp UINT16 = new Unsigned16();
    public static final MemoryOp INT32 = new Signed32();
    public static final MemoryOp UINT32 = new Unsigned32();
    public static final MemoryOp INT64 = new Signed64();
    public static final MemoryOp UINT64 = new Unsigned64();
    public static final MemoryOp FLOAT32 = new Float32();
    public static final MemoryOp FLOAT64 = new Float64();

    MemoryOp() {
    }

    public static final MemoryOp getMemoryOp(NativeType type2) {
        switch (type2) {
            case BOOL: {
                return BOOL;
            }
            case CHAR: {
                return INT8;
            }
            case UCHAR: {
                return UINT8;
            }
            case SHORT: {
                return INT16;
            }
            case USHORT: {
                return UINT16;
            }
            case INT: {
                return INT32;
            }
            case UINT: {
                return UINT32;
            }
            case LONG_LONG: {
                return INT64;
            }
            case ULONG_LONG: {
                return UINT64;
            }
            case FLOAT: {
                return FLOAT32;
            }
            case DOUBLE: {
                return FLOAT64;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? INT32 : INT64;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? UINT32 : UINT64;
            }
        }
        return null;
    }

    abstract IRubyObject get(Ruby var1, MemoryIO var2, long var3);

    abstract void put(Ruby var1, MemoryIO var2, long var3, IRubyObject var5);

    static final class Float64
    extends MemoryOp {
        Float64() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putDouble(offset2, Util.doubleValue(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return runtime2.newFloat(io2.getDouble(offset2));
        }
    }

    static final class Float32
    extends MemoryOp {
        Float32() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putFloat(offset2, Util.floatValue(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return runtime2.newFloat(io2.getFloat(offset2));
        }
    }

    static final class Unsigned64
    extends MemoryOp {
        Unsigned64() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putLong(offset2, Util.uint64Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned64(runtime2, io2.getLong(offset2));
        }
    }

    static final class Signed64
    extends MemoryOp {
        Signed64() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putLong(offset2, Util.int64Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned64(runtime2, io2.getLong(offset2));
        }
    }

    static final class Unsigned32
    extends MemoryOp {
        Unsigned32() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putInt(offset2, (int)Util.uint32Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned32(runtime2, io2.getInt(offset2));
        }
    }

    static final class Signed32
    extends MemoryOp {
        Signed32() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putInt(offset2, Util.int32Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned32(runtime2, io2.getInt(offset2));
        }
    }

    static final class Unsigned16
    extends MemoryOp {
        Unsigned16() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putShort(offset2, (short)Util.uint16Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned16(runtime2, io2.getShort(offset2));
        }
    }

    static final class Signed16
    extends MemoryOp {
        Signed16() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putShort(offset2, Util.int16Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned16(runtime2, io2.getShort(offset2));
        }
    }

    static final class Unsigned8
    extends MemoryOp {
        Unsigned8() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putByte(offset2, (byte)Util.uint8Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newUnsigned8(runtime2, io2.getByte(offset2));
        }
    }

    static final class Signed8
    extends MemoryOp {
        Signed8() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putByte(offset2, Util.int8Value(value2));
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return Util.newSigned8(runtime2, io2.getByte(offset2));
        }
    }

    static final class BooleanOp
    extends MemoryOp {
        BooleanOp() {
        }

        public final void put(Ruby runtime2, MemoryIO io2, long offset2, IRubyObject value2) {
            io2.putInt(offset2, value2.isTrue() ? 1 : 0);
        }

        public final IRubyObject get(Ruby runtime2, MemoryIO io2, long offset2) {
            return runtime2.newBoolean(io2.getInt(offset2) != 0);
        }
    }
}

