/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import com.sun.jna.ptr.IntByReference;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyUNIXSocket;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"UNIXServer"}, parent="UNIXSocket")
public class RubyUNIXServer
extends RubyUNIXSocket {
    private static ObjectAllocator UNIXSERVER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyUNIXServer(runtime2, klass);
        }
    };

    static void createUNIXServer(Ruby runtime2) {
        RubyClass rb_cUNIXServer = runtime2.defineClass("UNIXServer", runtime2.fastGetClass("UNIXSocket"), UNIXSERVER_ALLOCATOR);
        runtime2.getObject().fastSetConstant("UNIXserver", rb_cUNIXServer);
        rb_cUNIXServer.defineAnnotatedMethods(RubyUNIXServer.class);
    }

    public RubyUNIXServer(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject path2) {
        this.init_unixsock(context.getRuntime(), path2, true);
        return this;
    }

    @Deprecated
    public IRubyObject accept() {
        return this.accept(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject accept(ThreadContext context) {
        RubyUNIXSocket.LibCSocket.sockaddr_un from = new RubyUNIXSocket.LibCSocket.sockaddr_un();
        int fd2 = INSTANCE.accept(this.fd, from, new IntByReference(106));
        if (fd2 < 0) {
            RubyUNIXServer.rb_sys_fail(context.getRuntime(), null);
        }
        Ruby runtime2 = context.getRuntime();
        RubyUNIXSocket sock = (RubyUNIXSocket)RuntimeHelpers.invoke(context, runtime2.fastGetClass("UNIXSocket"), "allocate");
        sock.fd = fd2;
        sock.fpath = new String(from.sun_path);
        sock.init_sock(context.getRuntime());
        return sock;
    }

    @Deprecated
    public IRubyObject accept_nonblock() {
        return this.accept_nonblock(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject accept_nonblock(ThreadContext context) {
        RubyUNIXSocket.LibCSocket.sockaddr_un from = new RubyUNIXSocket.LibCSocket.sockaddr_un();
        IntByReference fromlen = new IntByReference(106);
        int flags = INSTANCE.fcntl(this.fd, RubyUNIXSocket.F_GETFL, 0);
        INSTANCE.fcntl(this.fd, RubyUNIXSocket.F_SETFL, flags | RubyUNIXSocket.O_NONBLOCK);
        int fd2 = INSTANCE.accept(this.fd, from, new IntByReference(106));
        if (fd2 < 0) {
            RubyUNIXServer.rb_sys_fail(context.getRuntime(), null);
        }
        Ruby runtime2 = context.getRuntime();
        RubyUNIXSocket sock = (RubyUNIXSocket)RuntimeHelpers.invoke(context, runtime2.fastGetClass("UNIXSocket"), "allocate");
        sock.fd = fd2;
        sock.fpath = new String(from.sun_path);
        sock.init_sock(context.getRuntime());
        return sock;
    }

    @Deprecated
    public IRubyObject sysaccept() {
        return this.accept(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject sysaccept(ThreadContext context) {
        return this.accept(context);
    }

    @Deprecated
    public IRubyObject listen(IRubyObject log2) {
        return this.listen(this.getRuntime().getCurrentContext(), log2);
    }

    @JRubyMethod
    public IRubyObject listen(ThreadContext context, IRubyObject log2) {
        if (INSTANCE.listen(this.fd, RubyNumeric.fix2int(log2)) < 0) {
            RubyUNIXServer.rb_sys_fail(context.getRuntime(), "listen(2)");
        }
        return context.getRuntime().newFixnum(0);
    }
}

