/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.addons.IOJavaAddons;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.Stream;

@JRubyClass(name={"StringIO"})
public class RubyStringIO
extends RubyObject {
    private static ObjectAllocator STRINGIO_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyStringIO(runtime2, klass);
        }
    };
    private long pos = 0L;
    private int lineno = 0;
    private boolean eof = false;
    private RubyString internal;
    private boolean closedRead = false;
    private boolean closedWrite = false;
    ModeFlags modes;
    public static final ByteList NEWLINE = ByteList.create("\n");

    public static RubyClass createStringIOClass(Ruby runtime2) {
        RubyClass stringIOClass = runtime2.defineClass("StringIO", runtime2.fastGetClass("Data"), STRINGIO_ALLOCATOR);
        stringIOClass.defineAnnotatedMethods(RubyStringIO.class);
        stringIOClass.includeModule(runtime2.getEnumerable());
        if (runtime2.getObject().isConstantDefined("Java")) {
            stringIOClass.defineAnnotatedMethods(IOJavaAddons.AnyIO.class);
        }
        return stringIOClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, optional=2, frame=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyStringIO strio;
        IRubyObject val = strio = (RubyStringIO)((RubyClass)recv2).newInstance(context, args2, Block.NULL_BLOCK);
        if (block.isGiven()) {
            try {
                val = block.yield(context, strio);
            }
            finally {
                strio.doFinalize();
            }
        }
        return val;
    }

    protected RubyStringIO(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    private void initializeModes(Object modeArgument) {
        try {
            this.modes = modeArgument == null ? new ModeFlags(RubyIO.getIOModesIntFromString(this.getRuntime(), "r+")) : (modeArgument instanceof Long ? new ModeFlags((Long)modeArgument) : new ModeFlags(RubyIO.getIOModesIntFromString(this.getRuntime(), (String)modeArgument)));
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.setupModes();
    }

    @JRubyMethod(name={"initialize"}, optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
        Object modeArgument = null;
        switch (args2.length) {
            case 0: {
                this.internal = RubyString.newEmptyString(this.getRuntime());
                modeArgument = "r+";
                break;
            }
            case 1: {
                this.internal = args2[0].convertToString();
                modeArgument = this.internal.isFrozen() ? "r" : "r+";
                break;
            }
            case 2: {
                this.internal = args2[0].convertToString();
                modeArgument = args2[1] instanceof RubyFixnum ? Long.valueOf(RubyFixnum.fix2long(args2[1])) : args2[1].convertToString().toString();
            }
        }
        this.initializeModes(modeArgument);
        if (this.modes.isWritable() && this.internal.isFrozen()) {
            throw this.getRuntime().newErrnoEACCESError("Permission denied");
        }
        if (this.modes.isTruncate()) {
            this.internal.modifyCheck();
            this.internal.empty();
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject other) {
        RubyStringIO otherIO = (RubyStringIO)TypeConverter.convertToType(other, this.getRuntime().fastGetClass("StringIO"), "to_strio");
        if (this == otherIO) {
            return this;
        }
        this.pos = otherIO.pos;
        this.lineno = otherIO.lineno;
        this.eof = otherIO.eof;
        this.closedRead = otherIO.closedRead;
        this.closedWrite = otherIO.closedWrite;
        this.internal = otherIO.internal;
        this.modes = otherIO.modes;
        if (otherIO.isTaint()) {
            this.setTaint(true);
        }
        return this;
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject append(ThreadContext context, IRubyObject arg2) {
        this.writeInternal(context, arg2);
        return this;
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        return this;
    }

    @JRubyMethod(name={"close"}, frame=true)
    public IRubyObject close() {
        this.checkInitialized();
        this.checkOpen();
        this.closedRead = true;
        this.closedWrite = true;
        return this.getRuntime().getNil();
    }

    private void doFinalize() {
        this.closedRead = true;
        this.closedWrite = true;
        this.internal = null;
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.closedRead && this.closedWrite);
    }

    @JRubyMethod(name={"close_read"})
    public IRubyObject close_read() {
        this.checkReadable();
        this.closedRead = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed_read?"})
    public IRubyObject closed_read_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.closedRead);
    }

    @JRubyMethod(name={"close_write"})
    public IRubyObject close_write() {
        this.checkWritable();
        this.closedWrite = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed_write?"})
    public IRubyObject closed_write_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.closedWrite);
    }

    @JRubyMethod(name={"each"}, optional=1, frame=true, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject line = this.getsOnly(context, args2);
        while (!line.isNil()) {
            block.yield(context, line);
            line = this.getsOnly(context, args2);
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public IRubyObject each_byte(ThreadContext context, Block block) {
        this.checkReadable();
        Ruby runtime2 = context.getRuntime();
        ByteList bytes2 = this.internal.getByteList();
        while (this.pos < (long)bytes2.length()) {
            block.yield(context, runtime2.newFixnum(bytes2.get((int)this.pos++) & 0xFF));
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"each_line"}, optional=1, frame=true)
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.each(context, args2, block);
    }

    @JRubyMethod(name={"eof", "eof?"})
    public IRubyObject eof() {
        return this.getRuntime().newBoolean(this.isEOF());
    }

    private boolean isEOF() {
        return this.pos >= (long)this.internal.getByteList().length() || this.eof;
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl() {
        throw this.getRuntime().newNotImplementedError("fcntl not implemented");
    }

    @JRubyMethod(name={"fileno"})
    public IRubyObject fileno() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"flush"})
    public IRubyObject flush() {
        return this;
    }

    @JRubyMethod(name={"fsync"})
    public IRubyObject fsync() {
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"getc"})
    public IRubyObject getc() {
        this.checkReadable();
        if (this.pos >= (long)this.internal.getByteList().length()) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.internal.getByteList().get((int)this.pos++) & 0xFF);
    }

    private IRubyObject internalGets(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (this.pos < (long)this.internal.getByteList().realSize && !this.eof) {
            ByteList add3;
            int ix;
            ByteList sep;
            boolean isParagraph = false;
            if (args2.length > 0) {
                if (args2[0].isNil()) {
                    ByteList buf = this.internal.getByteList().makeShared((int)this.pos, this.internal.getByteList().realSize - (int)this.pos);
                    this.pos += (long)buf.realSize;
                    return RubyString.newString(runtime2, buf);
                }
                sep = args2[0].convertToString().getByteList();
                if (sep.realSize == 0) {
                    isParagraph = true;
                    sep = Stream.PARAGRAPH_SEPARATOR;
                }
            } else {
                sep = ((RubyString)runtime2.getGlobalVariables().get("$/")).getByteList();
            }
            ByteList ss = this.internal.getByteList();
            if (isParagraph) {
                this.swallowLF(ss);
                if (this.pos == (long)ss.realSize) {
                    return runtime2.getNil();
                }
            }
            if (-1 == (ix = ss.indexOf(sep, (int)this.pos))) {
                ix = this.internal.getByteList().realSize;
                add3 = ByteList.EMPTY_BYTELIST;
            } else {
                add3 = isParagraph ? NEWLINE : sep;
            }
            ByteList line = new ByteList(ix - (int)this.pos + add3.length());
            line.append(this.internal.getByteList(), (int)this.pos, ix - (int)this.pos);
            line.append(add3);
            this.pos = ix + add3.realSize;
            ++this.lineno;
            return RubyString.newString(runtime2, line);
        }
        return runtime2.getNil();
    }

    private void swallowLF(ByteList list2) {
        while (this.pos < (long)list2.realSize && list2.get((int)this.pos) == 10) {
            ++this.pos;
        }
    }

    @JRubyMethod(name={"gets"}, optional=1, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
        IRubyObject result = this.getsOnly(context, args2);
        context.getCurrentScope().setLastLine(result);
        return result;
    }

    public IRubyObject getsOnly(ThreadContext context, IRubyObject[] args2) {
        this.checkReadable();
        return this.internalGets(context, args2);
    }

    @JRubyMethod(name={"tty?", "isatty"})
    public IRubyObject isatty() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length() {
        this.checkFinalized();
        return this.getRuntime().newFixnum(this.internal.getByteList().length());
    }

    @JRubyMethod(name={"lineno"})
    public IRubyObject lineno() {
        return this.getRuntime().newFixnum(this.lineno);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public IRubyObject set_lineno(IRubyObject arg2) {
        this.lineno = RubyNumeric.fix2int(arg2);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"path"})
    public IRubyObject path() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pos", "tell"})
    public IRubyObject pos() {
        return this.getRuntime().newFixnum(this.pos);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject arg2) {
        this.pos = RubyNumeric.fix2int(arg2);
        if (this.pos < 0L) {
            throw this.getRuntime().newErrnoEINVALError("Invalid argument");
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"print"}, rest=true)
    public IRubyObject print(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (args2.length != 0) {
            int j = args2.length;
            for (int i = 0; i < j; ++i) {
                this.append(context, args2[i]);
            }
        } else {
            IRubyObject arg2 = runtime2.getGlobalVariables().get("$_");
            this.append(context, arg2.isNil() ? runtime2.newString("nil") : arg2);
        }
        IRubyObject sep = runtime2.getGlobalVariables().get("$\\");
        if (!sep.isNil()) {
            this.append(context, sep);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
        this.append(context, RubyKernel.sprintf(context, this, args2));
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1)
    public IRubyObject putc(IRubyObject obj) {
        this.checkWritable();
        byte c = RubyNumeric.num2chr(obj);
        this.checkFrozen();
        this.internal.modify();
        ByteList bytes2 = this.internal.getByteList();
        if (this.modes.isAppendable()) {
            this.pos = bytes2.length();
            bytes2.append(c);
        } else {
            if (this.pos >= (long)bytes2.length()) {
                bytes2.length((int)this.pos + 1);
            }
            bytes2.set((int)this.pos, c);
            ++this.pos;
        }
        return obj;
    }

    /*
     * Enabled aggressive block sorting
     */
    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        this.checkWritable();
        if (args2.length == 0) {
            this.callMethod(context, "write", RubyString.newStringShared(this.getRuntime(), NEWLINE));
            return this.getRuntime().getNil();
        }
        int i = 0;
        while (true) {
            block8: {
                RubyString line;
                block5: {
                    block6: {
                        RubyArray arr;
                        block7: {
                            block4: {
                                if (i >= args2.length) {
                                    return this.getRuntime().getNil();
                                }
                                if (!args2[i].isNil()) break block4;
                                line = this.getRuntime().newString("nil");
                                break block5;
                            }
                            IRubyObject tmp = args2[i].checkArrayType();
                            if (tmp.isNil()) break block6;
                            arr = (RubyArray)tmp;
                            if (!this.getRuntime().isInspecting(arr)) break block7;
                            line = this.getRuntime().newString("[...]");
                            break block5;
                        }
                        this.inspectPuts(context, arr);
                        break block8;
                    }
                    line = args2[i] instanceof RubyString ? (RubyString)args2[i] : args2[i].asString();
                }
                this.callMethod(context, "write", line);
                if (!line.getByteList().endsWith(NEWLINE)) {
                    this.callMethod(context, "write", RubyString.newStringShared(this.getRuntime(), NEWLINE));
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject inspectPuts(ThreadContext context, RubyArray array) {
        try {
            this.getRuntime().registerInspecting(array);
            IRubyObject iRubyObject = this.puts(context, array.toJavaArray());
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(array);
        }
    }

    @JRubyMethod(name={"read"}, optional=2)
    public IRubyObject read(IRubyObject[] args2) {
        this.checkReadable();
        ByteList buf = null;
        int length2 = 0;
        int oldLength = 0;
        RubyString originalString = null;
        switch (args2.length) {
            case 2: {
                originalString = args2[1].convertToString();
                originalString.modify();
                buf = originalString.getByteList();
            }
            case 1: {
                if (!args2[0].isNil()) {
                    oldLength = length2 = RubyNumeric.fix2int(args2[0]);
                    if (length2 < 0) {
                        throw this.getRuntime().newArgumentError("negative length " + length2 + " given");
                    }
                    if (length2 > 0 && this.pos >= (long)this.internal.getByteList().length()) {
                        this.eof = true;
                        if (buf != null) {
                            buf.realSize = 0;
                        }
                        return this.getRuntime().getNil();
                    }
                    if (!this.eof) break;
                    if (buf != null) {
                        buf.realSize = 0;
                    }
                    return this.getRuntime().getNil();
                }
            }
            case 0: {
                oldLength = -1;
                length2 = this.internal.getByteList().length();
                if ((long)length2 <= this.pos) {
                    this.eof = true;
                    if (buf == null) {
                        buf = new ByteList();
                    } else {
                        buf.realSize = 0;
                    }
                    return this.getRuntime().newString(buf);
                }
                length2 = (int)((long)length2 - this.pos);
                break;
            }
            default: {
                this.getRuntime().newArgumentError(args2.length, 0);
            }
        }
        if (buf == null) {
            int internalLength = this.internal.getByteList().length();
            if (internalLength > 0) {
                if ((long)internalLength >= this.pos + (long)length2) {
                    buf = new ByteList(this.internal.getByteList(), (int)this.pos, length2);
                } else {
                    int rest2 = (int)((long)this.internal.getByteList().length() - this.pos);
                    if (length2 > rest2) {
                        length2 = rest2;
                    }
                    buf = new ByteList(this.internal.getByteList(), (int)this.pos, length2);
                }
            }
        } else {
            byte[] target;
            int rest3 = (int)((long)this.internal.getByteList().length() - this.pos);
            if (length2 > rest3) {
                length2 = rest3;
            }
            if ((target = buf.bytes).length > length2) {
                System.arraycopy(this.internal.getByteList().bytes, (int)this.pos, target, 0, length2);
                buf.begin = 0;
                buf.realSize = length2;
            } else {
                target = new byte[length2];
                System.arraycopy(this.internal.getByteList().bytes, (int)this.pos, target, 0, length2);
                buf.begin = 0;
                buf.realSize = length2;
                buf.bytes = target;
            }
        }
        if (buf == null) {
            if (!this.eof) {
                buf = new ByteList();
            }
            length2 = 0;
        } else {
            length2 = buf.length();
            this.pos += (long)length2;
        }
        if (oldLength < 0 || oldLength > length2) {
            this.eof = true;
        }
        return originalString != null ? originalString : this.getRuntime().newString(buf);
    }

    @JRubyMethod(name={"readchar"})
    public IRubyObject readchar() {
        IRubyObject c = this.getc();
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"readline"}, optional=1, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context, IRubyObject[] args2) {
        IRubyObject line = this.gets(context, args2);
        if (line.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=1)
    public IRubyObject readlines(ThreadContext context, IRubyObject[] arg2) {
        IRubyObject line;
        this.checkReadable();
        ArrayList<IRubyObject> lns = new ArrayList<IRubyObject>();
        while (!this.isEOF() && !(line = this.internalGets(context, arg2)).isNil()) {
            lns.add(line);
        }
        return this.getRuntime().newArray(lns);
    }

    @JRubyMethod(name={"reopen"}, required=0, optional=2)
    public IRubyObject reopen(IRubyObject[] args2) {
        if (args2.length == 1 && !(args2[0] instanceof RubyString)) {
            return this.initialize_copy(args2[0]);
        }
        this.doRewind();
        this.closedRead = false;
        this.closedWrite = false;
        return this.initialize(args2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        this.doRewind();
        return RubyFixnum.zero(this.getRuntime());
    }

    private void doRewind() {
        this.pos = 0L;
        this.eof = false;
        this.lineno = 0;
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1, frame=true)
    public IRubyObject seek(IRubyObject[] args2) {
        this.checkFinalized();
        long amount = RubyNumeric.num2long(args2[0]);
        int whence = 0;
        long newPosition = this.pos;
        if (args2.length > 1 && !args2[0].isNil()) {
            whence = RubyNumeric.fix2int(args2[1]);
        }
        newPosition = whence == 1 ? (newPosition += amount) : (whence == 2 ? (long)this.internal.getByteList().length() + amount : amount);
        if (newPosition < 0L) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.pos = newPosition;
        this.eof = false;
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(IRubyObject arg2) {
        return this.reopen(new IRubyObject[]{arg2.convertToString()});
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject set_sync(IRubyObject args2) {
        return args2;
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string() {
        if (this.internal == null) {
            return this.getRuntime().getNil();
        }
        return this.internal;
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"sysread"}, optional=2)
    public IRubyObject sysread(IRubyObject[] args2) {
        IRubyObject obj = this.read(args2);
        if (this.isEOF() && (obj.isNil() || ((RubyString)obj).getByteList().length() == 0)) {
            throw this.getRuntime().newEOFError();
        }
        return obj;
    }

    @JRubyMethod(name={"truncate"}, required=1)
    public IRubyObject truncate(IRubyObject arg2) {
        this.checkWritable();
        int len = RubyFixnum.fix2int(arg2);
        if (len < 0) {
            throw this.getRuntime().newErrnoEINVALError("negative legnth");
        }
        this.internal.modify();
        this.internal.getByteList().length(len);
        return arg2;
    }

    @JRubyMethod(name={"ungetc"}, required=1)
    public IRubyObject ungetc(IRubyObject arg2) {
        this.checkReadable();
        int c = RubyNumeric.num2int(arg2);
        if (this.pos == 0L) {
            return this.getRuntime().getNil();
        }
        this.internal.modify();
        --this.pos;
        ByteList bytes2 = this.internal.getByteList();
        if ((long)bytes2.length() <= this.pos) {
            bytes2.length((int)this.pos + 1);
        }
        bytes2.set((int)this.pos, c);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"write", "syswrite"}, required=1)
    public IRubyObject write(ThreadContext context, IRubyObject arg2) {
        return context.getRuntime().newFixnum(this.writeInternal(context, arg2));
    }

    private int writeInternal(ThreadContext context, IRubyObject arg2) {
        this.checkWritable();
        this.checkFrozen();
        RubyString val = arg2.asString();
        this.internal.modify();
        if (this.modes.isAppendable()) {
            this.internal.getByteList().append(val.getByteList());
            this.pos = this.internal.getByteList().length();
        } else {
            int left = this.internal.getByteList().length() - (int)this.pos;
            this.internal.getByteList().replace((int)this.pos, Math.min(val.getByteList().length(), left), val.getByteList());
            this.pos += (long)val.getByteList().length();
        }
        if (val.isTaint()) {
            this.internal.setTaint(true);
        }
        return val.getByteList().length();
    }

    protected void checkFrozen() {
        this.checkInitialized();
        if (this.internal.isFrozen()) {
            throw this.getRuntime().newIOError("not modifiable string");
        }
    }

    private void checkReadable() {
        this.checkInitialized();
        if (this.closedRead || !this.modes.isReadable()) {
            throw this.getRuntime().newIOError("not opened for reading");
        }
    }

    private void checkWritable() {
        this.checkInitialized();
        if (this.closedWrite || !this.modes.isWritable()) {
            throw this.getRuntime().newIOError("not opened for writing");
        }
    }

    private void checkInitialized() {
        if (this.modes == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    private void checkFinalized() {
        if (this.internal == null) {
            throw this.getRuntime().newIOError("not opened");
        }
    }

    private void checkOpen() {
        if (this.closedRead && this.closedWrite) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    private void setupModes() {
        this.closedWrite = false;
        this.closedRead = false;
        if (this.modes.isReadOnly()) {
            this.closedWrite = true;
        }
        if (!this.modes.isReadable()) {
            this.closedRead = true;
        }
    }
}

