/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.ByteList;

@JRubyModule(name={"Digest"})
public class RubyDigest {
    private static Provider provider = null;

    public static void createDigest(Ruby runtime2) {
        try {
            provider = (Provider)Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        RubyModule mDigest = runtime2.defineModule("Digest");
        RubyClass cDigestBase = mDigest.defineClassUnder("Base", runtime2.getObject(), Base.BASE_ALLOCATOR);
        cDigestBase.defineAnnotatedMethods(Base.class);
    }

    private static MessageDigest createMessageDigest(Ruby runtime2, String providerName) throws NoSuchAlgorithmException {
        if (provider != null) {
            try {
                return MessageDigest.getInstance(providerName, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return MessageDigest.getInstance(providerName);
    }

    public static void createDigestMD5(Ruby runtime2) {
        runtime2.getLoadService().require("digest.so");
        RubyModule mDigest = runtime2.fastGetModule("Digest");
        RubyClass cDigestBase = mDigest.fastGetClass("Base");
        RubyClass cDigest_MD5 = mDigest.defineClassUnder("MD5", cDigestBase, cDigestBase.getAllocator());
        cDigest_MD5.defineFastMethod("block_length", new Callback(){

            public Arity getArity() {
                return Arity.NO_ARGUMENTS;
            }

            public IRubyObject execute(IRubyObject recv2, IRubyObject[] args2, Block block) {
                return RubyFixnum.newFixnum(recv2.getRuntime(), 64L);
            }
        });
        cDigest_MD5.setInternalModuleVariable("metadata", runtime2.newString("MD5"));
    }

    public static void createDigestRMD160(Ruby runtime2) {
        runtime2.getLoadService().require("digest.so");
        if (provider == null) {
            throw runtime2.newLoadError("RMD160 not supported without BouncyCastle");
        }
        RubyModule mDigest = runtime2.fastGetModule("Digest");
        RubyClass cDigestBase = mDigest.fastGetClass("Base");
        RubyClass cDigest_RMD160 = mDigest.defineClassUnder("RMD160", cDigestBase, cDigestBase.getAllocator());
        cDigest_RMD160.setInternalModuleVariable("metadata", runtime2.newString("RIPEMD160"));
    }

    public static void createDigestSHA1(Ruby runtime2) {
        runtime2.getLoadService().require("digest.so");
        RubyModule mDigest = runtime2.fastGetModule("Digest");
        RubyClass cDigestBase = mDigest.fastGetClass("Base");
        RubyClass cDigest_SHA1 = mDigest.defineClassUnder("SHA1", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA1.setInternalModuleVariable("metadata", runtime2.newString("SHA1"));
    }

    public static void createDigestSHA2(Ruby runtime2) {
        runtime2.getLoadService().require("digest.so");
        try {
            RubyDigest.createMessageDigest(runtime2, "SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw runtime2.newLoadError("SHA2 not supported");
        }
        RubyModule mDigest = runtime2.fastGetModule("Digest");
        RubyClass cDigestBase = mDigest.fastGetClass("Base");
        RubyClass cDigest_SHA2_256 = mDigest.defineClassUnder("SHA256", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA2_256.setInternalModuleVariable("metadata", runtime2.newString("SHA-256"));
        cDigest_SHA2_256.defineFastMethod("block_length", new Callback(){

            public Arity getArity() {
                return Arity.NO_ARGUMENTS;
            }

            public IRubyObject execute(IRubyObject recv2, IRubyObject[] args2, Block block) {
                return RubyFixnum.newFixnum(recv2.getRuntime(), 64L);
            }
        });
        RubyClass cDigest_SHA2_384 = mDigest.defineClassUnder("SHA384", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA2_384.setInternalModuleVariable("metadata", runtime2.newString("SHA-384"));
        cDigest_SHA2_384.defineFastMethod("block_length", new Callback(){

            public Arity getArity() {
                return Arity.NO_ARGUMENTS;
            }

            public IRubyObject execute(IRubyObject recv2, IRubyObject[] args2, Block block) {
                return RubyFixnum.newFixnum(recv2.getRuntime(), 128L);
            }
        });
        RubyClass cDigest_SHA2_512 = mDigest.defineClassUnder("SHA512", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA2_512.setInternalModuleVariable("metadata", runtime2.newString("SHA-512"));
        cDigest_SHA2_512.defineFastMethod("block_length", new Callback(){

            public Arity getArity() {
                return Arity.NO_ARGUMENTS;
            }

            public IRubyObject execute(IRubyObject recv2, IRubyObject[] args2, Block block) {
                return RubyFixnum.newFixnum(recv2.getRuntime(), 128L);
            }
        });
    }

    @JRubyClass(name={"Digest::Base"})
    public static class Base
    extends RubyObject {
        protected static final ObjectAllocator BASE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new Base(runtime2, klass);
            }
        };
        private MessageDigest algo;
        static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};

        @JRubyMethod(name={"digest"}, required=1, meta=true)
        public static IRubyObject s_digest(IRubyObject recv2, IRubyObject str) {
            Ruby runtime2 = recv2.getRuntime();
            String name2 = ((RubyClass)recv2).searchInternalModuleVariable("metadata").toString();
            try {
                MessageDigest md = RubyDigest.createMessageDigest(runtime2, name2);
                return RubyString.newStringShared(runtime2, md.digest(str.convertToString().getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw recv2.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name2 + ")");
            }
        }

        @JRubyMethod(name={"hexdigest"}, required=1, meta=true)
        public static IRubyObject s_hexdigest(IRubyObject recv2, IRubyObject str) {
            Ruby runtime2 = recv2.getRuntime();
            String name2 = ((RubyClass)recv2).searchInternalModuleVariable("metadata").toString();
            try {
                MessageDigest md = RubyDigest.createMessageDigest(runtime2, name2);
                return RubyString.newStringNoCopy(runtime2, ByteList.plain(Base.toHex(md.digest(str.convertToString().getBytes()))));
            }
            catch (NoSuchAlgorithmException e) {
                throw recv2.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name2 + ")");
            }
        }

        public Base(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
            if (type2 == runtime2.fastGetModule("Digest").fastGetClass("Base")) {
                throw runtime2.newNotImplementedError("Digest::Base is an abstract class");
            }
            if (!type2.hasInternalModuleVariable("metadata")) {
                throw runtime2.newNotImplementedError("the " + type2 + "() function is unimplemented on this machine");
            }
            try {
                this.setAlgorithm(type2.searchInternalModuleVariable("metadata"));
            }
            catch (NoSuchAlgorithmException e) {
                throw runtime2.newNotImplementedError("the " + type2 + "() function is unimplemented on this machine");
            }
        }

        @JRubyMethod(name={"initialize"}, optional=1, frame=true)
        public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
            if (args2.length > 0 && !args2[0].isNil()) {
                this.update(args2[0]);
            }
            return this;
        }

        @JRubyMethod(name={"initialize_copy"}, required=1)
        public IRubyObject initialize_copy(IRubyObject obj) {
            if (this == obj) {
                return this;
            }
            ((RubyObject)obj).checkFrozen();
            String name2 = ((Base)obj).algo.getAlgorithm();
            try {
                this.algo = (MessageDigest)((Base)obj).algo.clone();
            }
            catch (CloneNotSupportedException e) {
                throw this.getRuntime().newTypeError("Could not initialize copy of digest (" + name2 + ")");
            }
            return this;
        }

        @JRubyMethod(name={"update", "<<"}, required=1)
        public IRubyObject update(IRubyObject obj) {
            ByteList bytes2 = obj.convertToString().getByteList();
            this.algo.update(bytes2.bytes, bytes2.begin, bytes2.realSize);
            return this;
        }

        @JRubyMethod(name={"digest"}, optional=1)
        public IRubyObject digest(IRubyObject[] args2) {
            if (args2.length == 1) {
                this.algo.reset();
                this.update(args2[0]);
            }
            IRubyObject digest2 = this.getDigestString();
            if (args2.length == 1) {
                this.algo.reset();
            }
            return digest2;
        }

        @JRubyMethod(name={"digest!"})
        public IRubyObject digest_bang() {
            IRubyObject digest2 = this.getDigestStringNoClone();
            this.reset();
            return digest2;
        }

        @JRubyMethod(name={"hexdigest"}, optional=1)
        public IRubyObject hexdigest(IRubyObject[] args2) {
            if (args2.length == 1) {
                this.algo.reset();
                this.update(args2[0]);
            }
            IRubyObject digest2 = this.getDigestHexString();
            if (args2.length == 1) {
                this.algo.reset();
            }
            return digest2;
        }

        @JRubyMethod(name={"to_s"})
        public IRubyObject to_s() {
            return this.getDigestHexString();
        }

        @JRubyMethod(name={"hexdigest!"})
        public IRubyObject hexdigest_bang() {
            IRubyObject digest2 = this.getDigestHexStringNoClone();
            this.reset();
            return digest2;
        }

        @JRubyMethod(name={"inspect"})
        public IRubyObject inspect() {
            return RubyString.newStringNoCopy(this.getRuntime(), ByteList.plain("#<" + this.getMetaClass().getRealClass().getName() + ": " + this.getDigestHex() + ">"));
        }

        @JRubyMethod(name={"=="}, required=1)
        public IRubyObject op_equal(IRubyObject oth) {
            boolean ret;
            boolean bl = ret = this == oth;
            if (!ret) {
                if (oth instanceof Base) {
                    Base b = (Base)oth;
                    ret = this.algo.getAlgorithm().equals(b.algo.getAlgorithm()) && Arrays.equals(this.getDigest(), b.getDigest());
                } else {
                    RubyString str = oth.convertToString();
                    ret = this.to_s().equals(str);
                }
            }
            return ret ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"length", "size", "digest_length"})
        public IRubyObject length() {
            return RubyFixnum.newFixnum(this.getRuntime(), this.algo.getDigestLength());
        }

        @JRubyMethod(name={"block_length"})
        public IRubyObject block_length() {
            throw this.getRuntime().newRuntimeError(this.getMetaClass() + " doesn't implement block_length()");
        }

        @JRubyMethod(name={"reset"})
        public IRubyObject reset() {
            this.algo.reset();
            return this.getRuntime().getNil();
        }

        private void setAlgorithm(IRubyObject algo) throws NoSuchAlgorithmException {
            this.algo = RubyDigest.createMessageDigest(this.getRuntime(), algo.toString());
        }

        private byte[] getDigest() {
            MessageDigest copy;
            try {
                copy = (MessageDigest)this.algo.clone();
            }
            catch (CloneNotSupportedException cnse) {
                copy = this.algo;
            }
            return copy.digest();
        }

        private byte[] getDigestNoClone() {
            return this.algo.digest();
        }

        private ByteList getDigestHex() {
            return Base.toHex(this.getDigest());
        }

        private ByteList getDigestHexNoClone() {
            return Base.toHex(this.getDigestNoClone());
        }

        private IRubyObject getDigestString() {
            return RubyString.newStringNoCopy(this.getRuntime(), this.getDigest());
        }

        private IRubyObject getDigestStringNoClone() {
            return RubyString.newStringNoCopy(this.getRuntime(), this.getDigestNoClone());
        }

        private IRubyObject getDigestHexString() {
            return RubyString.newStringNoCopy(this.getRuntime(), this.getDigestHex());
        }

        private IRubyObject getDigestHexStringNoClone() {
            return RubyString.newStringNoCopy(this.getRuntime(), this.getDigestHexNoClone());
        }

        private static ByteList toHex(byte[] val) {
            ByteList byteList = new ByteList(val.length * 2);
            int j = val.length;
            for (int i = 0; i < j; ++i) {
                int b = val[i] & 0xFF;
                byteList.append(digits[b >> 4]);
                byteList.append(digits[b & 0xF]);
            }
            return byteList;
        }
    }

    @JRubyClass(name={"Digest::SHA512"}, parent="Digest::Base")
    public static class SHA512 {
    }

    @JRubyClass(name={"Digest::SHA384"}, parent="Digest::Base")
    public static class SHA384 {
    }

    @JRubyClass(name={"Digest::SHA256"}, parent="Digest::Base")
    public static class SHA256 {
    }

    @JRubyClass(name={"Digest::SHA1"}, parent="Digest::Base")
    public static class SHA1 {
    }

    @JRubyClass(name={"Digest::RMD160"}, parent="Digest::Base")
    public static class RMD160 {
    }

    @JRubyClass(name={"Digest::MD5"}, parent="Digest::Base")
    public static class MD5 {
    }
}

