/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.CallbackManager;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.jna.AllocatedNativeMemoryIO;
import org.jruby.ext.ffi.jna.DynamicLibrary;
import org.jruby.ext.ffi.jna.JNAInvoker;
import org.jruby.ext.ffi.jna.JNAVariadicInvoker;
import org.jruby.ext.ffi.jna.NativeMemoryIO;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factory
extends org.jruby.ext.ffi.Factory {
    static final int LONG_SIZE = Platform.getPlatform().longSize();
    static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    static final int REGISTER_SIZE = Platform.getPlatform().addressSize();
    static final long LONG_MASK = LONG_SIZE == 32 ? Integer.MAX_VALUE : Long.MAX_VALUE;
    static final int LONG_ALIGN = Factory.isSparc() ? 64 : LONG_SIZE;
    static final int ADDRESS_ALIGN = Factory.isSparc() ? 64 : REGISTER_SIZE;
    static final int DOUBLE_ALIGN = Factory.isSparc() ? 64 : REGISTER_SIZE;
    static final int FLOAT_ALIGN = Factory.isSparc() ? 64 : 32;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Ruby runtime2, RubyModule ffi2) {
        super.init(runtime2, ffi2);
        RubyModule rubyModule = ffi2;
        synchronized (rubyModule) {
            if (ffi2.fastGetClass("DynamicLibrary") == null) {
                DynamicLibrary.createDynamicLibraryClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Invoker") == null) {
                JNAInvoker.createInvokerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("VariadicInvoker") == null) {
                JNAVariadicInvoker.createVariadicInvokerClass(runtime2, ffi2);
            }
            ffi2.defineModuleUnder("LastError").defineAnnotatedMethods(LastError.class);
        }
    }

    @Override
    public <T> T loadLibrary(String libraryName, Class<T> libraryClass) {
        try {
            return libraryClass.cast(Native.loadLibrary(libraryName, libraryClass));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public AllocatedDirectMemoryIO allocateDirectMemory(Ruby runtime2, int size2, boolean clear2) {
        return AllocatedNativeMemoryIO.allocate(size2, clear2);
    }

    @Override
    public DirectMemoryIO wrapDirectMemory(long address2) {
        com.sun.jna.Pointer ptr;
        if (Platform.getPlatform().addressSize() == 32) {
            IntByReference ref = new IntByReference((int)address2);
            ptr = ref.getPointer().getPointer(0L);
        } else {
            LongByReference ref = new LongByReference(address2);
            ptr = ref.getPointer().getPointer(0L);
        }
        return ptr != null ? new NativeMemoryIO(ptr) : null;
    }

    @Override
    public CallbackManager getCallbackManager() {
        return new CallbackManager(){

            public Pointer getCallback(Ruby runtime2, CallbackInfo cbInfo, Object proc2) {
                throw runtime2.newNotImplementedError("Not implemented");
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSparc() {
        Platform.CPU cpu = Platform.getPlatform().getCPU();
        if (cpu == Platform.CPU.SPARC) return true;
        if (cpu != Platform.CPU.SPARCV9) return false;
        return true;
    }

    @Override
    public int sizeOf(NativeType type2) {
        switch (type2) {
            case VOID: {
                return 0;
            }
            case INT8: 
            case UINT8: {
                return 1;
            }
            case INT16: 
            case UINT16: {
                return 2;
            }
            case INT32: 
            case UINT32: {
                return 4;
            }
            case INT64: 
            case UINT64: {
                return 8;
            }
            case LONG: 
            case ULONG: {
                return Platform.getPlatform().longSize() >> 3;
            }
            case FLOAT32: {
                return 4;
            }
            case FLOAT64: {
                return 8;
            }
            case BUFFER_IN: 
            case BUFFER_INOUT: 
            case BUFFER_OUT: 
            case POINTER: 
            case STRING: 
            case RBXSTRING: {
                return Platform.getPlatform().addressSize() >> 3;
            }
        }
        throw new UnsupportedOperationException("Cannot determine native type for " + type2);
    }

    @Override
    public int alignmentOf(NativeType type2) {
        switch (type2) {
            case VOID: {
                return 0;
            }
            case INT8: 
            case UINT8: {
                return 1;
            }
            case INT16: 
            case UINT16: {
                return 2;
            }
            case INT32: 
            case UINT32: {
                return 4;
            }
            case INT64: 
            case UINT64: {
                return LONG_ALIGN / 8;
            }
            case LONG: 
            case ULONG: {
                return LONG_ALIGN / 8;
            }
            case FLOAT32: {
                return FLOAT_ALIGN / 8;
            }
            case FLOAT64: {
                return DOUBLE_ALIGN / 8;
            }
            case BUFFER_IN: 
            case BUFFER_INOUT: 
            case BUFFER_OUT: 
            case POINTER: 
            case STRING: 
            case RBXSTRING: {
                return ADDRESS_ALIGN / 8;
            }
        }
        throw new UnsupportedOperationException("Cannot determine native type for " + type2);
    }

    public static final class LastError {
        @JRubyMethod(name={"error"}, meta=true)
        public static final IRubyObject error(ThreadContext context, IRubyObject recv2) {
            return context.getRuntime().newFixnum(Native.getLastError());
        }
    }
}

