/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.Convert;
import org.jruby.util.Numeric;
import org.jruby.util.Sprintf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Float"}, parent="Numeric", include={"Precision"})
public class RubyFloat
extends RubyNumeric {
    private final double value;
    private static final DecimalFormat FORMAT = new DecimalFormat("##############0.0##############", new DecimalFormatSymbols(Locale.ENGLISH));
    static final int DBL_MANT_DIG = 53;
    static final int FLT_RADIX = 2;
    private static final Pattern pattern = Pattern.compile("\\.?0+(e|$)");

    public static RubyClass createFloatClass(Ruby runtime2) {
        RubyClass floatc = runtime2.defineClass("Float", runtime2.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setFloat(floatc);
        floatc.index = 11;
        floatc.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyFloat;
            }
        };
        floatc.getSingletonClass().undefineMethod("new");
        if (!runtime2.is1_9()) {
            floatc.includeModule(runtime2.getPrecision());
        }
        floatc.defineConstant("ROUNDS", RubyFixnum.newFixnum(runtime2, 1L));
        floatc.defineConstant("RADIX", RubyFixnum.newFixnum(runtime2, 2L));
        floatc.defineConstant("MANT_DIG", RubyFixnum.newFixnum(runtime2, 53L));
        floatc.defineConstant("DIG", RubyFixnum.newFixnum(runtime2, 15L));
        floatc.defineConstant("MIN_EXP", RubyFixnum.newFixnum(runtime2, -1021L));
        floatc.defineConstant("MAX_EXP", RubyFixnum.newFixnum(runtime2, 1024L));
        floatc.defineConstant("MIN_10_EXP", RubyFixnum.newFixnum(runtime2, -307L));
        floatc.defineConstant("MAX_10_EXP", RubyFixnum.newFixnum(runtime2, 308L));
        floatc.defineConstant("MIN", RubyFloat.newFloat(runtime2, Double.MIN_VALUE));
        floatc.defineConstant("MAX", RubyFloat.newFloat(runtime2, Double.MAX_VALUE));
        floatc.defineConstant("EPSILON", RubyFloat.newFloat(runtime2, 2.220446049250313E-16));
        floatc.defineAnnotatedMethods(RubyFloat.class);
        return floatc;
    }

    @Override
    public int getNativeTypeIndex() {
        return 11;
    }

    public RubyFloat(Ruby runtime2) {
        this(runtime2, 0.0);
    }

    public RubyFloat(Ruby runtime2, double value2) {
        super(runtime2, runtime2.getFloat());
        this.value = value2;
    }

    @Override
    public Class<?> getJavaClass() {
        return Double.TYPE;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return (long)this.value;
    }

    @Override
    public RubyFloat convertToFloat() {
        return this;
    }

    protected int compareValue(RubyNumeric other) {
        double otherVal = other.getDoubleValue();
        return this.getValue() > otherVal ? 1 : (this.getValue() < otherVal ? -1 : 0);
    }

    public static RubyFloat newFloat(Ruby runtime2, double value2) {
        return new RubyFloat(runtime2, value2);
    }

    @JRubyMethod(name={"induced_from"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv2, IRubyObject number) {
        if (number instanceof RubyFixnum || number instanceof RubyBignum || number instanceof RubyRational) {
            return number.callMethod(context, "to_f");
        }
        if (number instanceof RubyFloat) {
            return number;
        }
        throw recv2.getRuntime().newTypeError("failed to convert " + number.getMetaClass() + " into Float");
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        ASCIIEncoding ascii;
        Ruby runtime2 = this.getRuntime();
        if (Double.isInfinite(this.value)) {
            return RubyString.newString(runtime2, this.value < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(this.value)) {
            return RubyString.newString(runtime2, "NaN");
        }
        ByteList buf = new ByteList();
        Sprintf.sprintf(buf, Locale.US, (CharSequence)"%#.15g", this);
        int e = buf.indexOf(101);
        if (e == -1) {
            e = buf.realSize;
        }
        if (!(ascii = ASCIIEncoding.INSTANCE).isDigit(buf.get(e - 1))) {
            buf.realSize = 0;
            Sprintf.sprintf(buf, Locale.US, (CharSequence)"%#.14e", this);
            e = buf.indexOf(101);
            if (e == -1) {
                e = buf.realSize;
            }
        }
        int p2 = e;
        while (buf.get(p2 - 1) == 48 && ascii.isDigit(buf.get(p2 - 2))) {
            --p2;
        }
        System.arraycopy(buf.bytes, e, buf.bytes, p2, buf.realSize - e);
        buf.realSize = p2 + buf.realSize - e;
        return runtime2.newString(buf);
    }

    @Override
    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject other) {
        return this.getRuntime().newArray((IRubyObject)RubyKernel.new_float(this, other), (IRubyObject)this);
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        return RubyFloat.newFloat(this.getRuntime(), -this.value);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value + ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, "+", other);
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value - ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, "-", other);
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value * ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, "*", other);
    }

    @JRubyMethod(name={"/"}, required=1)
    public IRubyObject op_fdiv(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value / ((RubyNumeric)other).getDoubleValue());
            }
        }
        return this.coerceBin(context, "/", other);
    }

    @JRubyMethod(name={"quo"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject magnitude(ThreadContext context, IRubyObject other) {
        return this.callMethod(context, "/", other);
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double y = ((RubyNumeric)other).getDoubleValue();
                double x = this.value;
                double mod = Math.IEEEremainder(x, y);
                if (y * mod < 0.0) {
                    mod += y;
                }
                return RubyFloat.newFloat(this.getRuntime(), mod);
            }
        }
        return this.coerceBin(context, "%", other);
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double y = ((RubyNumeric)other).getDoubleValue();
                double x = this.value;
                double mod = Math.IEEEremainder(x, y);
                if (Double.isNaN(mod)) {
                    throw this.getRuntime().newFloatDomainError("NaN");
                }
                double div2 = Math.floor(x / y);
                if (y * mod < 0.0) {
                    mod += y;
                }
                Ruby runtime2 = this.getRuntime();
                IRubyObject car = RubyFloat.dbl2num(runtime2, div2);
                RubyFloat cdr = RubyFloat.newFloat(runtime2, mod);
                return RubyArray.newArray(runtime2, car, cdr);
            }
        }
        return this.coerceBin(context, "divmod", other);
    }

    @JRubyMethod(name={"**"}, required=1)
    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, ((RubyNumeric)other).getDoubleValue()));
            }
        }
        return this.coerceBin(context, "**", other);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyBoolean.newBoolean(this.getRuntime(), this.value == ((RubyNumeric)other).getDoubleValue());
            }
        }
        return super.op_num_equal(context, other);
    }

    @Override
    public final int compareTo(IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return Double.compare(this.value, ((RubyNumeric)other).getDoubleValue());
            }
        }
        return (int)this.coerceCmp(this.getRuntime().getCurrentContext(), "<=>", other).convertToInteger().getLongValue();
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyFloat.dbl_cmp(this.getRuntime(), this.value, b);
            }
        }
        return this.coerceCmp(context, "<=>", other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value > b);
            }
        }
        return this.coerceRelOp(context, ">", other);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value >= b);
            }
        }
        return this.coerceRelOp(context, ">=", other);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value < b);
            }
        }
        return this.coerceRelOp(context, "<", other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double b = ((RubyNumeric)other).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(b) && this.value <= b);
            }
        }
        return this.coerceRelOp(context, "<=", other);
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject other) {
        if (other instanceof RubyFloat) {
            double b = ((RubyFloat)other).value;
            if (Double.isNaN(this.value) || Double.isNaN(b)) {
                return this.getRuntime().getFalse();
            }
            if (this.value == b) {
                return this.getRuntime().getTrue();
            }
        }
        return this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    public final int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return this;
    }

    @Override
    @JRubyMethod(name={"abs"})
    public IRubyObject abs(ThreadContext context) {
        if (Double.doubleToLongBits(this.value) < 0L) {
            return RubyFloat.newFloat(context.getRuntime(), Math.abs(this.value));
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"magnitude"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject magnitude(ThreadContext context) {
        return this.abs(context);
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0.0);
    }

    @Override
    @JRubyMethod(name={"truncate", "to_i", "to_int"})
    public IRubyObject truncate() {
        double f = this.value;
        if (f > 0.0) {
            f = Math.floor(f);
        }
        if (f < 0.0) {
            f = Math.ceil(f);
        }
        return RubyFloat.dbl2num(this.getRuntime(), f);
    }

    @Override
    @JRubyMethod(name={"numerator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject numerator(ThreadContext context) {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return this;
        }
        return super.numerator(context);
    }

    @Override
    @JRubyMethod(name={"denominator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject denominator(ThreadContext context) {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return RubyFixnum.one(context.getRuntime());
        }
        return super.denominator(context);
    }

    @JRubyMethod(name={"to_r"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_r(ThreadContext context) {
        long[] exp2 = new long[1];
        double f = Numeric.frexp(this.value, exp2);
        f = Numeric.ldexp(f, 53L);
        long n = exp2[0] - 53L;
        Ruby runtime2 = context.getRuntime();
        IRubyObject rf = RubyNumeric.dbl2num(runtime2, f);
        RubyFixnum rn = RubyFixnum.newFixnum(runtime2, n);
        return Numeric.f_mul(context, rf, Numeric.f_expt(context, RubyFixnum.newFixnum(runtime2, 2L), rn));
    }

    @Override
    @JRubyMethod(name={"floor"})
    public IRubyObject floor() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.floor(this.value));
    }

    @Override
    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.ceil(this.value));
    }

    @Override
    @JRubyMethod(name={"round"})
    public IRubyObject round() {
        double f = this.value;
        if (f > 0.0) {
            f = Math.floor(f + 0.5);
        }
        if (f < 0.0) {
            f = Math.ceil(f - 0.5);
        }
        return RubyFloat.dbl2num(this.getRuntime(), f);
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Double.isNaN(this.value));
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p() {
        if (Double.isInfinite(this.value)) {
            return RubyFixnum.newFixnum(this.getRuntime(), this.value < 0.0 ? -1L : 1L);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    private static String formatDouble(double x) {
        return pattern.matcher(String.format("%.32g", x)).replaceFirst("$1");
    }

    private String marshalDump() {
        if (Double.isInfinite(this.value)) {
            return this.value < 0.0 ? "-inf" : "inf";
        }
        if (Double.isNaN(this.value)) {
            return "nan";
        }
        return RubyFloat.formatDouble(this.value);
    }

    public static void marshalTo(RubyFloat aFloat, MarshalStream output) throws IOException {
        output.registerLinkTarget(aFloat);
        output.writeString(aFloat.marshalDump());
    }

    public static RubyFloat unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyFloat result = RubyFloat.newFloat(input.getRuntime(), Convert.byteListToDouble(input.unmarshalString(), false));
        input.registerLinkTarget(result);
        return result;
    }
}

