/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jna;

import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.io.File;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.BasePointer;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.jna.NativeMemoryIO;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::DynamicLibrary"}, parent="Object")
public class DynamicLibrary
extends RubyObject {
    @JRubyConstant
    public static final int RTLD_LAZY = 1;
    @JRubyConstant
    public static final int RTLD_NOW = 2;
    @JRubyConstant
    public static final int RTLD_LOCAL = 4;
    @JRubyConstant
    public static final int RTLD_GLOBAL = 8;
    private final NativeLibrary library;
    private final String name;

    public static RubyClass createDynamicLibraryClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("DynamicLibrary", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass symClass = result.defineClassUnder("Symbol", module.fastGetClass("BasePointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        symClass.defineAnnotatedMethods(Symbol.class);
        result.defineAnnotatedMethods(DynamicLibrary.class);
        result.defineAnnotatedConstants(DynamicLibrary.class);
        return result;
    }

    public DynamicLibrary(Ruby runtime2, RubyClass klass, String name2, NativeLibrary library2) {
        super(runtime2, klass);
        this.name = name2;
        this.library = library2;
    }

    NativeLibrary getNativeLibrary() {
        return this.library;
    }

    @JRubyMethod(name={"open"}, meta=true)
    public static final IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject libraryName, IRubyObject libraryFlags) {
        String libName;
        String string2 = libName = !libraryName.isNil() ? libraryName.toString() : Platform.LIBC;
        if (libName.indexOf(File.separatorChar) != -1) {
            libName = new File(libName).getAbsolutePath();
        }
        try {
            return new DynamicLibrary(context.getRuntime(), (RubyClass)recv2, libName, NativeLibrary.getInstance(libName));
        }
        catch (UnsatisfiedLinkError ex) {
            throw context.getRuntime().newLoadError(ex.getMessage());
        }
    }

    @JRubyMethod(name={"find_function"})
    public IRubyObject findFunction(ThreadContext context, IRubyObject symbolName) {
        String sym = symbolName.toString();
        try {
            return new Symbol(context.getRuntime(), this, sym, this.library.getFunction(sym));
        }
        catch (UnsatisfiedLinkError ex) {
            return context.getRuntime().getNil();
        }
    }

    @JRubyMethod(name={"find_symbol", "find_variable"})
    public IRubyObject findVariable(ThreadContext context, IRubyObject symbolName) {
        String sym = symbolName.toString();
        try {
            return new Symbol(context.getRuntime(), this, sym, this.library.getGlobalVariableAddress(sym));
        }
        catch (UnsatisfiedLinkError ex) {
            return context.getRuntime().getNil();
        }
    }

    @JRubyMethod(name={"name"})
    public IRubyObject name(ThreadContext context) {
        return RubyString.newString(context.getRuntime(), this.name);
    }

    static final class Symbol
    extends BasePointer {
        private final DynamicLibrary library;
        private final Pointer address;
        private final String name;

        public Symbol(Ruby runtime2, DynamicLibrary library2, String name2, Pointer address2) {
            super(runtime2, runtime2.fastGetModule("FFI").fastGetClass("DynamicLibrary").fastGetClass("Symbol"), new NativeMemoryIO(address2), Long.MAX_VALUE);
            this.library = library2;
            this.address = address2;
            this.name = name2;
        }

        NativeLibrary getNativeLibrary() {
            return this.library.getNativeLibrary();
        }

        Pointer getNativeAddress() {
            return this.address;
        }

        @JRubyMethod(name={"library"})
        public IRubyObject library(ThreadContext context) {
            return this.library;
        }

        @JRubyMethod(name={"inspect"})
        public IRubyObject inspect(ThreadContext context) {
            return RubyString.newString(context.getRuntime(), String.format("#<Library Symbol library=%s symbol=%s address=%#x>", this.library.name, this.name, this.getAddress()));
        }

        public final String toString() {
            return this.name;
        }

        final String getName() {
            return this.name;
        }
    }
}

