/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Platform;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.jffi.AllocatedNativeMemoryIO;
import org.jruby.ext.ffi.jffi.CallbackManager;
import org.jruby.ext.ffi.jffi.DynamicLibrary;
import org.jruby.ext.ffi.jffi.JFFIInvoker;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.ext.ffi.jffi.VariadicInvoker;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factory
extends org.jruby.ext.ffi.Factory {
    public Factory() {
        if (!Platform.getPlatform().isSupported()) {
            throw new UnsatisfiedLinkError("JFFI backend not available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Ruby runtime2, RubyModule ffi2) {
        super.init(runtime2, ffi2);
        RubyModule rubyModule = ffi2;
        synchronized (rubyModule) {
            if (ffi2.fastGetClass("DynamicLibrary") == null) {
                DynamicLibrary.createDynamicLibraryClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Invoker") == null) {
                JFFIInvoker.createInvokerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("VariadicInvoker") == null) {
                VariadicInvoker.createVariadicInvokerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Callback") == null) {
                CallbackManager.createCallbackClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("LastError") == null) {
                ffi2.defineModuleUnder("LastError").defineAnnotatedMethods(LastError.class);
            }
        }
    }

    @Override
    public <T> T loadLibrary(String libraryName, Class<T> libraryClass) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AllocatedDirectMemoryIO allocateDirectMemory(Ruby runtime2, int size2, boolean clear2) {
        return AllocatedNativeMemoryIO.allocate(runtime2, size2, clear2);
    }

    @Override
    public DirectMemoryIO wrapDirectMemory(long address2) {
        return address2 != 0L ? new NativeMemoryIO(address2) : null;
    }

    @Override
    public CallbackManager getCallbackManager() {
        return CallbackManager.getInstance();
    }

    private static final class LastError {
        private LastError() {
        }

        @JRubyMethod(name={"error"}, meta=true)
        public static final IRubyObject error(ThreadContext context, IRubyObject recv2) {
            return context.getRuntime().newFixnum(com.kenai.jffi.LastError.getInstance().getError());
        }
    }
}

