/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Platform;
import com.kenai.jffi.Struct;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.Enum;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FFIUtil {
    private static final Map<NativeType, com.kenai.jffi.Type> typeMap = FFIUtil.buildTypeMap();

    private FFIUtil() {
    }

    private static final Map<NativeType, com.kenai.jffi.Type> buildTypeMap() {
        EnumMap<NativeType, com.kenai.jffi.Type> m = new EnumMap<NativeType, com.kenai.jffi.Type>(NativeType.class);
        m.put(NativeType.VOID, com.kenai.jffi.Type.VOID);
        m.put(NativeType.INT8, com.kenai.jffi.Type.SINT8);
        m.put(NativeType.INT16, com.kenai.jffi.Type.SINT16);
        m.put(NativeType.INT32, com.kenai.jffi.Type.SINT32);
        m.put(NativeType.INT64, com.kenai.jffi.Type.SINT64);
        m.put(NativeType.UINT8, com.kenai.jffi.Type.UINT8);
        m.put(NativeType.UINT16, com.kenai.jffi.Type.UINT16);
        m.put(NativeType.UINT32, com.kenai.jffi.Type.UINT32);
        m.put(NativeType.UINT64, com.kenai.jffi.Type.UINT64);
        if (Platform.getPlatform().longSize() == 32) {
            m.put(NativeType.LONG, com.kenai.jffi.Type.SINT32);
            m.put(NativeType.ULONG, com.kenai.jffi.Type.UINT32);
        } else {
            m.put(NativeType.LONG, com.kenai.jffi.Type.SINT64);
            m.put(NativeType.ULONG, com.kenai.jffi.Type.UINT64);
        }
        m.put(NativeType.FLOAT32, com.kenai.jffi.Type.FLOAT);
        m.put(NativeType.FLOAT64, com.kenai.jffi.Type.DOUBLE);
        m.put(NativeType.POINTER, com.kenai.jffi.Type.POINTER);
        m.put(NativeType.BUFFER_IN, com.kenai.jffi.Type.POINTER);
        m.put(NativeType.BUFFER_OUT, com.kenai.jffi.Type.POINTER);
        m.put(NativeType.BUFFER_INOUT, com.kenai.jffi.Type.POINTER);
        m.put(NativeType.STRING, com.kenai.jffi.Type.POINTER);
        return m;
    }

    static final com.kenai.jffi.Type getFFIType(Type type2) {
        if (type2 instanceof Type.Builtin || type2 instanceof CallbackInfo || type2 instanceof Enum) {
            return FFIUtil.getFFIType(type2.getNativeType());
        }
        if (type2 instanceof StructByValue) {
            return FFIUtil.newStruct(((StructByValue)type2).getStructLayout());
        }
        return null;
    }

    static final com.kenai.jffi.Type getFFIType(NativeType type2) {
        return typeMap.get(type2);
    }

    static final Struct newStruct(Ruby runtime2, Collection<StructLayout.Member> structMembers) {
        com.kenai.jffi.Type[] fields2 = new com.kenai.jffi.Type[structMembers.size()];
        int i = 0;
        for (StructLayout.Member m : structMembers) {
            com.kenai.jffi.Type fieldType = m instanceof StructLayout.Aggregate ? FFIUtil.newStruct(runtime2, ((StructLayout.Aggregate)((Object)m)).getMembers()) : FFIUtil.getFFIType(m.getNativeType());
            if (fieldType == null) {
                throw runtime2.newTypeError("Unsupported Struct field type " + m);
            }
            fields2[i++] = fieldType;
        }
        return new Struct(fields2);
    }

    static final Struct newStruct(StructLayout layout) {
        return FFIUtil.newStruct(layout.getRuntime(), layout.getFields());
    }
}

