/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jruby.RubyIO;
import org.jruby.ext.posix.POSIX;
import org.jruby.util.ByteList;
import org.jruby.util.JRubyFile;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.NullChannel;
import org.jruby.util.io.PipeException;

public class ChannelDescriptor {
    private static final boolean DEBUG = false;
    private Channel channel;
    private int fileno;
    private FileDescriptor fileDescriptor;
    private ModeFlags originalModes;
    private AtomicInteger refCounter;
    private InputStream baseInputStream;
    private boolean canBeSeekable = true;

    private ChannelDescriptor(Channel channel, int fileno2, ModeFlags originalModes, FileDescriptor fileDescriptor, AtomicInteger refCounter, boolean canBeSeekable) {
        this.refCounter = refCounter;
        this.channel = channel;
        this.fileno = fileno2;
        this.originalModes = originalModes;
        this.fileDescriptor = fileDescriptor;
        this.canBeSeekable = canBeSeekable;
    }

    public ChannelDescriptor(Channel channel, int fileno2, ModeFlags originalModes, FileDescriptor fileDescriptor) {
        this(channel, fileno2, originalModes, fileDescriptor, new AtomicInteger(1), true);
    }

    public ChannelDescriptor(InputStream baseInputStream, int fileno2, ModeFlags originalModes, FileDescriptor fileDescriptor) {
        this(Channels.newChannel(baseInputStream), fileno2, originalModes, fileDescriptor, new AtomicInteger(1), true);
        this.baseInputStream = baseInputStream;
    }

    public ChannelDescriptor(Channel channel, int fileno2, FileDescriptor fileDescriptor) throws InvalidValueException {
        this(channel, fileno2, ChannelDescriptor.getModesFromChannel(channel), fileDescriptor);
    }

    public int getFileno() {
        return this.fileno;
    }

    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public Channel getChannel() {
        return this.channel;
    }

    InputStream getBaseInputStream() {
        return this.baseInputStream;
    }

    public boolean isSeekable() {
        return this.canBeSeekable && this.channel instanceof FileChannel;
    }

    public void setCanBeSeekable(boolean canBeSeekable) {
        this.canBeSeekable = canBeSeekable;
    }

    public boolean isNull() {
        return this.channel instanceof NullChannel;
    }

    public boolean isWritable() {
        return this.channel instanceof WritableByteChannel;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void checkOpen() throws BadDescriptorException {
        if (!this.isOpen()) {
            throw new BadDescriptorException();
        }
    }

    public ModeFlags getOriginalModes() {
        return this.originalModes;
    }

    public void checkNewModes(ModeFlags newModes) throws InvalidValueException {
        if (!newModes.isSubsetOf(this.originalModes)) {
            throw new InvalidValueException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelDescriptor dup() {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            int newFileno = RubyIO.getNewFileno();
            return new ChannelDescriptor(this.channel, newFileno, this.originalModes, this.fileDescriptor, this.refCounter, this.canBeSeekable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelDescriptor dup2(int fileno2) {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            return new ChannelDescriptor(this.channel, fileno2, this.originalModes, this.fileDescriptor, this.refCounter, this.canBeSeekable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dup2Into(ChannelDescriptor other) throws BadDescriptorException, IOException {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            other.close();
            other.channel = this.channel;
            other.originalModes = this.originalModes;
            other.fileDescriptor = this.fileDescriptor;
            other.refCounter = this.refCounter;
            other.canBeSeekable = this.canBeSeekable;
        }
    }

    public long lseek(long offset2, int whence) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        if (this.channel instanceof FileChannel) {
            this.checkOpen();
            FileChannel fileChannel = (FileChannel)this.channel;
            try {
                long pos2;
                switch (whence) {
                    case 0: {
                        pos2 = offset2;
                        fileChannel.position(pos2);
                        break;
                    }
                    case 1: {
                        pos2 = fileChannel.position() + offset2;
                        fileChannel.position(pos2);
                        break;
                    }
                    case 2: {
                        pos2 = fileChannel.size() + offset2;
                        fileChannel.position(pos2);
                        break;
                    }
                    default: {
                        throw new InvalidValueException();
                    }
                }
                return pos2;
            }
            catch (IllegalArgumentException e) {
                throw new InvalidValueException();
            }
        }
        throw new PipeException();
    }

    public int read(int number, ByteList byteList) throws IOException, BadDescriptorException {
        this.checkOpen();
        byteList.ensure(byteList.length() + number);
        int bytesRead = this.read(ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin() + byteList.length(), number));
        if (bytesRead > 0) {
            byteList.length(byteList.length() + bytesRead);
        }
        return bytesRead;
    }

    public int read(ByteBuffer buffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        if (!(this.channel instanceof ReadableByteChannel)) {
            throw new BadDescriptorException();
        }
        ReadableByteChannel readChannel = (ReadableByteChannel)this.channel;
        int bytesRead = 0;
        bytesRead = readChannel.read(buffer);
        return bytesRead;
    }

    public int internalWrite(ByteBuffer buffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        if (!(this.channel instanceof WritableByteChannel)) {
            throw new BadDescriptorException();
        }
        WritableByteChannel writeChannel = (WritableByteChannel)this.channel;
        if (this.isSeekable() && this.originalModes.isAppendable()) {
            FileChannel fileChannel = (FileChannel)this.channel;
            fileChannel.position(fileChannel.size());
        }
        return writeChannel.write(buffer);
    }

    public int write(ByteBuffer buffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(buffer);
    }

    public int write(ByteList buf) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(ByteBuffer.wrap(buf.unsafeBytes(), buf.begin(), buf.length()));
    }

    public int write(ByteList buf, int offset2, int len) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(ByteBuffer.wrap(buf.unsafeBytes(), buf.begin() + offset2, len));
    }

    public int write(int c) throws IOException, BadDescriptorException {
        this.checkOpen();
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put((byte)c);
        buf.flip();
        return this.internalWrite(buf);
    }

    public static ChannelDescriptor open(String cwd, String path2, ModeFlags flags) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        return ChannelDescriptor.open(cwd, path2, flags, 0, null);
    }

    public static ChannelDescriptor open(String cwd, String path2, ModeFlags flags, int perm, POSIX posix) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        boolean fileCreated = false;
        if (path2.equals("/dev/null") || path2.equalsIgnoreCase("nul:") || path2.equalsIgnoreCase("nul")) {
            NullChannel nullChannel = new NullChannel();
            return new ChannelDescriptor(nullChannel, RubyIO.getNewFileno(), flags, new FileDescriptor());
        }
        if (path2.startsWith("file:")) {
            String filePath = path2.substring(5, path2.indexOf("!"));
            String internalPath = path2.substring(path2.indexOf("!") + 2);
            if (!new File(filePath).exists()) {
                throw new FileNotFoundException(path2);
            }
            JarFile jf = new JarFile(filePath);
            ZipEntry zf = jf.getEntry(internalPath);
            if (zf == null) {
                throw new FileNotFoundException(path2);
            }
            InputStream is = jf.getInputStream(zf);
            return new ChannelDescriptor(Channels.newChannel(is), RubyIO.getNewFileno(), flags, new FileDescriptor());
        }
        JRubyFile theFile = JRubyFile.create(cwd, path2);
        if (theFile.isDirectory() && flags.isWritable()) {
            throw new DirectoryAsFileException();
        }
        if (flags.isCreate()) {
            if (theFile.exists() && flags.isExclusive()) {
                throw new FileExistsException(path2);
            }
            fileCreated = theFile.createNewFile();
        } else if (!theFile.exists()) {
            throw new FileNotFoundException(path2);
        }
        RandomAccessFile file2 = new RandomAccessFile(theFile, flags.toJavaModeString());
        if (fileCreated && posix != null && perm != -1) {
            posix.chmod(theFile.getPath(), perm);
        }
        if (flags.isTruncate()) {
            file2.setLength(0L);
        }
        return new ChannelDescriptor(file2.getChannel(), RubyIO.getNewFileno(), flags, file2.getFD());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws BadDescriptorException, IOException {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            if (this.refCounter.get() <= 0) {
                throw new BadDescriptorException();
            }
            if (!this.channel.isOpen()) {
                throw new BadDescriptorException();
            }
            int count2 = this.refCounter.decrementAndGet();
            if (count2 <= 0) {
                this.channel.close();
            }
        }
    }

    private static ModeFlags getModesFromChannel(Channel channel) throws InvalidValueException {
        ModeFlags modes = channel instanceof ReadableByteChannel ? (channel instanceof WritableByteChannel ? new ModeFlags(2L) : new ModeFlags(0L)) : (channel instanceof WritableByteChannel ? new ModeFlags(1L) : new ModeFlags(2L));
        return modes;
    }
}

