/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import org.jruby.Ruby;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;

public class ExternalScript
implements Library {
    private final LoadServiceResource resource;

    public ExternalScript(LoadServiceResource resource2, String name2) {
        this.resource = resource2;
    }

    public void load(Ruby runtime2, boolean wrap2) {
        try {
            BufferedInputStream in = new BufferedInputStream(this.resource.getURL().openStream(), 8192);
            String name2 = this.resource.getName();
            try {
                name2 = URLDecoder.decode(name2, "ISO-8859-1");
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (runtime2.getInstanceConfig().getCompileMode().shouldPrecompileAll()) {
                runtime2.compileAndLoadFile(name2, in, wrap2);
            } else {
                runtime2.loadFile(name2, in, wrap2);
            }
            ((InputStream)in).close();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }
}

