/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.NormalCachingCallSite;

public class RespondToCallSite
extends NormalCachingCallSite {
    private volatile String lastString;
    private volatile CacheEntry respondEntry = CacheEntry.NULL_CACHE;
    private volatile IRubyObject respondsTo;

    public RespondToCallSite() {
        super("respond_to?");
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject name2) {
        RubyClass klass = self.getMetaClass();
        if (this.isDefaultRespondTo(klass, context)) {
            String newString = name2.asJavaString();
            if (this.isCacheInvalid(newString, klass)) {
                this.recacheRespondsTo(newString, klass, true, context);
            }
            return this.respondsTo;
        }
        return super.call(context, caller2, self, name2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject name2, IRubyObject bool) {
        RubyClass klass = self.getMetaClass();
        if (this.isDefaultRespondTo(klass, context)) {
            String newString = name2.asJavaString();
            if (this.isCacheInvalid(newString, klass)) {
                this.recacheRespondsTo(newString, klass, !bool.isTrue(), context);
            }
            return this.respondsTo;
        }
        return super.call(context, caller2, self, name2, bool);
    }

    private synchronized boolean isCacheInvalid(String newString, RubyClass klass) {
        return this.lastString != newString || !this.respondEntry.typeOk(klass);
    }

    private boolean isDefaultRespondTo(RubyClass klass, ThreadContext context) {
        return this.cache.typeOk(klass) && this.cache.method == context.getRuntime().getRespondToMethod();
    }

    private synchronized void recacheRespondsTo(String newString, RubyClass klass, boolean checkVisibility, ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        this.lastString = newString;
        this.respondEntry = klass.searchWithCache(newString);
        this.respondsTo = !this.respondEntry.method.isUndefined() ? RespondToCallSite.checkVisibilityAndCache(this.respondEntry, checkVisibility, runtime2) : runtime2.getFalse();
    }

    private static IRubyObject checkVisibilityAndCache(CacheEntry respondEntry, boolean checkVisibility, Ruby runtime2) {
        if (!checkVisibility || respondEntry.method.getVisibility() != Visibility.PRIVATE) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }
}

