/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.ScanEnvironment;
import org.joni.ast.StateNode;
import org.joni.exception.ValueException;

public final class BackRefNode
extends StateNode {
    public int backNum;
    public int[] back;
    public int nestLevel;

    public BackRefNode(int backNum, int[] backRefs, boolean byName, ScanEnvironment env) {
        this.backNum = backNum;
        if (byName) {
            this.setNameRef();
        }
        for (int i = 0; i < backNum; ++i) {
            if (backRefs[i] > env.numMem || env.memNodes[backRefs[i]] != null) continue;
            this.setRecursion();
            break;
        }
        this.back = new int[backNum];
        System.arraycopy(backRefs, 0, this.back, 0, backNum);
    }

    public BackRefNode(int backNum, int[] backRefs, boolean byName, boolean existLevel, int nestLevel, ScanEnvironment env) {
        this(backNum, backRefs, byName, env);
        if (existLevel) {
            this.setNestLevel();
            this.nestLevel = nestLevel;
        }
    }

    public int getType() {
        return 4;
    }

    public String getName() {
        return "Back Ref";
    }

    public String toString(int level2) {
        StringBuilder value2 = new StringBuilder(super.toString(level2));
        value2.append("\n  backNum: " + this.backNum);
        String backs = "";
        for (int i = 0; i < this.back.length; ++i) {
            backs = backs + this.back[i] + ", ";
        }
        value2.append("\n  back: " + backs);
        value2.append("\n  nextLevel: " + this.nestLevel);
        return value2.toString();
    }

    public void renumber(int[] map) {
        if (!this.isNameRef()) {
            throw new ValueException("numbered backref/call is not allowed. (use name)");
        }
        int oldNum = this.backNum;
        int pos2 = 0;
        for (int i = 0; i < oldNum; ++i) {
            int n = map[this.back[i]];
            if (n <= 0) continue;
            this.back[pos2] = n;
            ++pos2;
        }
        this.backNum = pos2;
    }
}

