/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.util.ByteList;
import org.jvyamlb.Composer;
import org.jvyamlb.ComposerException;
import org.jvyamlb.Parser;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.Resolver;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.events.AliasEvent;
import org.jvyamlb.events.Event;
import org.jvyamlb.events.MappingEndEvent;
import org.jvyamlb.events.MappingStartEvent;
import org.jvyamlb.events.NodeEvent;
import org.jvyamlb.events.ScalarEvent;
import org.jvyamlb.events.SequenceEndEvent;
import org.jvyamlb.events.SequenceStartEvent;
import org.jvyamlb.events.StreamEndEvent;
import org.jvyamlb.events.StreamStartEvent;
import org.jvyamlb.nodes.MappingNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;
import org.jvyamlb.nodes.SequenceNode;

public class ComposerImpl
implements Composer {
    private Parser parser;
    private Resolver resolver;
    private Map anchors;
    private static final boolean[] FALS = new boolean[]{false};
    private static final boolean[] TRU = new boolean[]{true};

    public ComposerImpl(Parser parser, Resolver resolver) {
        this.parser = parser;
        this.resolver = resolver;
        this.anchors = new HashMap();
    }

    @Override
    public boolean checkNode() {
        return !(this.parser.peekEvent() instanceof StreamEndEvent);
    }

    @Override
    public Node getNode() {
        return this.checkNode() ? this.composeDocument() : (Node)null;
    }

    @Override
    public Iterator eachNode() {
        return new NodeIterator();
    }

    @Override
    public Iterator iterator() {
        return this.eachNode();
    }

    public Node composeDocument() {
        if (this.parser.peekEvent() instanceof StreamStartEvent) {
            this.parser.getEvent();
        }
        this.parser.getEvent();
        Node node = this.composeNode(null, null);
        this.parser.getEvent();
        this.anchors.clear();
        return node;
    }

    public Node composeNode(Node parent, Object index) {
        if (this.parser.peekEvent() instanceof AliasEvent) {
            AliasEvent event = (AliasEvent)this.parser.getEvent();
            String anchor = event.getAnchor();
            if (!this.anchors.containsKey(anchor)) {
                throw new ComposerException(null, "found undefined alias " + anchor, null);
            }
            return (Node)this.anchors.get(anchor);
        }
        Event event = this.parser.peekEvent();
        String anchor = null;
        if (event instanceof NodeEvent) {
            anchor = ((NodeEvent)event).getAnchor();
        }
        this.resolver.descendResolver(parent, index);
        Node node = null;
        if (event instanceof ScalarEvent) {
            ScalarEvent ev = (ScalarEvent)this.parser.getEvent();
            String tag = ev.getTag();
            if (tag == null || tag.equals("!")) {
                tag = this.resolver.resolve(ScalarNode.class, ev.getValue(), ev.getImplicit());
            }
            node = new ScalarNode(tag, ev.getValue(), ev.getStyle());
            if (null != anchor) {
                this.anchors.put(anchor, node);
            }
        } else if (event instanceof SequenceStartEvent) {
            SequenceStartEvent start = (SequenceStartEvent)this.parser.getEvent();
            String tag = start.getTag();
            if (tag == null || tag.equals("!")) {
                tag = this.resolver.resolve(SequenceNode.class, null, start.getImplicit() ? TRU : FALS);
            }
            node = new SequenceNode(tag, new ArrayList(), start.getFlowStyle());
            if (null != anchor) {
                this.anchors.put(anchor, node);
            }
            int ix = 0;
            while (!(this.parser.peekEvent() instanceof SequenceEndEvent)) {
                ((List)node.getValue()).add(this.composeNode(node, new Integer(ix++)));
            }
            this.parser.getEvent();
        } else if (event instanceof MappingStartEvent) {
            MappingStartEvent start = (MappingStartEvent)this.parser.getEvent();
            String tag = start.getTag();
            if (tag == null || tag.equals("!")) {
                tag = this.resolver.resolve(MappingNode.class, null, start.getImplicit() ? TRU : FALS);
            }
            node = new MappingNode(tag, new HashMap(), start.getFlowStyle());
            if (null != anchor) {
                this.anchors.put(anchor, node);
            }
            while (!(this.parser.peekEvent() instanceof MappingEndEvent)) {
                Event key = this.parser.peekEvent();
                Node itemKey = this.composeNode(node, null);
                if (((Map)node.getValue()).containsKey(itemKey)) {
                    this.composeNode(node, itemKey);
                    continue;
                }
                ((Map)node.getValue()).put(itemKey, this.composeNode(node, itemKey));
            }
            this.parser.getEvent();
        }
        this.resolver.ascendResolver();
        return node;
    }

    public static void main(String[] args) throws Exception {
        String filename = args[0];
        System.out.println("Reading of file: \"" + filename + "\"");
        ByteList input = new ByteList(1024);
        FileInputStream reader = new FileInputStream(filename);
        byte[] buff = new byte[1024];
        int read = 0;
        do {
            read = ((InputStream)reader).read(buff);
            input.append(buff, 0, read);
        } while (read >= 1024);
        ((InputStream)reader).close();
        long before = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            ComposerImpl cmp = new ComposerImpl(new ParserImpl(new ScannerImpl(input)), new ResolverImpl());
            Iterator iter = cmp.eachNode();
            while (iter.hasNext()) {
                iter.next();
            }
        }
        long l = System.currentTimeMillis();
        long l2 = l - before;
        double d = (double)(l - before) / 1000.0;
        System.out.println("Walking through the nodes for the file: " + filename + " took " + l2 + "ms, or " + d + " seconds");
    }

    private class NodeIterator
    implements Iterator {
        private NodeIterator() {
        }

        @Override
        public boolean hasNext() {
            return ComposerImpl.this.checkNode();
        }

        public Object next() {
            return ComposerImpl.this.getNode();
        }

        @Override
        public void remove() {
        }
    }
}

