/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.util.ByteList;
import org.jruby.util.IOHandler;
import org.jruby.util.IOHandlerJavaIO;
import org.jruby.util.IOModes;

public class IOHandlerProcess
extends IOHandlerJavaIO {
    protected InputStream input = null;
    protected OutputStream output = null;
    protected Process process = null;

    public IOHandlerProcess(Ruby runtime, Process process, IOModes modes) throws IOException {
        super(runtime);
        if (process == null) {
            throw new IOException("Null process");
        }
        this.process = process;
        this.input = process.getInputStream();
        this.output = process.getOutputStream();
        this.isOpen = true;
        this.modes = modes;
        this.isSync = true;
        this.fileno = RubyIO.getNewFileno();
    }

    @Override
    public IOHandler cloneIOHandler() throws IOException {
        return new IOHandlerProcess(this.getRuntime(), this.process, this.modes);
    }

    @Override
    public void close() throws IOException, IOHandler.BadDescriptorException {
        if (!this.isOpen()) {
            throw new IOHandler.BadDescriptorException();
        }
        this.isOpen = false;
        this.input.close();
        this.output.close();
        this.process.destroy();
        this.process = null;
    }

    @Override
    public void flush() throws IOException, IOHandler.BadDescriptorException {
        this.checkWritable();
        this.output.flush();
    }

    @Override
    public InputStream getInputStream() {
        return this.input;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.output;
    }

    @Override
    public boolean isEOF() throws IOException, IOHandler.BadDescriptorException {
        this.checkReadable();
        int c = this.input.read();
        if (c == -1) {
            return true;
        }
        this.ungetc(c);
        return false;
    }

    @Override
    public int pid() {
        return this.process.hashCode();
    }

    @Override
    public long pos() throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    @Override
    public void resetByModes(IOModes newModes) {
    }

    @Override
    public void rewind() throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    @Override
    public void seek(long offset, int type) throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    @Override
    public void sync() throws IOException {
        this.output.flush();
    }

    @Override
    public int sysread() throws IOException {
        return this.input.read();
    }

    @Override
    public ByteList sysread(int number) throws IOException, IOHandler.BadDescriptorException {
        int read;
        int n;
        this.checkReadable();
        byte[] buf = new byte[number];
        for (read = 0; read < number; read += n) {
            n = this.input.read(buf, read, number - read);
            if (n != -1) continue;
            if (read != 0) break;
            throw new EOFException();
        }
        return new ByteList(buf, 0, read, false);
    }

    @Override
    public int syswrite(ByteList buf) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWritable();
        if (buf == null || buf.realSize == 0) {
            return 0;
        }
        this.output.write(buf.bytes, buf.begin, buf.realSize);
        if (this.isSync) {
            this.sync();
        }
        return buf.realSize;
    }

    @Override
    public int syswrite(int c) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWritable();
        this.output.write(c);
        if (this.isSync) {
            this.sync();
        }
        return 1;
    }

    @Override
    public void truncate(long newLength) throws IOException, IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    @Override
    public FileChannel getFileChannel() {
        assert (false) : "No file channel for process streams";
        return null;
    }
}

