/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.runtime.CallAdapter;
import org.jruby.runtime.CallType;

public class MethodIndex {
    public static final List<String> NAMES = new ArrayList<String>();
    private static final Map<String, Integer> NUMBERS = new HashMap<String, Integer>();
    private static final Map<Integer, CallAdapter> CALL_ADAPTERS = new HashMap<Integer, CallAdapter>();
    private static final Map<Integer, CallAdapter> FUNCTION_ADAPTERS = new HashMap<Integer, CallAdapter>();
    private static final Map<Integer, CallAdapter> VARIABLE_ADAPTERS = new HashMap<Integer, CallAdapter>();
    public static final int NO_INDEX = MethodIndex.getIndex("");
    public static final int OP_PLUS = MethodIndex.getIndex("+");
    public static final int OP_MINUS = MethodIndex.getIndex("-");
    public static final int OP_LT = MethodIndex.getIndex("<");
    public static final int AREF = MethodIndex.getIndex("[]");
    public static final int ASET = MethodIndex.getIndex("[]=");
    public static final int EQUALEQUAL = MethodIndex.getIndex("==");
    public static final int OP_LSHIFT = MethodIndex.getIndex("<<");
    public static final int EMPTY_P = MethodIndex.getIndex("empty?");
    public static final int TO_S = MethodIndex.getIndex("to_s");
    public static final int TO_I = MethodIndex.getIndex("to_i");
    public static final int TO_STR = MethodIndex.getIndex("to_str");
    public static final int TO_ARY = MethodIndex.getIndex("to_ary");
    public static final int TO_INT = MethodIndex.getIndex("to_int");
    public static final int TO_F = MethodIndex.getIndex("to_f");
    public static final int TO_A = MethodIndex.getIndex("to_a");
    public static final int HASH = MethodIndex.getIndex("hash");
    public static final int OP_GT = MethodIndex.getIndex(">");
    public static final int OP_TIMES = MethodIndex.getIndex("*");
    public static final int OP_LE = MethodIndex.getIndex("<=");
    public static final int OP_SPACESHIP = MethodIndex.getIndex("<=>");
    public static final int OP_EQQ = MethodIndex.getIndex("===");
    public static final int EQL_P = MethodIndex.getIndex("eql?");
    public static final int TO_HASH = MethodIndex.getIndex("to_hash");
    public static final int METHOD_MISSING = MethodIndex.getIndex("method_missing");
    public static final int DEFAULT = MethodIndex.getIndex("default");

    public static synchronized int getIndex(String methodName) {
        Integer index = NUMBERS.get(methodName);
        if (index == null) {
            index = new Integer(NAMES.size());
            NUMBERS.put(methodName, index);
            NAMES.add(methodName);
        }
        return index;
    }

    public static synchronized CallAdapter getCallAdapter(String name) {
        return new CallAdapter.DefaultCallAdapter(name, CallType.NORMAL);
    }

    public static synchronized CallAdapter getFunctionAdapter(String name) {
        return new CallAdapter.DefaultCallAdapter(name, CallType.FUNCTIONAL);
    }

    public static synchronized CallAdapter getVariableAdapter(String name) {
        return new CallAdapter.DefaultCallAdapter(name, CallType.VARIABLE);
    }
}

