/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.Serializable;
import org.jruby.RubyModule;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.DynamicScope;

public abstract class StaticScope
implements Serializable {
    private static final long serialVersionUID = 4843861446986961013L;
    protected final StaticScope enclosingScope;
    private transient RubyModule cref = null;
    private StaticScope previousCRefScope = null;
    private String[] variableNames;
    private int requiredArgs = 0;
    private int optionalArgs = 0;
    private int restArg = -1;
    private boolean isArgumentScope = false;

    protected StaticScope(StaticScope enclosingScope) {
        this.enclosingScope = enclosingScope;
    }

    protected StaticScope(StaticScope enclosingScope, String[] names) {
        this.enclosingScope = enclosingScope;
        this.variableNames = names;
    }

    public int addVariable(String name) {
        int slot = this.isDefined(name);
        if (slot >= 0) {
            return slot;
        }
        if (this.variableNames == null) {
            this.variableNames = new String[1];
            this.variableNames[0] = name;
        } else {
            String[] newVariableNames = new String[this.variableNames.length + 1];
            System.arraycopy(this.variableNames, 0, newVariableNames, 0, this.variableNames.length);
            this.variableNames = newVariableNames;
            this.variableNames[this.variableNames.length - 1] = name;
        }
        return this.variableNames.length - 1;
    }

    public String[] getVariables() {
        return this.variableNames;
    }

    public int getNumberOfVariables() {
        return this.variableNames == null ? 0 : this.variableNames.length;
    }

    public void setVariables(String[] names) {
        if (names == null) {
            return;
        }
        this.variableNames = new String[names.length];
        System.arraycopy(names, 0, this.variableNames, 0, names.length);
    }

    public StaticScope getEnclosingScope() {
        return this.enclosingScope;
    }

    public int exists(String name) {
        if (this.variableNames != null) {
            for (int i = 0; i < this.variableNames.length; ++i) {
                if (name != this.variableNames[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public int isDefined(String name) {
        return this.isDefined(name, 0);
    }

    public AssignableNode assign(ISourcePosition position, String name, Node value) {
        return this.assign(position, name, value, this, 0);
    }

    public abstract String[] getAllNamesInScope(DynamicScope var1);

    protected abstract int isDefined(String var1, int var2);

    protected abstract AssignableNode assign(ISourcePosition var1, String var2, Node var3, StaticScope var4, int var5);

    protected abstract Node declare(ISourcePosition var1, String var2, int var3);

    public Node declare(ISourcePosition position, String name) {
        return this.declare(position, name, 0);
    }

    public abstract StaticScope getLocalScope();

    public RubyModule getModule() {
        return this.cref;
    }

    public StaticScope getPreviousCRefScope() {
        return this.previousCRefScope;
    }

    public void setModule(RubyModule module) {
        this.cref = module;
        if (this.previousCRefScope == null) {
            for (StaticScope scope = this.getEnclosingScope(); scope != null; scope = scope.getEnclosingScope()) {
                if (scope.cref == null) continue;
                this.previousCRefScope = scope;
                return;
            }
        }
    }

    public RubyModule determineModule() {
        if (this.cref == null) {
            this.cref = this.getEnclosingScope().determineModule();
            assert (this.cref != null) : "CRef is always created before determine happens";
            this.previousCRefScope = this.getEnclosingScope().previousCRefScope;
        }
        return this.cref;
    }

    public int getOptionalArgs() {
        return this.optionalArgs;
    }

    public void setOptionalArgs(int optionalArgs) {
        this.optionalArgs = optionalArgs;
    }

    public int getRequiredArgs() {
        return this.requiredArgs;
    }

    public void setRequiredArgs(int requiredArgs) {
        this.requiredArgs = requiredArgs;
    }

    public int getRestArg() {
        return this.restArg;
    }

    public void setRestArg(int restArg) {
        this.restArg = restArg;
    }

    public boolean isArgumentScope() {
        return this.isArgumentScope;
    }

    public void setArgumentScope(boolean isArgumentScope) {
        this.isArgumentScope = isArgumentScope;
    }

    public Arity getArity() {
        if (this.optionalArgs > 0) {
            if (this.restArg >= 0) {
                return Arity.optional();
            }
            return Arity.required(this.requiredArgs);
        }
        if (this.restArg >= 0) {
            return Arity.optional();
        }
        return Arity.fixed(this.requiredArgs);
    }

    public void setArities(int required, int optional, int rest) {
        this.requiredArgs = required;
        this.optionalArgs = optional;
        this.restArg = rest;
    }
}

