/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaProxyReflectionObject
extends RubyObject {
    public JavaProxyReflectionObject(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass, false);
    }

    protected static void registerRubyMethods(Ruby runtime, RubyClass result) {
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaProxyReflectionObject.class);
        result.defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        result.defineFastMethod("==", callbackFactory.getFastMethod("op_equal", IRubyObject.class));
        result.defineFastMethod("eql?", callbackFactory.getFastMethod("op_equal", IRubyObject.class));
        result.defineFastMethod("equal?", callbackFactory.getFastMethod("same", IRubyObject.class));
        result.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        result.defineFastMethod("java_type", callbackFactory.getFastMethod("java_type"));
        result.defineFastMethod("java_class", callbackFactory.getFastMethod("java_class"));
        result.defineFastMethod("java_proxy?", callbackFactory.getFastMethod("is_java_proxy"));
        result.defineFastMethod("length", callbackFactory.getFastMethod("length"));
        result.defineFastMethod("[]", callbackFactory.getFastMethod("aref", IRubyObject.class));
        result.defineFastMethod("[]=", callbackFactory.getFastMethod("aset", IRubyObject.class, IRubyObject.class));
        result.getMetaClass().defineAlias("__j_allocate", "allocate");
    }

    @Override
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    public IRubyObject to_s() {
        return this.getRuntime().newString(this.toString());
    }

    @Override
    public IRubyObject op_equal(IRubyObject other) {
        if (!(other instanceof JavaProxyReflectionObject) && !((other = other.fastGetInstanceVariable("@java_object")) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        boolean isEqual = this.equals(other);
        return isEqual ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    public IRubyObject same(IRubyObject other) {
        if (!(other instanceof JavaObject) && !((other = other.fastGetInstanceVariable("@java_object")) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        boolean isSame = this == other;
        return isSame ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyString java_type() {
        return this.getRuntime().newString(this.getJavaClass().getName());
    }

    public IRubyObject java_class() {
        return JavaClass.get(this.getRuntime(), this.getJavaClass());
    }

    public RubyFixnum length() {
        throw this.getRuntime().newTypeError("not a java array");
    }

    public IRubyObject aref(IRubyObject index) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    public IRubyObject aset(IRubyObject index, IRubyObject someValue) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    public IRubyObject is_java_proxy() {
        return this.getRuntime().getFalse();
    }

    protected RubyArray buildRubyArray(IRubyObject[] constructors) {
        RubyArray result = this.getRuntime().newArray(constructors.length);
        for (int i = 0; i < constructors.length; ++i) {
            result.append(constructors[i]);
        }
        return result;
    }

    protected RubyArray buildRubyArray(Class[] classes) {
        RubyArray result = this.getRuntime().newArray(classes.length);
        for (int i = 0; i < classes.length; ++i) {
            result.append(JavaClass.get(this.getRuntime(), classes[i]));
        }
        return result;
    }
}

