/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaEmbedUtils {
    public static Ruby initialize(List loadPaths) {
        Ruby runtime = Ruby.getDefaultInstance();
        runtime.getLoadService().init(loadPaths);
        runtime.getLoadService().require("java");
        return runtime;
    }

    public static void terminate(Ruby runtime) {
        runtime.tearDown();
        runtime.getThreadService().disposeCurrentThread();
    }

    public static Object invokeMethod(Ruby runtime, Object receiver, String method, Object[] args, Class returnType) {
        IRubyObject rubyReceiver = receiver != null ? JavaUtil.convertJavaToRuby(runtime, receiver) : runtime.getTopSelf();
        IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby(runtime, args);
        IRubyObject javaUtilities = runtime.getObject().fastGetConstant("JavaUtilities");
        ThreadContext context = runtime.getCurrentContext();
        for (int i = 0; i < rubyArgs.length; ++i) {
            IRubyObject obj = rubyArgs[i];
            if (!(obj instanceof JavaObject)) continue;
            rubyArgs[i] = javaUtilities.callMethod(context, "wrap", obj);
        }
        IRubyObject result = rubyReceiver.callMethod(context, method, rubyArgs);
        return JavaEmbedUtils.rubyToJava(runtime, result, returnType);
    }

    public static Object rubyToJava(Ruby runtime, IRubyObject value, Class type) {
        return JavaUtil.convertArgument(Java.ruby_to_java(runtime.getObject(), value, Block.NULL_BLOCK), type);
    }

    public static IRubyObject javaToRuby(Ruby runtime, Object value) {
        if (value instanceof IRubyObject) {
            return (IRubyObject)value;
        }
        IRubyObject result = JavaUtil.convertJavaToRuby(runtime, value);
        if (result instanceof JavaObject) {
            return runtime.getJavaSupport().getJavaUtilitiesModule().callMethod(runtime.getCurrentContext(), "wrap", result);
        }
        return result;
    }

    public static IRubyObject javaToRuby(Ruby runtime, boolean value) {
        return JavaEmbedUtils.javaToRuby(runtime, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public static IRubyObject javaToRuby(Ruby runtime, byte value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Byte(value));
    }

    public static IRubyObject javaToRuby(Ruby runtime, char value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Character(value));
    }

    public static IRubyObject javaToRuby(Ruby runtime, double value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Double(value));
    }

    public static IRubyObject javaToRuby(Ruby runtime, float value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Float(value));
    }

    public static IRubyObject javaToRuby(Ruby runtime, int value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Integer(value));
    }

    public static IRubyObject javaToRuby(Ruby runtime, long value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Long(value));
    }

    public static IRubyObject javaToRuby(Ruby runtime, short value) {
        return JavaEmbedUtils.javaToRuby(runtime, new Short(value));
    }
}

