/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.ext.socket.RubyTCPServer;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.ext.socket.RubyUDPSocket;
import org.jruby.runtime.Arity;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ByteList;

public class RubySocket
extends RubyBasicSocket {
    private static ObjectAllocator SOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubySocket(runtime, klass);
        }
    };

    static void createSocket(Ruby runtime) {
        RubyClass rb_cSocket = runtime.defineClass("Socket", runtime.fastGetClass("BasicSocket"), SOCKET_ALLOCATOR);
        CallbackFactory cfact = runtime.callbackFactory(RubySocket.class);
        RubyModule rb_mConstants = rb_cSocket.defineModuleUnder("Constants");
        rb_mConstants.fastSetConstant("SOCK_STREAM", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("SOCK_DGRAM", runtime.newFixnum(2L));
        rb_mConstants.fastSetConstant("PF_UNSPEC", runtime.newFixnum(0L));
        rb_mConstants.fastSetConstant("AF_UNSPEC", runtime.newFixnum(0L));
        rb_mConstants.fastSetConstant("PF_INET", runtime.newFixnum(2L));
        rb_mConstants.fastSetConstant("AF_INET", runtime.newFixnum(2L));
        rb_mConstants.fastSetConstant("MSG_OOB", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("SOL_SOCKET", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("SOL_IP", runtime.newFixnum(0L));
        rb_mConstants.fastSetConstant("SOL_TCP", runtime.newFixnum(6L));
        rb_mConstants.fastSetConstant("SOL_UDP", runtime.newFixnum(17L));
        rb_mConstants.fastSetConstant("IPPROTO_IP", runtime.newFixnum(0L));
        rb_mConstants.fastSetConstant("IPPROTO_ICMP", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("IPPROTO_TCP", runtime.newFixnum(6L));
        rb_mConstants.fastSetConstant("IPPROTO_UDP", runtime.newFixnum(17L));
        rb_mConstants.fastSetConstant("INADDR_ANY", runtime.newFixnum(0L));
        rb_mConstants.fastSetConstant("INADDR_BROADCAST", runtime.newFixnum(-1L));
        rb_mConstants.fastSetConstant("INADDR_LOOPBACK", runtime.newFixnum(2130706433L));
        rb_mConstants.fastSetConstant("INADDR_UNSPEC_GROUP", runtime.newFixnum(-536870912L));
        rb_mConstants.fastSetConstant("INADDR_ALLHOSTS_GROUP", runtime.newFixnum(-536870911L));
        rb_mConstants.fastSetConstant("INADDR_MAX_LOCAL_GROUP", runtime.newFixnum(-536870657L));
        rb_mConstants.fastSetConstant("INADDR_NONE", runtime.newFixnum(-1L));
        rb_mConstants.fastSetConstant("SO_REUSEADDR", runtime.newFixnum(2L));
        rb_mConstants.fastSetConstant("SHUT_RD", runtime.newFixnum(0L));
        rb_mConstants.fastSetConstant("SHUT_WR", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("SHUT_RDWR", runtime.newFixnum(2L));
        rb_mConstants.fastSetConstant("AI_PASSIVE", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("SO_KEEPALIVE", runtime.newFixnum(9L));
        rb_mConstants.fastSetConstant("TCP_NODELAY", runtime.newFixnum(1L));
        rb_cSocket.includeModule(rb_mConstants);
        rb_cSocket.getMetaClass().defineFastMethod("gethostname", cfact.getFastSingletonMethod("gethostname"));
        rb_cSocket.getMetaClass().defineFastMethod("gethostbyaddr", cfact.getFastOptSingletonMethod("gethostbyaddr"));
        rb_cSocket.getMetaClass().defineFastMethod("gethostbyname", cfact.getFastSingletonMethod("gethostbyname", IRubyObject.class));
        rb_cSocket.getMetaClass().defineFastMethod("getaddrinfo", cfact.getFastOptSingletonMethod("getaddrinfo"));
        rb_cSocket.getMetaClass().defineFastMethod("getnameinfo", cfact.getFastOptSingletonMethod("getnameinfo"));
    }

    public RubySocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private static RuntimeException sockerr(IRubyObject recv, String msg) {
        return new RaiseException(recv.getRuntime(), recv.getRuntime().fastGetClass("SocketError"), null, true);
    }

    public static IRubyObject gethostname(IRubyObject recv) {
        try {
            return recv.getRuntime().newString(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            try {
                return recv.getRuntime().newString(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}).getHostName());
            }
            catch (UnknownHostException e2) {
                throw RubySocket.sockerr(recv, "gethostname: name or service not known");
            }
        }
    }

    private static InetAddress intoAddress(IRubyObject recv, String s) {
        try {
            byte[] bs = ByteList.plain(s);
            return InetAddress.getByAddress(bs);
        }
        catch (Exception e) {
            throw RubySocket.sockerr(recv, "strtoaddr: " + e.toString());
        }
    }

    private static String intoString(IRubyObject recv, InetAddress as) {
        try {
            return new String(ByteList.plain(as.getAddress()));
        }
        catch (Exception e) {
            throw RubySocket.sockerr(recv, "addrtostr: " + e.toString());
        }
    }

    public static IRubyObject gethostbyaddr(IRubyObject recv, IRubyObject[] args) {
        Arity.checkArgumentCount(recv.getRuntime(), args, 1, 2);
        Ruby runtime = recv.getRuntime();
        IRubyObject[] ret = new IRubyObject[]{runtime.newString(RubySocket.intoAddress(recv, args[0].convertToString().toString()).getCanonicalHostName()), runtime.newArray(), runtime.newFixnum(2L), args[0]};
        return runtime.newArrayNoCopy(ret);
    }

    public static IRubyObject gethostbyname(IRubyObject recv, IRubyObject hostname) {
        try {
            InetAddress addr = InetAddress.getByName(hostname.convertToString().toString());
            Ruby runtime = recv.getRuntime();
            IRubyObject[] ret = new IRubyObject[]{runtime.newString(addr.getCanonicalHostName()), runtime.newArray(), runtime.newFixnum(2L), runtime.newString(RubySocket.intoString(recv, addr))};
            return runtime.newArrayNoCopy(ret);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(recv, "gethostbyname: name or service not known");
        }
    }

    public static IRubyObject getaddrinfo(IRubyObject recv, IRubyObject[] args) {
        args = Arity.scanArgs(recv.getRuntime(), args, 2, 4);
        try {
            Ruby r = recv.getRuntime();
            IRubyObject host = args[0];
            IRubyObject port = args[1];
            IRubyObject socktype = args[3];
            boolean sock_stream = true;
            boolean sock_dgram = true;
            if (!socktype.isNil()) {
                int val = RubyNumeric.fix2int(socktype);
                if (val == 1) {
                    sock_dgram = false;
                } else if (val == 2) {
                    sock_stream = false;
                }
            }
            InetAddress[] addrs = InetAddress.getAllByName(host.isNil() ? null : host.convertToString().toString());
            ArrayList<IRubyObject> l = new ArrayList<IRubyObject>();
            for (int i = 0; i < addrs.length; ++i) {
                IRubyObject[] c;
                if (sock_stream) {
                    c = new IRubyObject[]{r.newString("AF_INET"), port, r.newString(addrs[i].getCanonicalHostName()), r.newString(addrs[i].getHostAddress()), r.newFixnum(2L), r.newFixnum(1L), r.newFixnum(6L)};
                    l.add(r.newArrayNoCopy(c));
                }
                if (!sock_dgram) continue;
                c = new IRubyObject[]{r.newString("AF_INET"), port, r.newString(addrs[i].getCanonicalHostName()), r.newString(addrs[i].getHostAddress()), r.newFixnum(2L), r.newFixnum(2L), r.newFixnum(17L)};
                l.add(r.newArrayNoCopy(c));
            }
            return r.newArray(l);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(recv, "getaddrinfo: name or service not known");
        }
    }

    public static IRubyObject getnameinfo(IRubyObject recv, IRubyObject[] args) {
        args = Arity.scanArgs(recv.getRuntime(), args, 1, 1);
        if (args[0] instanceof RubyArray) {
            try {
                List l = ((RubyArray)args[0]).getList();
                IRubyObject[] ret = new IRubyObject[]{recv.getRuntime().newString(InetAddress.getByName(l.get(2).toString()).getCanonicalHostName()), (IRubyObject)l.get(1)};
                return recv.getRuntime().newArrayNoCopy(ret);
            }
            catch (UnknownHostException e) {
                throw RubySocket.sockerr(recv, "getnameinfo: name or service not known");
            }
        }
        throw RubySocket.sockerr(recv, "getnameinfo: string version not supported yet");
    }

    public static class Service
    implements Library {
        @Override
        public void load(Ruby runtime) throws IOException {
            runtime.defineClass("SocketError", runtime.fastGetClass("StandardError"), runtime.fastGetClass("StandardError").getAllocator());
            RubyBasicSocket.createBasicSocket(runtime);
            RubySocket.createSocket(runtime);
            RubyIPSocket.createIPSocket(runtime);
            RubyTCPSocket.createTCPSocket(runtime);
            RubyTCPServer.createTCPServer(runtime);
            RubyUDPSocket.createUDPSocket(runtime);
        }
    }
}

