/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.util.Arrays;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.impl.AbstractVariableCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class HeapBasedVariableCompiler
extends AbstractVariableCompiler {
    private int scopeIndex;
    private int varsIndex;

    public HeapBasedVariableCompiler(StandardASMCompiler.AbstractMethodCompiler methodCompiler, SkinnyMethodAdapter method, int scopeIndex, int varsIndex, int argsIndex, int closureIndex) {
        super(methodCompiler, method, argsIndex, closureIndex);
        this.scopeIndex = scopeIndex;
        this.varsIndex = varsIndex;
    }

    @Override
    public void beginMethod(ClosureCallback argsCallback, StaticScope scope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", cg.sig(DynamicScope.class));
        this.method.dup();
        this.method.astore(this.scopeIndex);
        this.method.invokevirtual(cg.p(DynamicScope.class), "getValues", cg.sig(IRubyObject[].class));
        this.method.astore(this.varsIndex);
        this.method.aload(this.varsIndex);
        this.methodCompiler.loadNil();
        this.method.invokestatic(cg.p(Arrays.class), "fill", cg.sig(Void.TYPE, cg.params(Object[].class, Object.class)));
        if (argsCallback != null) {
            argsCallback.compile(this.methodCompiler);
        }
    }

    @Override
    public void beginClass(ClosureCallback bodyPrep, StaticScope scope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", cg.sig(DynamicScope.class));
        this.method.dup();
        this.method.astore(this.scopeIndex);
        this.method.invokevirtual(cg.p(DynamicScope.class), "getValues", cg.sig(IRubyObject[].class));
        this.method.astore(this.varsIndex);
        bodyPrep.compile(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", cg.sig(DynamicScope.class));
        this.method.dup();
        this.method.astore(this.scopeIndex);
        this.method.invokevirtual(cg.p(DynamicScope.class), "getValues", cg.sig(IRubyObject[].class));
        this.method.astore(this.varsIndex);
        this.method.aload(this.varsIndex);
        this.methodCompiler.loadNil();
        this.method.invokestatic(cg.p(Arrays.class), "fill", cg.sig(Void.TYPE, cg.params(Object[].class, Object.class)));
    }

    @Override
    public void beginClosure(ClosureCallback argsCallback, StaticScope scope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", cg.sig(DynamicScope.class));
        this.method.dup();
        this.method.astore(this.scopeIndex);
        this.method.invokevirtual(cg.p(DynamicScope.class), "getValues", cg.sig(IRubyObject[].class));
        this.method.astore(this.varsIndex);
        if (scope != null) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
                this.assignLocalVariable(i);
            }
            this.method.pop();
        }
        if (argsCallback != null) {
            this.method.aload(this.argsIndex);
            this.method.ldc(new Integer(0));
            this.method.arrayload();
            argsCallback.compile(this.methodCompiler);
            this.method.pop();
        }
    }

    @Override
    public void assignLocalVariable(int index) {
        this.method.dup();
        this.method.aload(this.varsIndex);
        this.method.swap();
        this.method.ldc(new Integer(index));
        this.method.swap();
        this.method.arraystore();
    }

    @Override
    public void assignLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.assignLocalVariable(index);
            return;
        }
        this.method.dup();
        this.method.aload(this.scopeIndex);
        this.method.swap();
        this.method.ldc(new Integer(index));
        this.method.swap();
        this.method.ldc(new Integer(depth));
        this.method.invokevirtual(cg.p(DynamicScope.class), "setValue", cg.sig(Void.TYPE, cg.params(Integer.TYPE, IRubyObject.class, Integer.TYPE)));
    }

    @Override
    public void retrieveLocalVariable(int index) {
        this.method.aload(this.varsIndex);
        this.method.ldc(new Integer(index));
        this.method.arrayload();
    }

    @Override
    public void retrieveLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.retrieveLocalVariable(index);
            return;
        }
        this.method.aload(this.scopeIndex);
        this.method.ldc(new Integer(index));
        this.method.ldc(new Integer(depth));
        this.methodCompiler.loadNil();
        this.method.invokevirtual(cg.p(DynamicScope.class), "getValueOrNil", cg.sig(IRubyObject.class, cg.params(Integer.TYPE, Integer.TYPE, IRubyObject.class)));
    }
}

