/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.StringScanner;

public class RubyStringScanner
extends RubyObject {
    private StringScanner scanner;
    private static ObjectAllocator STRINGSCANNER_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyStringScanner(runtime, klass);
        }
    };

    public static RubyClass createScannerClass(Ruby runtime) {
        RubyClass scannerClass = runtime.defineClass("StringScanner", runtime.getObject(), STRINGSCANNER_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyStringScanner.class);
        scannerClass.defineAnnotatedMethods(RubyStringScanner.class);
        return scannerClass;
    }

    protected RubyStringScanner(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod(name={"initialize"}, optional=2, frame=true)
    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        this.scanner = Arity.checkArgumentCount(this.getRuntime(), args, 0, 2) > 0 ? new StringScanner(args[0].convertToString().getValue()) : new StringScanner();
        return this;
    }

    @JRubyMethod(name={"contact", "<<"}, required=1)
    public IRubyObject concat(IRubyObject obj) {
        this.scanner.append(obj.convertToString().getValue());
        return this;
    }

    private RubyBoolean trueOrFalse(boolean p) {
        if (p) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    private IRubyObject positiveFixnumOrNil(int val) {
        if (val > -1) {
            return RubyFixnum.newFixnum(this.getRuntime(), val);
        }
        return this.getRuntime().getNil();
    }

    private IRubyObject stringOrNil(CharSequence cs) {
        if (cs == null) {
            return this.getRuntime().getNil();
        }
        return RubyString.newString(this.getRuntime(), cs);
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject group(IRubyObject num) {
        return this.stringOrNil(this.scanner.group(RubyFixnum.fix2int(num)));
    }

    @JRubyMethod(name={"bol?", "beginning_of_line"})
    public RubyBoolean bol_p() {
        return this.trueOrFalse(this.scanner.isBeginningOfLine());
    }

    @JRubyMethod(name={"check"}, required=1)
    public IRubyObject check(IRubyObject rx) {
        if (!(rx instanceof RubyRegexp)) {
            throw this.getRuntime().newTypeError(rx, this.getRuntime().getRegexp());
        }
        return this.stringOrNil(this.scanner.check(((RubyRegexp)rx).getPattern()));
    }

    @JRubyMethod(name={"check_until"}, required=1)
    public IRubyObject check_until(IRubyObject rx) {
        if (!(rx instanceof RubyRegexp)) {
            throw this.getRuntime().newTypeError(rx, this.getRuntime().getRegexp());
        }
        return this.stringOrNil(this.scanner.checkUntil(((RubyRegexp)rx).getPattern()));
    }

    @JRubyMethod(name={"terminate"})
    public IRubyObject terminate() {
        this.scanner.terminate();
        return this;
    }

    @JRubyMethod(name={"eos?", "empty?"})
    public RubyBoolean eos_p() {
        return this.trueOrFalse(this.scanner.isEndOfString());
    }

    @JRubyMethod(name={"exist?"}, required=1)
    public IRubyObject exist_p(IRubyObject rx) {
        if (!(rx instanceof RubyRegexp)) {
            throw this.getRuntime().newTypeError(rx, this.getRuntime().getRegexp());
        }
        return this.positiveFixnumOrNil(this.scanner.exists(((RubyRegexp)rx).getPattern()));
    }

    @JRubyMethod(name={"getch"})
    public IRubyObject getch() {
        char c = this.scanner.getChar();
        if (c == '\u0000') {
            return this.getRuntime().getNil();
        }
        return RubyString.newString(this.getRuntime(), new Character(c).toString());
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        return super.inspect();
    }

    @JRubyMethod(name={"match?"}, required=1)
    public IRubyObject match_p(IRubyObject rx) {
        if (!(rx instanceof RubyRegexp)) {
            throw this.getRuntime().newTypeError(rx, this.getRuntime().getRegexp());
        }
        return this.positiveFixnumOrNil(this.scanner.matches(((RubyRegexp)rx).getPattern()));
    }

    @JRubyMethod(name={"matched"})
    public IRubyObject matched() {
        return this.stringOrNil(this.scanner.matchedValue());
    }

    @JRubyMethod(name={"matched?"})
    public RubyBoolean matched_p() {
        return this.trueOrFalse(this.scanner.matched());
    }

    @JRubyMethod(name={"matched_size"})
    public IRubyObject matched_size() {
        return this.positiveFixnumOrNil(this.scanner.matchedSize());
    }

    @JRubyMethod(name={"peek"}, required=1)
    public IRubyObject peek(IRubyObject length) {
        return RubyString.newString(this.getRuntime(), this.scanner.peek(RubyFixnum.fix2int(length)));
    }

    @JRubyMethod(name={"pos"})
    public RubyFixnum pos() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.scanner.getPos());
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject pos) {
        try {
            this.scanner.setPos(RubyFixnum.fix2int(pos));
        }
        catch (IllegalArgumentException e) {
            throw this.getRuntime().newRangeError("index out of range");
        }
        return pos;
    }

    @JRubyMethod(name={"post_match"})
    public IRubyObject post_match() {
        return this.stringOrNil(this.scanner.postMatch());
    }

    @JRubyMethod(name={"pre_match"})
    public IRubyObject pre_match() {
        return this.stringOrNil(this.scanner.preMatch());
    }

    @JRubyMethod(name={"reset"})
    public IRubyObject reset() {
        this.scanner.reset();
        return this;
    }

    @JRubyMethod(name={"rest"})
    public RubyString rest() {
        return RubyString.newString(this.getRuntime(), this.scanner.rest());
    }

    @JRubyMethod(name={"rest?"})
    public RubyBoolean rest_p() {
        return this.trueOrFalse(!this.scanner.isEndOfString());
    }

    @JRubyMethod(name={"rest_size"})
    public RubyFixnum rest_size() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.scanner.rest().length());
    }

    @JRubyMethod(name={"scan"}, required=1)
    public IRubyObject scan(IRubyObject rx) {
        if (!(rx instanceof RubyRegexp)) {
            throw this.getRuntime().newTypeError(rx, this.getRuntime().getRegexp());
        }
        return this.stringOrNil(this.scanner.scan(((RubyRegexp)rx).getPattern()));
    }

    @JRubyMethod(name={"scan_full"}, required=3)
    public IRubyObject scan_full(IRubyObject rx, IRubyObject adv_ptr, IRubyObject ret_str) {
        if (!(rx instanceof RubyRegexp)) {
            throw this.getRuntime().newTypeError(rx, this.getRuntime().getRegexp());
        }
        RubyRegexp reg = (RubyRegexp)rx;
        if (adv_ptr.isTrue()) {
            if (ret_str.isTrue()) {
                return this.stringOrNil(this.scanner.scan(reg.getPattern()));
            }
            return this.positiveFixnumOrNil(this.scanner.skip(reg.getPattern()));
        }
        if (ret_str.isTrue()) {
            return this.stringOrNil(this.scanner.check(reg.getPattern()));
        }
        return this.positiveFixnumOrNil(this.scanner.matches(reg.getPattern()));
    }

    @JRubyMethod(name={"scan_until"}, required=1)
    public IRubyObject scan_until(IRubyObject rx) {
        if (!(rx instanceof RubyRegexp)) {
            throw this.getRuntime().newTypeError(rx, this.getRuntime().getRegexp());
        }
        return this.stringOrNil(this.scanner.scanUntil(((RubyRegexp)rx).getPattern()));
    }

    @JRubyMethod(name={"search_full"}, required=3)
    public IRubyObject search_full(IRubyObject rx, IRubyObject adv_ptr, IRubyObject ret_str) {
        if (!(rx instanceof RubyRegexp)) {
            throw this.getRuntime().newTypeError(rx, this.getRuntime().getRegexp());
        }
        RubyRegexp reg = (RubyRegexp)rx;
        if (adv_ptr.isTrue()) {
            if (ret_str.isTrue()) {
                return this.stringOrNil(this.scanner.scanUntil(reg.getPattern()));
            }
            return this.positiveFixnumOrNil(this.scanner.skipUntil(reg.getPattern()));
        }
        if (ret_str.isTrue()) {
            return this.stringOrNil(this.scanner.checkUntil(reg.getPattern()));
        }
        return this.positiveFixnumOrNil(this.scanner.exists(reg.getPattern()));
    }

    @JRubyMethod(name={"skip"}, required=1)
    public IRubyObject skip(IRubyObject rx) {
        if (!(rx instanceof RubyRegexp)) {
            throw this.getRuntime().newTypeError(rx, this.getRuntime().getRegexp());
        }
        return this.positiveFixnumOrNil(this.scanner.skip(((RubyRegexp)rx).getPattern()));
    }

    @JRubyMethod(name={"skip_until"}, required=1)
    public IRubyObject skip_until(IRubyObject rx) {
        if (!(rx instanceof RubyRegexp)) {
            throw this.getRuntime().newTypeError(rx, this.getRuntime().getRegexp());
        }
        return this.positiveFixnumOrNil(this.scanner.skipUntil(((RubyRegexp)rx).getPattern()));
    }

    @JRubyMethod(name={"string"})
    public RubyString string() {
        return RubyString.newString(this.getRuntime(), this.scanner.getString());
    }

    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(IRubyObject str) {
        if (!(str instanceof RubyString)) {
            throw this.getRuntime().newTypeError(str, this.getRuntime().getString());
        }
        this.scanner.setString(((RubyString)str).getValue());
        return str;
    }

    @JRubyMethod(name={"unscan"})
    public IRubyObject unscan() {
        this.scanner.unscan();
        return this;
    }

    @JRubyMethod(name={"must_C_version"}, meta=true)
    public static IRubyObject mustCversion(IRubyObject recv) {
        return recv;
    }
}

