/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyMath {
    private static final double[] ASINH_COEF = new double[]{-0.12820039911738187, -0.05881176118995177, 0.004727465432212481, -4.938363162653618E-4, 5.850620705855741E-5, -7.466998328931368E-6, 1.00116935835582E-6, -1.3903543858708333E-7, 1.9823169483172795E-8, -2.8847468417848845E-9, 4.2672965467159937E-10, -6.397608465436636E-11, 9.699168608906471E-12, -1.4844276972043772E-12, 2.290373793902745E-13, -3.5588395132732646E-14, 5.563969408005679E-15, -8.746250959962468E-16, 1.381524884452669E-16, -2.1916688282900364E-17, 3.490465852482756E-18};
    private static final double[] ATANH_COEF = new double[]{0.0943951023931955, 0.04919843705578616, 0.002102593522455433, 1.0735544497761166E-4, 5.978267249293031E-6, 3.505062030889135E-7, 2.1263743437653402E-8, 1.3216945357155272E-9, 8.36587550117807E-11, 5.370503749311002E-12, 3.4866594701571077E-13, 2.284549509603433E-14, 1.508407105944793E-15, 1.0024188168041091E-16, 6.69867473816507E-18, 4.497954546494931E-19};
    private static final double[] ERFC_COEF = new double[]{-0.049046121234691806, -0.14226120510371365, 0.010035582187599796, -5.768764699767485E-4, 2.741993125219606E-5, -1.1043175507344507E-6, 3.8488755420345036E-8, -1.1808582533875466E-9, 3.2334215826050907E-11, -7.991015947004549E-13, 1.7990725113961456E-14, -3.718635487818693E-16, 7.103599003714253E-18, -1.2612455119155226E-19};
    private static final double[] ERFC2_COEF = new double[]{-0.0696013466023095, -0.04110133936262089, 0.003914495866689627, -4.906395650548979E-4, 7.157479001377036E-5, -1.1530716341312328E-5, 1.9946705902019974E-6, -3.642666471599223E-7, 6.944372610005012E-8, -1.371220902104366E-8, 2.7883896610071373E-9, -5.814164724331161E-10, 1.2389204917527532E-10, -2.6906391453067435E-11, 5.942614350847911E-12, -1.3323867357581197E-12, 3.0280468061771323E-13, -6.966648814941033E-14, 1.620854541053923E-14, -3.809934465250492E-15, 9.040487815978831E-16, -2.1640061950896072E-16, 5.222102233995855E-17, -1.2697296023645554E-17, 3.1091455042761977E-18, -7.663762920320386E-19, 1.9008192513627452E-19};
    private static final double[] ERFCC_COEF = new double[]{0.07151793102029248, -0.026532434337606717, 0.0017111539779208558, -1.6375166345851787E-4, 1.9871293500552038E-5, -2.843712412766555E-6, 4.6061613089631305E-7, -8.227753025879209E-8, 1.5921418727709012E-8, -3.295071362252843E-9, 7.223439760400556E-10, -1.6648558133987297E-10, 4.010392588237665E-11, -1.004816214425731E-11, 2.608275913300334E-12, -6.991110560404025E-13, 1.9294923332617072E-13, -5.470131188754331E-14, 1.5896633097626975E-14, -4.726893980197555E-15, 1.4358733767849847E-15, -4.449510561817358E-16, 1.4048108847682335E-16, -4.5138183877642106E-17, 1.474521541045133E-17, -4.8926214069457765E-18, 1.6476121414106467E-18, -5.626817176329408E-19, 1.9474433822320786E-19};

    public static RubyModule createMathModule(Ruby runtime) {
        RubyModule result = runtime.defineModule("Math");
        runtime.setMath(result);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyMath.class);
        result.defineConstant("E", RubyFloat.newFloat(runtime, Math.E));
        result.defineConstant("PI", RubyFloat.newFloat(runtime, Math.PI));
        result.defineAnnotatedMethods(RubyMath.class);
        return result;
    }

    private static void domainCheck(IRubyObject recv, double value, String msg) {
        if (Double.isNaN(value)) {
            throw recv.getRuntime().newErrnoEDOMError(msg);
        }
    }

    private static double chebylevSerie(double x, double[] coef) {
        double d = 0.0;
        double b1 = 0.0;
        double b2 = 0.0;
        double twox = 2.0 * x;
        for (int i = coef.length - 1; i >= 0; --i) {
            double b0;
            b2 = b0;
            b0 = b1;
            b1 = twox * b0 - b2 + coef[i];
        }
        return 0.5 * (b1 - b2);
    }

    private static double sign(double x, double y) {
        double abs = x < 0.0 ? -x : x;
        return y < 0.0 ? -abs : abs;
    }

    @JRubyMethod(name={"atan2"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat atan2(IRubyObject recv, IRubyObject x, IRubyObject y) {
        double valuea = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        double valueb = ((RubyFloat)RubyKernel.new_float(recv, y)).getDoubleValue();
        return RubyFloat.newFloat(recv.getRuntime(), Math.atan2(valuea, valueb));
    }

    @JRubyMethod(name={"cos"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat cos(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        return RubyFloat.newFloat(recv.getRuntime(), Math.cos(value));
    }

    @JRubyMethod(name={"sin"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat sin(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        return RubyFloat.newFloat(recv.getRuntime(), Math.sin(value));
    }

    @JRubyMethod(name={"tan"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat tan(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        return RubyFloat.newFloat(recv.getRuntime(), Math.tan(value));
    }

    @JRubyMethod(name={"asin"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat asin(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        double result = Math.asin(value);
        RubyMath.domainCheck(recv, result, "asin");
        return RubyFloat.newFloat(recv.getRuntime(), result);
    }

    @JRubyMethod(name={"acos"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat acos(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        double result = Math.acos(value);
        RubyMath.domainCheck(recv, result, "acos");
        return RubyFloat.newFloat(recv.getRuntime(), result);
    }

    @JRubyMethod(name={"atan"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat atan(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        return RubyFloat.newFloat(recv.getRuntime(), Math.atan(value));
    }

    @JRubyMethod(name={"cosh"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat cosh(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        return RubyFloat.newFloat(recv.getRuntime(), (Math.exp(value) + Math.exp(-value)) / 2.0);
    }

    @JRubyMethod(name={"sinh"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat sinh(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        return RubyFloat.newFloat(recv.getRuntime(), (Math.exp(value) - Math.exp(-value)) / 2.0);
    }

    @JRubyMethod(name={"tanh"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat tanh(IRubyObject recv, IRubyObject x) {
        return RubyFloat.newFloat(recv.getRuntime(), RubyMath.sinh(recv, x).getDoubleValue() / RubyMath.cosh(recv, x).getDoubleValue());
    }

    @JRubyMethod(name={"acosh"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat acosh(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        double result = Double.isNaN(value) || value < 1.0 ? Double.NaN : (value < 9.490626562E7 ? Math.log(value + Math.sqrt(value * value - 1.0)) : 0.6931471805599453 + Math.log(value));
        RubyMath.domainCheck(recv, result, "acosh");
        return RubyFloat.newFloat(recv.getRuntime(), result);
    }

    @JRubyMethod(name={"asinh"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat asinh(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        double y = Math.abs(value);
        double result = Double.isNaN(value) ? Double.NaN : (y <= 1.05367E-8 ? value : (y <= 1.0 ? value * (1.0 + RubyMath.chebylevSerie(2.0 * value * value - 1.0, ASINH_COEF)) : (y < 9.490626562E7 ? Math.log(y + Math.sqrt(y * y + 1.0)) : 0.6931471805599453 + Math.log(y))));
        return RubyFloat.newFloat(recv.getRuntime(), result);
    }

    @JRubyMethod(name={"atanh"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat atanh(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        double y = Math.abs(value);
        double result = Double.isNaN(value) ? Double.NaN : (y < 1.82501E-8 ? value : (y <= 0.5 ? value * (1.0 + RubyMath.chebylevSerie(8.0 * value * value - 1.0, ATANH_COEF)) : (y < 1.0 ? 0.5 * Math.log((1.0 + value) / (1.0 - value)) : (y == 1.0 ? value * Double.POSITIVE_INFINITY : Double.NaN))));
        RubyMath.domainCheck(recv, result, "atanh");
        return RubyFloat.newFloat(recv.getRuntime(), result);
    }

    @JRubyMethod(name={"exp"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat exp(IRubyObject recv, IRubyObject exponent) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, exponent)).getDoubleValue();
        return RubyFloat.newFloat(recv.getRuntime(), Math.exp(value));
    }

    @JRubyMethod(name={"log"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat log(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        double result = Math.log(value);
        RubyMath.domainCheck(recv, result, "log");
        return RubyFloat.newFloat(recv.getRuntime(), result);
    }

    @JRubyMethod(name={"log10"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat log10(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        double result = Math.log(value) / Math.log(10.0);
        RubyMath.domainCheck(recv, result, "log10");
        return RubyFloat.newFloat(recv.getRuntime(), result);
    }

    @JRubyMethod(name={"sqrt"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat sqrt(IRubyObject recv, IRubyObject x) {
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        double result = value < 0.0 ? Double.NaN : Math.sqrt(value);
        RubyMath.domainCheck(recv, result, "sqrt");
        return RubyFloat.newFloat(recv.getRuntime(), result);
    }

    @JRubyMethod(name={"hypot"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat hypot(IRubyObject recv, IRubyObject x, IRubyObject y) {
        double result;
        double valuea = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        double valueb = ((RubyFloat)RubyKernel.new_float(recv, y)).getDoubleValue();
        if (Math.abs(valuea) > Math.abs(valueb)) {
            result = valueb / valuea;
            result = Math.abs(valuea) * Math.sqrt(1.0 + result * result);
        } else if (valueb != 0.0) {
            result = valuea / valueb;
            result = Math.abs(valueb) * Math.sqrt(1.0 + result * result);
        } else {
            result = 0.0;
        }
        return RubyFloat.newFloat(recv.getRuntime(), result);
    }

    @JRubyMethod(name={"frexp"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray frexp(IRubyObject recv, IRubyObject other) {
        double mantissa = ((RubyFloat)RubyKernel.new_float(recv, other)).getDoubleValue();
        int sign = 1;
        long exponent = 0L;
        if (mantissa != 0.0) {
            if (mantissa < 0.0) {
                mantissa = -mantissa;
                sign = -1;
            }
            while (mantissa < 0.5) {
                mantissa *= 2.0;
                --exponent;
            }
            while (mantissa >= 1.0) {
                mantissa *= 0.5;
                ++exponent;
            }
        }
        return RubyArray.newArray(recv.getRuntime(), RubyFloat.newFloat(recv.getRuntime(), (double)sign * mantissa), RubyNumeric.int2fix(recv.getRuntime(), exponent));
    }

    @JRubyMethod(name={"ldexp"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat ldexp(IRubyObject recv, IRubyObject mantissa, IRubyObject exponent) {
        double mantissaValue = ((RubyFloat)RubyKernel.new_float(recv, mantissa)).getDoubleValue();
        return RubyFloat.newFloat(recv.getRuntime(), mantissaValue * Math.pow(2.0, RubyNumeric.num2int(exponent)));
    }

    /*
     * WARNING - void declaration
     */
    @JRubyMethod(name={"erf"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat erf(IRubyObject recv, IRubyObject x) {
        void result;
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        double d = Math.abs(value);
        double y = d <= 1.49012E-8 ? 2.0 * value / 1.772453850905516 : (result <= 1.0 ? value * (1.0 + RubyMath.chebylevSerie(2.0 * value * value - 1.0, ERFC_COEF)) : (result < 6.013687357 ? RubyMath.sign(1.0 - RubyMath.erfc(recv, RubyFloat.newFloat(recv.getRuntime(), (double)result)).getDoubleValue(), value) : RubyMath.sign(1.0, value)));
        return RubyFloat.newFloat(recv.getRuntime(), y);
    }

    /*
     * WARNING - void declaration
     */
    @JRubyMethod(name={"erfc"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat erfc(IRubyObject recv, IRubyObject x) {
        void result;
        double y;
        double value = ((RubyFloat)RubyKernel.new_float(recv, x)).getDoubleValue();
        double d = Math.abs(value);
        if (value <= -6.013687357) {
            y = 2.0;
        } else if (result < 1.49012E-8) {
            y = 1.0 - 2.0 * value / 1.772453850905516;
        } else {
            void ysq = result * result;
            if (result < 1.0) {
                y = 1.0 - value * (1.0 + RubyMath.chebylevSerie(2.0 * ysq - 1.0, ERFC_COEF));
            } else if (result <= 4.0) {
                y = Math.exp((double)(-ysq)) / result * (0.5 + RubyMath.chebylevSerie((8.0 / ysq - 5.0) / 3.0, ERFC2_COEF));
                if (value < 0.0) {
                    y = 2.0 - y;
                }
                if (value < 0.0) {
                    y = 2.0 - y;
                }
                if (value < 0.0) {
                    y = 2.0 - y;
                }
            } else {
                y = Math.exp((double)(-ysq)) / result * (0.5 + RubyMath.chebylevSerie(8.0 / ysq - 1.0, ERFCC_COEF));
                if (value < 0.0) {
                    y = 2.0 - y;
                }
            }
        }
        return RubyFloat.newFloat(recv.getRuntime(), y);
    }
}

