/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyGC {
    public static RubyModule createGCModule(Ruby runtime) {
        RubyModule result = runtime.defineModule("GC");
        runtime.setGC(result);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyGC.class);
        result.defineAnnotatedMethods(RubyGC.class);
        return result;
    }

    @JRubyMethod(name={"start", "garbage_collect"}, module=true)
    public static IRubyObject start(IRubyObject recv) {
        System.gc();
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"enable"}, module=true)
    public static IRubyObject enable(IRubyObject recv) {
        recv.getRuntime().getWarnings().warn("GC#enable will not work on JRuby");
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"disable"}, module=true)
    public static IRubyObject disable(IRubyObject recv) {
        recv.getRuntime().getWarnings().warn("GC#disable will not work on JRuby");
        return recv.getRuntime().getNil();
    }
}

