/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import jregex.Pattern;
import jregex.PatternSyntaxException;

class Pretokenizer {
    private static final int START = 1;
    static final int END = 2;
    static final int PLAIN_GROUP = 3;
    static final int POS_LOOKAHEAD = 4;
    static final int NEG_LOOKAHEAD = 5;
    static final int POS_LOOKBEHIND = 6;
    static final int NEG_LOOKBEHIND = 7;
    static final int INDEPENDENT_REGEX = 8;
    static final int COMMENT = 9;
    static final int CONDITIONAL_GROUP = 10;
    static final int FLAGS = 11;
    static final int CLASS_GROUP = 12;
    static final int NAMED_GROUP = 13;
    int tOffset;
    int tOutside;
    int skip;
    int offset;
    int end;
    int c;
    int ttype = 1;
    char[] data;
    private int flags;
    private boolean flagsChanged;
    char[] brackets;
    String groupName;
    boolean groupDeclared;

    Pretokenizer(char[] data, int offset, int end) {
        if (offset < 0 || end > data.length) {
            throw new IndexOutOfBoundsException("offset=" + offset + ", end=" + end + ", length=" + data.length);
        }
        this.offset = offset;
        this.end = end;
        this.tOffset = offset;
        this.tOutside = offset;
        this.data = data;
    }

    int flags(int def) {
        return this.flagsChanged ? this.flags : def;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    void next() throws PatternSyntaxException {
        int tOffset = this.tOutside;
        int skip = this.skip;
        this.flagsChanged = false;
        int end = this.end;
        char[] data = this.data;
        boolean esc = false;
        int i = tOffset += skip;
        while (true) {
            block47: {
                char c1;
                block46: {
                    if (i >= end) {
                        this.ttype = 2;
                        this.tOffset = tOffset;
                        this.tOutside = end;
                        return;
                    }
                    if (!esc) break block46;
                    esc = false;
                    break block47;
                }
                char c = data[i];
                switch (c) {
                    case '\\': {
                        esc = true;
                        break block47;
                    }
                    case ')': 
                    case '|': {
                        this.ttype = c;
                        this.tOffset = tOffset;
                        this.tOutside = i;
                        this.skip = 1;
                        return;
                    }
                    case '(': {
                        if (i + 2 < end && data[i + 1] == '?') {
                            c1 = data[i + 2];
                            block6 : switch (c1) {
                                case ':': {
                                    this.ttype = 3;
                                    skip = 3;
                                    break;
                                }
                                case '=': {
                                    this.ttype = 4;
                                    skip = 3;
                                    break;
                                }
                                case '!': {
                                    this.ttype = 5;
                                    skip = 3;
                                    break;
                                }
                                case '<': {
                                    c1 = data[i + 3];
                                    switch (c1) {
                                        case '=': {
                                            this.ttype = 6;
                                            skip = 4;
                                            break block6;
                                        }
                                        case '!': {
                                            this.ttype = 7;
                                            skip = 4;
                                            break block6;
                                        }
                                    }
                                    throw new PatternSyntaxException("invalid character after '(?<' : " + c1);
                                }
                                case '>': {
                                    this.ttype = 8;
                                    skip = 3;
                                    break;
                                }
                                case '#': {
                                    this.ttype = 9;
                                    skip = 3;
                                    break;
                                }
                                case '(': {
                                    this.ttype = 10;
                                    skip = 2;
                                    break;
                                }
                                case '[': {
                                    this.ttype = 12;
                                    skip = 2;
                                    break;
                                }
                                default: {
                                    int n = i + 2;
                                    while (n < end) {
                                        void mOff;
                                        char c2 = data[n];
                                        switch (c2) {
                                            case '-': 
                                            case 'X': 
                                            case 'i': 
                                            case 'm': 
                                            case 's': 
                                            case 'u': 
                                            case 'x': {
                                                break;
                                            }
                                            case ':': {
                                                int p = i + 2;
                                                void c22 = mOff - p;
                                                if (c22 > 0) {
                                                    this.flags = Pattern.parseFlags(data, p, (int)c22);
                                                    this.flagsChanged = true;
                                                }
                                                this.ttype = 3;
                                                skip = c22 + 3;
                                                break block6;
                                            }
                                            case ')': {
                                                int p = i + 2;
                                                void c22 = mOff - p;
                                                this.flags = Pattern.parseFlags(data, p, (int)c22);
                                                this.flagsChanged = true;
                                                this.ttype = 11;
                                                skip = c22 + 3;
                                                break block6;
                                            }
                                            default: {
                                                void mLen;
                                                throw new PatternSyntaxException("wrong char after \"(?\": " + (char)mLen);
                                            }
                                        }
                                        ++mOff;
                                    }
                                    break block6;
                                }
                            }
                        } else if (i + 2 < end && data[i + 1] == '{') {
                            void nstart;
                            boolean mOff;
                            int p = i + 2;
                            skip = 3;
                            c = data[p];
                            while (Character.isWhitespace(c)) {
                                c = data[++p];
                                ++skip;
                                if (p != end) continue;
                                throw new PatternSyntaxException("malformed named group");
                            }
                            if (c == '=') {
                                mOff = false;
                                c = data[++p];
                                ++skip;
                                if (p == end) {
                                    throw new PatternSyntaxException("malformed named group");
                                }
                            } else {
                                mOff = true;
                            }
                            int isDecl = p;
                            while (Character.isJavaIdentifierPart(c)) {
                                c = data[++p];
                                ++skip;
                                if (p != end) continue;
                                throw new PatternSyntaxException("malformed named group");
                            }
                            int n = p;
                            while (Character.isWhitespace(c)) {
                                c = data[++p];
                                ++skip;
                                if (p != end) continue;
                                throw new PatternSyntaxException("malformed named group");
                            }
                            if (c != '}') {
                                throw new PatternSyntaxException("'}' expected at " + (p - i) + " in " + new String(data, i, end - i));
                            }
                            this.groupName = new String(data, isDecl, n - isDecl);
                            this.groupDeclared = nstart;
                            this.ttype = 13;
                        } else {
                            this.ttype = 40;
                            skip = 1;
                        }
                        this.tOffset = tOffset;
                        this.tOutside = i;
                        this.skip = skip;
                        return;
                    }
                    case '[': {
                        break;
                    }
                    default: {
                        break block47;
                    }
                }
                block34: while (true) {
                    if (i == end) {
                        throw new PatternSyntaxException("malformed character class");
                    }
                    c1 = data[i];
                    switch (c1) {
                        case '\\': {
                            ++i;
                            break;
                        }
                        case ']': {
                            break block34;
                        }
                    }
                    ++i;
                }
            }
            ++i;
        }
    }
}

