/*
 * Decompiled with CFR 0.152.
 */
package org.joni.encoding;

import org.joni.ApplyAllCaseFoldFunction;
import org.joni.CaseFoldCodeItem;
import org.joni.IntHolder;
import org.joni.encoding.AbstractEncoding;
import org.joni.util.BytesHash;

public abstract class Encoding {
    protected byte[] name;
    protected int hashCode;
    public static final byte NEW_LINE = 10;

    public abstract String toString();

    public final boolean equals(Object other) {
        return this == other;
    }

    public final int hashCode() {
        if (this.name == null) {
            this.getName();
        }
        return this.hashCode;
    }

    public final byte[] getName() {
        if (this.name == null) {
            this.name = this.toString().getBytes();
            this.hashCode = BytesHash.hashCode(this.name, 0, this.name.length);
        }
        return this.name;
    }

    public abstract int length(byte var1);

    public abstract int maxLength();

    public final int maxLengthDistance() {
        return this.maxLength();
    }

    public abstract int minLength();

    public abstract boolean isNewLine(byte[] var1, int var2, int var3);

    public abstract int mbcToCode(byte[] var1, int var2, int var3);

    public abstract int codeToMbcLength(int var1);

    public abstract int codeToMbc(int var1, byte[] var2, int var3);

    public abstract int mbcCaseFold(int var1, byte[] var2, IntHolder var3, int var4, byte[] var5);

    public byte[] toLowerCaseTable() {
        return null;
    }

    public abstract void applyAllCaseFold(int var1, ApplyAllCaseFoldFunction var2, Object var3);

    public abstract CaseFoldCodeItem[] caseFoldCodesByString(int var1, byte[] var2, int var3, int var4);

    public abstract int propertyNameToCType(byte[] var1, int var2, int var3);

    public abstract boolean isCodeCType(int var1, int var2);

    public abstract int[] ctypeCodeRange(int var1, IntHolder var2);

    public abstract int leftAdjustCharHead(byte[] var1, int var2, int var3);

    public abstract boolean isReverseMatchAllowed(byte[] var1, int var2, int var3);

    public final int rightAdjustCharHead(byte[] bytes, int p, int end) {
        int p_ = this.leftAdjustCharHead(bytes, p, end);
        if (p_ < end) {
            p_ += this.length(bytes[p_]);
        }
        return p_;
    }

    public final int rightAdjustCharHeadWithPrev(byte[] bytes, int p, int end, IntHolder prev) {
        int p_ = this.leftAdjustCharHead(bytes, p, end);
        if (p_ < end) {
            if (prev != null) {
                prev.value = p_;
            }
            p_ += this.length(bytes[p_]);
        } else if (prev != null) {
            prev.value = -1;
        }
        return p_;
    }

    public final int prevCharHead(byte[] bytes, int p, int end) {
        if (end <= p) {
            return -1;
        }
        return this.leftAdjustCharHead(bytes, p, end - 1);
    }

    public final int stepBack(byte[] bytes, int p, int end, int n) {
        while (end != -1 && n-- > 0) {
            if (end <= p) {
                return -1;
            }
            end = this.leftAdjustCharHead(bytes, p, end - 1);
        }
        return end;
    }

    public final int step(byte[] bytes, int p, int end, int n) {
        int q = p;
        while (n-- > 0) {
            q += this.length(bytes[q]);
        }
        return q <= end ? q : -1;
    }

    public int strLength(byte[] bytes, int p, int end) {
        int n = 0;
        int q = p;
        while (q < end) {
            q += this.length(bytes[q]);
            ++n;
        }
        return n;
    }

    public final int strLengthNull(byte[] bytes, int p) {
        int n = 0;
        while (true) {
            if (bytes[p] == 0) {
                int len = this.minLength();
                if (len == 1) {
                    return n;
                }
                int q = p + 1;
                while (len > 1 && bytes[q] == 0) {
                    ++q;
                    --len;
                }
                if (len == 1) {
                    return n;
                }
            }
            p += this.length(bytes[p]);
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int strByteLengthNull(byte[] bytes, int p) {
        int n = 0;
        int start = 0;
        while (true) {
            if (bytes[start] == 0) {
                void p_;
                int len = this.minLength();
                if (len == 1) {
                    return start - p_;
                }
                int q = start + 1;
                while (len > 1) {
                    if (q >= bytes.length) {
                        return start - p_;
                    }
                    if (bytes[q] != 0) break;
                    ++q;
                    --len;
                }
                if (len == 1) {
                    return start - p_;
                }
            }
            start += this.length(bytes[start]);
        }
    }

    public final int strNCmp(byte[] bytes, int p, int end, byte[] ascii, int asciiP, int n) {
        while (n-- > 0) {
            if (p >= end) {
                return ascii[asciiP];
            }
            int c = this.mbcToCode(bytes, p, end);
            int x = ascii[asciiP] - c;
            if (x != 0) {
                return x;
            }
            ++asciiP;
            p += this.length(bytes[p]);
        }
        return 0;
    }

    public final boolean isNewLine(int code) {
        return this.isCodeCType(code, 0);
    }

    public final boolean isGraph(int code) {
        return this.isCodeCType(code, 5);
    }

    public final boolean isPrint(int code) {
        return this.isCodeCType(code, 7);
    }

    public final boolean isAlnum(int code) {
        return this.isCodeCType(code, 13);
    }

    public final boolean isAlpha(int code) {
        return this.isCodeCType(code, 1);
    }

    public final boolean isLower(int code) {
        return this.isCodeCType(code, 6);
    }

    public final boolean isUpper(int code) {
        return this.isCodeCType(code, 10);
    }

    public final boolean isCntrl(int code) {
        return this.isCodeCType(code, 3);
    }

    public final boolean isPunct(int code) {
        return this.isCodeCType(code, 8);
    }

    public final boolean isSpace(int code) {
        return this.isCodeCType(code, 9);
    }

    public final boolean isBlank(int code) {
        return this.isCodeCType(code, 2);
    }

    public final boolean isDigit(int code) {
        return this.isCodeCType(code, 4);
    }

    public final boolean isXDigit(int code) {
        return this.isCodeCType(code, 11);
    }

    public final boolean isWord(int code) {
        return this.isCodeCType(code, 12);
    }

    public final boolean isMbcWord(byte[] bytes, int p, int end) {
        return this.isWord(this.mbcToCode(bytes, p, end));
    }

    public final boolean isSbWord(int code) {
        return Encoding.isAscii(code) && this.isWord(code);
    }

    public final boolean isMbcHead(byte b) {
        return this.length(b) != 1;
    }

    public boolean isMbcCrnl(byte[] bytes, int p, int end) {
        return this.mbcToCode(bytes, p, end) == 13 && this.isNewLine(bytes, p + this.length(bytes[p]), end);
    }

    public static int digitVal(int code) {
        return code - 48;
    }

    public static int odigitVal(int code) {
        return Encoding.digitVal(code);
    }

    public final int xdigitVal(int code) {
        if (this.isDigit(code)) {
            return Encoding.digitVal(code);
        }
        return this.isUpper(code) ? code - 65 + 10 : code - 97 + 10;
    }

    public static boolean isMbcAscii(byte b) {
        return (b & 0xFF) < 128;
    }

    public static boolean isAscii(int code) {
        return code < 128;
    }

    public static int asciiToLower(int c) {
        return AbstractEncoding.AsciiToLowerCaseTable[c];
    }

    public static int asciiToUpper(int c) {
        return AbstractEncoding.AsciiToUpperCaseTable[c];
    }

    public static boolean isWordGraphPrint(int ctype) {
        return ctype == 12 || ctype == 5 || ctype == 7;
    }

    public final int mbcodeStartPosition() {
        return this.minLength() > 1 ? 0 : 128;
    }

    public abstract boolean isSingleByte();

    public abstract boolean isFixedWidth();
}

