/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.Arrays;

public class CodegenUtils {
    public static final CodegenUtils cg = new CodegenUtils();

    public String c(String p) {
        return p.replace('/', '.');
    }

    public String p(Class n) {
        return n.getName().replace('.', '/');
    }

    public String ci(Class n) {
        if (n.isArray()) {
            if ((n = n.getComponentType()).isPrimitive()) {
                if (n == Byte.TYPE) {
                    return "[B";
                }
                if (n == Boolean.TYPE) {
                    return "[Z";
                }
                if (n == Integer.TYPE) {
                    return "[I";
                }
                if (n == Double.TYPE) {
                    return "[D";
                }
                if (n == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
            }
            return "[" + this.ci(n);
        }
        if (n.isPrimitive()) {
            if (n == Byte.TYPE) {
                return "B";
            }
            if (n == Boolean.TYPE) {
                return "Z";
            }
            if (n == Integer.TYPE) {
                return "I";
            }
            if (n == Double.TYPE) {
                return "D";
            }
            if (n == Long.TYPE) {
                return "J";
            }
            if (n == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
        }
        return "L" + this.p(n) + ";";
    }

    public String sig(Class retval, Class ... params) {
        StringBuffer signature = new StringBuffer("(");
        for (int i = 0; i < params.length; ++i) {
            signature.append(this.ci(params[i]));
        }
        signature.append(")").append(this.ci(retval));
        return signature.toString();
    }

    public String sig(Class retval) {
        StringBuffer signature = new StringBuffer("()");
        signature.append(this.ci(retval));
        return signature.toString();
    }

    public Class[] params(Class ... classes) {
        return classes;
    }

    public Class[] params(Class cls, int times) {
        Object[] classes = new Class[times];
        Arrays.fill(classes, cls);
        return classes;
    }

    public Class[] params(Class cls1, Class clsFill, int times) {
        Object[] classes = new Class[times + 1];
        Arrays.fill(classes, clsFill);
        classes[0] = cls1;
        return classes;
    }
}

