/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public final class ByteList
implements Comparable,
CharSequence,
Serializable {
    private static final long serialVersionUID = -1286166947275543731L;
    public static final byte[] NULL_ARRAY = new byte[0];
    public static final ByteList EMPTY_BYTELIST = new ByteList(0);
    public byte[] bytes;
    public int begin;
    public int realSize;
    int hash;
    boolean validHash = false;
    String stringValue;
    private static final int DEFAULT_SIZE = 4;
    private static final double FACTOR = 1.5;
    private static final char[] caseTable = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};

    public ByteList() {
        this(4);
    }

    public ByteList(int size) {
        this.bytes = new byte[size];
        this.realSize = 0;
    }

    public ByteList(byte[] wrap) {
        this(wrap, true);
    }

    public ByteList(byte[] wrap, boolean copy) {
        if (wrap == null) {
            throw new NullPointerException("Invalid argument: constructing with null array");
        }
        this.bytes = copy ? (byte[])wrap.clone() : wrap;
        this.realSize = wrap.length;
    }

    public ByteList(ByteList wrap) {
        this(wrap.bytes, wrap.begin, wrap.realSize);
    }

    public ByteList(ByteList wrap, boolean copy) {
        this(wrap.bytes, wrap.begin, wrap.realSize, false);
    }

    public ByteList(byte[] wrap, int index, int len) {
        this(wrap, index, len, true);
    }

    public ByteList(byte[] wrap, int index, int len, boolean copy) {
        if (wrap == null) {
            throw new NullPointerException("Invalid argument: constructing with null array");
        }
        if (copy || index != 0) {
            this.bytes = new byte[len];
            System.arraycopy(wrap, index, this.bytes, 0, len);
        } else {
            this.bytes = wrap;
        }
        this.realSize = len;
    }

    public ByteList(ByteList wrap, int index, int len) {
        this(wrap.bytes, wrap.begin + index, len);
    }

    private ByteList(boolean flag) {
    }

    public void delete(int start, int len) {
        this.realSize -= len;
        System.arraycopy(this.bytes, start + len, this.bytes, start, this.realSize);
    }

    public ByteList append(byte b) {
        this.grow(1);
        this.bytes[this.realSize++] = b;
        return this;
    }

    public ByteList append(int b) {
        this.append((byte)b);
        return this;
    }

    public ByteList append(InputStream input, int length) throws IOException {
        int read;
        int n;
        this.grow(length);
        for (read = 0; read < length; read += n) {
            n = input.read(this.bytes, this.begin + read, length - read);
            if (n != -1) continue;
            if (read != 0) break;
            throw new EOFException();
        }
        this.realSize += read;
        return this;
    }

    public Object clone() {
        return this.dup();
    }

    public ByteList dup() {
        ByteList dup = this.dup(this.realSize);
        dup.validHash = this.validHash;
        dup.hash = this.hash;
        dup.stringValue = this.stringValue;
        return dup;
    }

    public ByteList dup(int length) {
        ByteList dup = new ByteList(false);
        dup.bytes = new byte[length];
        System.arraycopy(this.bytes, this.begin, dup.bytes, 0, this.realSize);
        dup.realSize = this.realSize;
        dup.begin = 0;
        return dup;
    }

    public void ensure(int length) {
        if (length >= this.bytes.length) {
            byte[] tmp = new byte[length + (length >>> 1)];
            System.arraycopy(this.bytes, this.begin, tmp, 0, this.realSize);
            this.bytes = tmp;
        }
    }

    public ByteList makeShared(int index, int len) {
        ByteList shared = new ByteList(false);
        shared.bytes = this.bytes;
        shared.realSize = len;
        shared.begin = this.begin + index;
        return shared;
    }

    public void view(int index, int len) {
        this.realSize = len;
        this.begin += index;
    }

    public void unshare() {
        this.unshare(this.realSize);
    }

    public void unshare(int length) {
        byte[] tmp = new byte[length];
        System.arraycopy(this.bytes, this.begin, tmp, 0, this.realSize);
        this.bytes = tmp;
        this.begin = 0;
    }

    public void invalidate() {
        this.validHash = false;
        this.stringValue = null;
    }

    public void prepend(byte b) {
        this.grow(1);
        System.arraycopy(this.bytes, 0, this.bytes, 1, this.realSize);
        this.bytes[0] = b;
        ++this.realSize;
    }

    public void append(byte[] moreBytes) {
        this.grow(moreBytes.length);
        System.arraycopy(moreBytes, 0, this.bytes, this.realSize, moreBytes.length);
        this.realSize += moreBytes.length;
    }

    public void append(ByteList moreBytes) {
        this.append(moreBytes.bytes, moreBytes.begin, moreBytes.realSize);
    }

    public void append(ByteList moreBytes, int index, int len) {
        this.append(moreBytes.bytes, moreBytes.begin + index, len);
    }

    public void append(byte[] moreBytes, int start, int len) {
        this.grow(len);
        System.arraycopy(moreBytes, start, this.bytes, this.realSize, len);
        this.realSize += len;
    }

    public void realloc(int length) {
        byte[] tmp = new byte[length];
        System.arraycopy(this.bytes, 0, tmp, 0, this.realSize);
        this.bytes = tmp;
    }

    public int length() {
        return this.realSize;
    }

    public void length(int newLength) {
        this.grow(newLength - this.realSize);
        this.realSize = newLength;
    }

    public int get(int index) {
        if (index >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[this.begin + index];
    }

    public void set(int index, int b) {
        if (index >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.bytes[this.begin + index] = (byte)b;
    }

    public void replace(byte[] newBytes) {
        if (newBytes == null) {
            throw new NullPointerException("Invalid argument: replacing with null array");
        }
        this.bytes = newBytes;
        this.realSize = newBytes.length;
    }

    public void unsafeReplace(int beg, int len, ByteList nbytes) {
        this.unsafeReplace(beg, len, nbytes.bytes, nbytes.begin, nbytes.realSize);
    }

    public void unsafeReplace(int beg, int len, byte[] buf) {
        this.unsafeReplace(beg, len, buf, 0, buf.length);
    }

    public void unsafeReplace(int beg, int len, byte[] nbytes, int index, int count) {
        this.grow(count - len);
        int newSize = this.realSize + count - len;
        System.arraycopy(this.bytes, beg + len, this.bytes, beg + count, this.realSize - (len + beg));
        System.arraycopy(nbytes, index, this.bytes, beg, count);
        this.realSize = newSize;
    }

    public void replace(int beg, int len, ByteList nbytes) {
        this.replace(beg, len, nbytes.bytes, nbytes.begin, nbytes.realSize);
    }

    public void replace(int beg, int len, byte[] buf) {
        this.replace(beg, len, buf, 0, buf.length);
    }

    public void replace(int beg, int len, byte[] nbytes, int index, int count) {
        if (len - beg > this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.unsafeReplace(beg, len, nbytes, index, count);
    }

    public void insert(int index, int b) {
        if (index >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.grow(1);
        System.arraycopy(this.bytes, index, this.bytes, index + 1, this.realSize - index);
        this.bytes[index] = (byte)b;
        ++this.realSize;
    }

    public int indexOf(int c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(int c, int pos) {
        if (c > 255) {
            return -1;
        }
        byte b = (byte)(c & 0xFF);
        int size = this.begin + this.realSize;
        byte[] buf = this.bytes;
        pos += this.begin;
        while (pos < size && buf[pos] != b) {
            ++pos;
        }
        return pos < size ? pos - this.begin : -1;
    }

    public int indexOf(ByteList find) {
        return this.indexOf(find, 0);
    }

    public int indexOf(ByteList find, int i) {
        return ByteList.indexOf(this.bytes, this.begin, this.realSize, find.bytes, find.begin, find.realSize, i);
    }

    static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public int lastIndexOf(int c) {
        return this.lastIndexOf(c, this.realSize - 1);
    }

    public int lastIndexOf(int c, int pos) {
        if (c > 255) {
            return -1;
        }
        byte b = (byte)(c & 0xFF);
        int size = this.begin + this.realSize;
        byte[] buf = this.bytes;
        pos = (pos += this.begin) >= size ? size : ++pos;
        while (--pos >= this.begin && buf[pos] != b) {
        }
        return pos - this.begin;
    }

    public int lastIndexOf(ByteList find) {
        return this.lastIndexOf(find, this.realSize);
    }

    public int lastIndexOf(ByteList find, int pos) {
        return ByteList.lastIndexOf(this.bytes, this.begin, this.realSize, find.bytes, find.begin, find.realSize, pos);
    }

    static int lastIndexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        byte strLastChar = target[strLastIndex];
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public boolean startsWith(ByteList other, int toffset) {
        byte[] ta = this.bytes;
        int to = this.begin + toffset;
        byte[] pa = other.bytes;
        int po = other.begin;
        int pc = other.realSize;
        while (--pc >= 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(ByteList other) {
        return this.startsWith(other, 0);
    }

    public boolean endsWith(ByteList other) {
        return this.startsWith(other, this.realSize - other.realSize);
    }

    public boolean equals(Object other) {
        if (other instanceof ByteList) {
            return this.equal((ByteList)other);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equal(ByteList other) {
        if (other == this) {
            return true;
        }
        if (this.validHash && other.validHash && this.hash != other.hash) {
            return false;
        }
        int n = this.realSize;
        if (n == other.realSize) {
            void first;
            byte[] last = this.bytes;
            int buf = -1;
            while (--first > buf && last[this.begin + first] == other.bytes[other.begin + first] && ++buf < first && last[this.begin + buf] == other.bytes[other.begin + buf]) {
            }
            return buf >= first;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean sample_equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ByteList) {
            ByteList b = (ByteList)other;
            int n = this.realSize;
            if (n == b.realSize) {
                void last;
                void first;
                byte[] byArray = this.bytes;
                int size = -1;
                int buf = first + true & 0xFFFFFFFE;
                while ((buf -= 2) >= 0 && last[this.begin + buf] == b.bytes[b.begin + buf] && (size += 2) < first && last[this.begin + size] == b.bytes[b.begin + size]) {
                }
                return buf < 0 || size == first;
            }
        }
        return false;
    }

    public int compareTo(Object other) {
        return this.cmp((ByteList)other);
    }

    public int cmp(ByteList other) {
        if (other == this) {
            return 0;
        }
        int size = this.realSize;
        int len = Math.min(size, other.realSize);
        int offset = -1;
        while (++offset < len && this.bytes[this.begin + offset] == other.bytes[other.begin + offset]) {
        }
        if (offset < len) {
            return (this.bytes[this.begin + offset] & 0xFF) > (other.bytes[other.begin + offset] & 0xFF) ? 1 : -1;
        }
        return size == other.realSize ? 0 : (size == len ? -1 : 1);
    }

    public int caseInsensitiveCmp(ByteList other) {
        if (other == this) {
            return 0;
        }
        int size = this.realSize;
        int len = Math.min(size, other.realSize);
        int other_begin = other.begin;
        byte[] other_bytes = other.bytes;
        int offset = -1;
        while (++offset < len) {
            char myCharIgnoreCase = caseTable[this.bytes[this.begin + offset] & 0xFF];
            char otherCharIgnoreCase = caseTable[other_bytes[other_begin + offset] & 0xFF];
            if (myCharIgnoreCase < otherCharIgnoreCase) {
                return -1;
            }
            if (myCharIgnoreCase <= otherCharIgnoreCase) continue;
            return 1;
        }
        return size == other.realSize ? 0 : (size == len ? -1 : 1);
    }

    public byte[] unsafeBytes() {
        return this.bytes;
    }

    public byte[] bytes() {
        byte[] newBytes = new byte[this.realSize];
        System.arraycopy(this.bytes, this.begin, newBytes, 0, this.realSize);
        return newBytes;
    }

    public int begin() {
        return this.begin;
    }

    private void grow(int increaseRequested) {
        if (increaseRequested < 0) {
            return;
        }
        int newSize = this.realSize + increaseRequested;
        if (this.bytes.length < newSize) {
            byte[] newBytes = new byte[(int)((double)newSize * 1.5)];
            if (this.bytes.length != 0) {
                System.arraycopy(this.bytes, 0, newBytes, 0, this.realSize);
            }
            this.bytes = newBytes;
        }
    }

    public int hashCode() {
        if (this.validHash) {
            return this.hash;
        }
        int key = 0;
        int index = this.begin;
        int end = this.begin + this.realSize;
        while (index < end) {
            key = (key << 16) + (key << 6) - key + this.bytes[index++];
        }
        key += key >> 5;
        this.validHash = true;
        this.hash = key;
        return this.hash;
    }

    public String toString() {
        try {
            if (this.stringValue == null) {
                this.stringValue = new String(this.bytes, this.begin, this.realSize, "ISO-8859-1");
            }
            return this.stringValue;
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("ISO-8859-1 encoding should never fail; report this at www.jruby.org");
        }
    }

    public static ByteList create(CharSequence s) {
        return new ByteList(ByteList.plain(s), false);
    }

    public static byte[] plain(CharSequence s) {
        if (s instanceof String) {
            try {
                return ((String)s).getBytes("ISO8859-1");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)s.charAt(i);
        }
        return bytes;
    }

    public static byte[] plain(char[] s) {
        byte[] bytes = new byte[s.length];
        for (int i = 0; i < s.length; ++i) {
            bytes[i] = (byte)s[i];
        }
        return bytes;
    }

    public static char[] plain(byte[] b, int start, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(b[start + i] & 0xFF);
        }
        return chars;
    }

    public static char[] plain(byte[] b) {
        char[] chars = new char[b.length];
        for (int i = 0; i < b.length; ++i) {
            chars[i] = (char)(b[i] & 0xFF);
        }
        return chars;
    }

    public char charAt(int ix) {
        return (char)(this.bytes[this.begin + ix] & 0xFF);
    }

    public CharSequence subSequence(int start, int end) {
        return new ByteList(this, start, end - start);
    }

    public static int memcmp(byte[] first, int firstStart, int firstLen, byte[] second, int secondStart, int secondLen) {
        if (first == second) {
            return 0;
        }
        int len = Math.min(firstLen, secondLen);
        int offset = -1;
        while (++offset < len && first[firstStart + offset] == second[secondStart + offset]) {
        }
        if (offset < len) {
            return (first[firstStart + offset] & 0xFF) > (second[secondStart + offset] & 0xFF) ? 1 : -1;
        }
        return firstLen == secondLen ? 0 : (firstLen == len ? -1 : 1);
    }
}

