/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;

public class ExternalScript
implements Library {
    private final LoadServiceResource resource;

    public ExternalScript(LoadServiceResource resource, String name) {
        this.resource = resource;
    }

    public void load(Ruby runtime, boolean wrap) {
        try {
            BufferedInputStream in = new BufferedInputStream(this.resource.getURL().openStream());
            if (runtime.getInstanceConfig().getCompileMode().shouldPrecompileAll()) {
                runtime.compileAndLoadFile(this.resource.getName(), in, wrap);
            } else {
                runtime.loadFile(this.resource.getName(), in, wrap);
            }
            ((InputStream)in).close();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }
}

