/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.util.ByteList;

public final class StringSupport {
    public static final int CR_MASK = 48;
    public static final int CR_UNKNOWN = 0;
    public static final int CR_7BIT = 16;
    public static final int CR_VALID = 32;
    public static final int CR_BROKEN = 48;

    public static int length(Encoding enc, byte[] bytes, int p2, int end2) {
        int n = enc.length(bytes, p2, end2);
        if (n > 0 && end2 - p2 >= n) {
            return n;
        }
        return end2 - p2 >= enc.minLength() ? enc.minLength() : end2 - p2;
    }

    public static int preciseLength(Encoding enc, byte[] bytes, int p2, int end2) {
        if (p2 >= end2) {
            return -2;
        }
        int n = enc.length(bytes, p2, end2);
        if (n > end2 - p2) {
            return -1 - (n - (end2 - p2));
        }
        return n;
    }

    public static int searchNonAscii(byte[] bytes, int p2, int end2) {
        while (p2 < end2) {
            if (!Encoding.isAscii(bytes[p2])) {
                return p2;
            }
            ++p2;
        }
        return -1;
    }

    public static int searchNonAscii(ByteList bytes) {
        return StringSupport.searchNonAscii(bytes.bytes, bytes.begin, bytes.begin + bytes.realSize);
    }

    public static int codeRangeScan(Encoding enc, byte[] bytes, int p2, int len) {
        if (enc == ASCIIEncoding.INSTANCE) {
            return StringSupport.searchNonAscii(bytes, p2, p2 + len) != -1 ? 32 : 16;
        }
        if (enc.isAsciiCompatible()) {
            return StringSupport.codeRangeScanAsciiCompatible(enc, bytes, p2, len);
        }
        return StringSupport.codeRangeScanNonAsciiCompatible(enc, bytes, p2, len);
    }

    private static int codeRangeScanAsciiCompatible(Encoding enc, byte[] bytes, int p2, int len) {
        int end2 = p2 + len;
        if ((p2 = StringSupport.searchNonAscii(bytes, p2, end2)) == -1) {
            return 16;
        }
        while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes, p2, end2);
            if (cl <= 0) {
                return 48;
            }
            if ((p2 += cl) >= end2 || (p2 = StringSupport.searchNonAscii(bytes, p2, end2)) != -1) continue;
            return 32;
        }
        return p2 > end2 ? 48 : 32;
    }

    private static int codeRangeScanNonAsciiCompatible(Encoding enc, byte[] bytes, int p2, int len) {
        int end2 = p2 + len;
        while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes, p2, end2);
            if (cl <= 0) {
                return 48;
            }
            p2 += cl;
        }
        return p2 > end2 ? 48 : 32;
    }

    public static int codeRangeScan(Encoding enc, ByteList bytes) {
        return StringSupport.codeRangeScan(enc, bytes.bytes, bytes.begin, bytes.realSize);
    }

    public static long codeRangeScanRestartable(Encoding enc, byte[] bytes, int s, int end2, int cr) {
        int p2;
        if (cr == 48) {
            return StringSupport.pack(end2 - s, cr);
        }
        if (enc == ASCIIEncoding.INSTANCE) {
            return StringSupport.pack(end2 - s, StringSupport.searchNonAscii(bytes, p2, end2) == -1 && cr != 32 ? 16 : 32);
        }
        if (enc.isAsciiCompatible()) {
            if ((p2 = StringSupport.searchNonAscii(bytes, p2, end2)) == -1) {
                return StringSupport.pack(end2 - s, cr != 32 ? 16 : cr);
            }
            while (p2 < end2) {
                int cl = StringSupport.preciseLength(enc, bytes, p2, end2);
                if (cl <= 0) {
                    return StringSupport.pack(p2 - s, cl == -1 ? 48 : 0);
                }
                if ((p2 += cl) >= end2 || (p2 = StringSupport.searchNonAscii(bytes, p2, end2)) != -1) continue;
                return StringSupport.pack(end2 - s, 32);
            }
        } else {
            int cl;
            for (p2 = s; p2 < end2; p2 += cl) {
                cl = StringSupport.preciseLength(enc, bytes, p2, end2);
                if (cl > 0) continue;
                return StringSupport.pack(p2 - s, cl == -1 ? 48 : 0);
            }
        }
        return StringSupport.pack(p2 - s, p2 > end2 ? 48 : 32);
    }

    public static int strLength(Encoding enc, byte[] bytes, int p2, int end2) {
        if (enc.isFixedWidth()) {
            return (end2 - p2 + enc.minLength() - 1) / enc.minLength();
        }
        if (enc.isAsciiCompatible()) {
            int c = 0;
            while (p2 < end2) {
                if (Encoding.isAscii(bytes[p2])) {
                    int q = StringSupport.searchNonAscii(bytes, p2, end2);
                    if (q == -1) {
                        return c + (end2 - p2);
                    }
                    c += q - p2;
                    p2 = q;
                }
                p2 += StringSupport.length(enc, bytes, p2, end2);
                ++c;
            }
            return c;
        }
        int c = 0;
        while (end2 > p2) {
            p2 += StringSupport.length(enc, bytes, p2, end2);
            ++c;
        }
        return c;
    }

    public static int strLength(ByteList bytes) {
        return StringSupport.strLength(bytes.encoding, bytes.bytes, bytes.begin, bytes.begin + bytes.realSize);
    }

    public static long strLengthWithCodeRange(Encoding enc, byte[] bytes, int p2, int end2) {
        if (enc.isFixedWidth()) {
            return (end2 - p2 + enc.minLength() - 1) / enc.minLength();
        }
        if (enc.isAsciiCompatible()) {
            return StringSupport.strLengthWithCodeRangeAsciiCompatible(enc, bytes, p2, end2);
        }
        return StringSupport.strLengthWithCodeRangeNonAsciiCompatible(enc, bytes, p2, end2);
    }

    private static long strLengthWithCodeRangeAsciiCompatible(Encoding enc, byte[] bytes, int p2, int end2) {
        int cr = 0;
        int c = 0;
        while (p2 < end2) {
            int cl;
            if (Encoding.isAscii(bytes[p2])) {
                int q = StringSupport.searchNonAscii(bytes, p2, end2);
                if (q == -1) {
                    return StringSupport.pack(c + (end2 - p2), cr == 0 ? 16 : cr);
                }
                c += q - p2;
                p2 = q;
            }
            if ((cl = StringSupport.preciseLength(enc, bytes, p2, end2)) > 0) {
                cr |= 0x20;
                p2 += cl;
            } else {
                cr = 48;
                ++p2;
            }
            ++c;
        }
        return StringSupport.pack(c, cr == 0 ? 16 : cr);
    }

    private static long strLengthWithCodeRangeNonAsciiCompatible(Encoding enc, byte[] bytes, int p2, int end2) {
        int cr = 0;
        int c = 0;
        c = 0;
        while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes, p2, end2);
            if (cl > 0) {
                cr |= 0x20;
                p2 += cl;
            } else {
                cr = 48;
                ++p2;
            }
            ++c;
        }
        return StringSupport.pack(c, cr == 0 ? 16 : cr);
    }

    public static long strLengthWithCodeRange(ByteList bytes) {
        return StringSupport.strLengthWithCodeRange(bytes.encoding, bytes.bytes, bytes.begin, bytes.begin + bytes.realSize);
    }

    static long pack(int result, int arg2) {
        return (long)arg2 << 31 | (long)result;
    }

    public static int unpackResult(long len) {
        return (int)len & Integer.MAX_VALUE;
    }

    public static int unpackArg(long cr) {
        return (int)(cr >>> 31);
    }

    public static int codePoint(Ruby runtime2, Encoding enc, byte[] bytes, int p2, int end2) {
        if (p2 >= end2) {
            throw runtime2.newArgumentError("empty string");
        }
        int cl = StringSupport.preciseLength(enc, bytes, p2, end2);
        if (cl <= 0) {
            throw runtime2.newArgumentError("invalid byte sequence in " + enc.getName());
        }
        return enc.mbcToCode(bytes, p2, end2);
    }

    public static int codeLength(Ruby runtime2, Encoding enc, int c) {
        int n = enc.codeToMbcLength(c);
        if (n == 0) {
            throw runtime2.newArgumentError("invalid codepoint " + String.format("0x%x in ", c) + enc.getName());
        }
        return n;
    }

    public long getAscii(Encoding enc, byte[] bytes, int p2, int end2) {
        return this.getAscii(enc, bytes, p2, end2, 0);
    }

    public long getAscii(Encoding enc, byte[] bytes, int p2, int end2, int len) {
        if (p2 >= end2) {
            return StringSupport.pack(-1, len);
        }
        if (enc.isAsciiCompatible()) {
            int c = bytes[p2] & 0xFF;
            if (!Encoding.isAscii(c)) {
                StringSupport.pack(-1, len);
            }
            return StringSupport.pack(c, len == 0 ? 0 : 1);
        }
        int cl = StringSupport.preciseLength(enc, bytes, p2, end2);
        if (cl <= 0) {
            return StringSupport.pack(-1, len);
        }
        int c = enc.mbcToCode(bytes, p2, end2);
        if (!Encoding.isAscii(c)) {
            return StringSupport.pack(-1, len);
        }
        return StringSupport.pack(c, len == 0 ? 0 : cl);
    }

    public static int nth(Encoding enc, byte[] bytes, int p2, int end2, int n) {
        p2 = enc.isSingleByte() ? (p2 += n) : (enc.isFixedWidth() ? (p2 += n * enc.maxLength()) : (enc.isAsciiCompatible() ? StringSupport.nthAsciiCompatible(enc, bytes, p2, end2, n) : StringSupport.nthNonAsciiCompatible(enc, bytes, p2, end2, n)));
        return p2 > end2 ? end2 : p2;
    }

    private static int nthAsciiCompatible(Encoding enc, byte[] bytes, int p2, int end2, int n) {
        while (p2 < end2 && n > 0) {
            int end22 = p2 + n;
            if (end2 < end22) {
                return end2;
            }
            if (Encoding.isAscii(bytes[p2])) {
                int p22 = StringSupport.searchNonAscii(bytes, p2, end22);
                if (p22 == -1) {
                    return end22;
                }
                n -= p22 - p2;
                p2 = p22;
            }
            int cl = StringSupport.length(enc, bytes, p2, end2);
            p2 += cl;
            --n;
        }
        return n != 0 ? end2 : p2;
    }

    private static int nthNonAsciiCompatible(Encoding enc, byte[] bytes, int p2, int end2, int n) {
        while (p2 < end2 && n-- != 0) {
            p2 += StringSupport.length(enc, bytes, p2, end2);
        }
        return p2;
    }
}

