/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubySocket;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

@JRubyClass(name={"TCPServer"}, parent="TCPSocket")
public class RubyTCPServer
extends RubyTCPSocket {
    private static ObjectAllocator TCPSERVER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyTCPServer(runtime2, klass);
        }
    };
    private ServerSocketChannel ssc;
    private InetSocketAddress socket_address;

    static void createTCPServer(Ruby runtime2) {
        RubyClass rb_cTCPServer = runtime2.defineClass("TCPServer", runtime2.fastGetClass("TCPSocket"), TCPSERVER_ALLOCATOR);
        rb_cTCPServer.defineAnnotatedMethods(RubyTCPServer.class);
        runtime2.getObject().fastSetConstant("TCPserver", rb_cTCPServer);
    }

    public RubyTCPServer(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, visibility=Visibility.PRIVATE, backtrace=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject port;
        IRubyObject hostname = args2[0];
        IRubyObject iRubyObject = port = args2.length > 1 ? args2[1] : context.getRuntime().getNil();
        if (hostname.isNil()) {
            hostname = context.getRuntime().newString("0.0.0.0");
        } else if (hostname instanceof RubyFixnum) {
            port = hostname;
            hostname = context.getRuntime().newString("0.0.0.0");
        }
        String shost = hostname.convertToString().toString();
        try {
            int portInt;
            InetAddress addr2 = InetAddress.getByName(shost);
            this.ssc = ServerSocketChannel.open();
            if (port instanceof RubyInteger) {
                portInt = RubyNumeric.fix2int(port);
            } else {
                RubyString portString = port.convertToString();
                RubyInteger portInteger = portString.convertToInteger("to_i");
                portInt = RubyNumeric.fix2int(portInteger);
                if (portInt <= 0) {
                    portInt = RubyNumeric.fix2int(RubySocket.getservbyname(context, context.getRuntime().getObject(), new IRubyObject[]{portString}));
                }
            }
            this.socket_address = new InetSocketAddress(addr2, portInt);
            this.ssc.socket().bind(this.socket_address);
            this.initSocket(context.getRuntime(), new ChannelDescriptor(this.ssc, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (UnknownHostException e) {
            throw RubyTCPServer.sockerr(context.getRuntime(), "initialize: name or service not known");
        }
        catch (BindException e) {
            throw context.getRuntime().newErrnoEADDRINUSEError();
        }
        catch (IOException e) {
            throw RubyTCPServer.sockerr(context.getRuntime(), "initialize: name or service not known");
        }
        catch (IllegalArgumentException iae) {
            throw RubyTCPServer.sockerr(context.getRuntime(), iae.getMessage());
        }
        return this;
    }

    @Deprecated
    public IRubyObject accept() {
        return this.accept(this.getRuntime().getCurrentContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"accept"})
    public IRubyObject accept(ThreadContext context) {
        RubyTCPSocket socket2 = new RubyTCPSocket(context.getRuntime(), context.getRuntime().fastGetClass("TCPSocket"));
        try {
            boolean ready2;
            while (!(ready2 = context.getThread().select(this, 16))) {
                context.pollThreadEvents();
            }
            try {
                SocketChannel connected = this.ssc.accept();
                connected.finishConnect();
                Object object = connected.blockingLock();
                synchronized (object) {
                    connected.configureBlocking(false);
                    connected.configureBlocking(true);
                }
                socket2.initSocket(context.getRuntime(), new ChannelDescriptor(connected, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
            }
            catch (InvalidValueException ex) {
                throw context.getRuntime().newErrnoEINVALError();
            }
            return socket2;
        }
        catch (IOException e) {
            throw RubyTCPServer.sockerr(context.getRuntime(), "problem when accepting");
        }
    }

    @Deprecated
    public IRubyObject accept_nonblock() {
        return this.accept_nonblock(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod(name={"accept_nonblock"})
    public IRubyObject accept_nonblock(ThreadContext context) {
        RubyTCPSocket socket2 = new RubyTCPSocket(context.getRuntime(), context.getRuntime().fastGetClass("TCPSocket"));
        Selector selector = null;
        try {
            this.ssc.configureBlocking(false);
            selector = Selector.open();
            SelectionKey key2 = this.ssc.register(selector, 16);
            int selected = selector.selectNow();
            if (selected == 0) {
                throw context.getRuntime().newErrnoEAGAINError("Resource temporarily unavailable");
            }
            try {
                socket2.initSocket(context.getRuntime(), new ChannelDescriptor(this.ssc.accept(), RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
            }
            catch (InvalidValueException ex) {
                throw context.getRuntime().newErrnoEINVALError();
            }
            RubyTCPSocket rubyTCPSocket = socket2;
            return rubyTCPSocket;
        }
        catch (IOException e) {
            throw RubyTCPServer.sockerr(context.getRuntime(), "problem when accepting");
        }
        finally {
            try {
                if (selector != null) {
                    selector.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    @Deprecated
    public IRubyObject listen(IRubyObject backlog) {
        return this.listen(this.getRuntime().getCurrentContext(), backlog);
    }

    @JRubyMethod(name={"listen"}, required=1)
    public IRubyObject listen(ThreadContext context, IRubyObject backlog) {
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(name={"peeraddr"}, rest=true)
    public IRubyObject peeraddr(ThreadContext context, IRubyObject[] args2) {
        throw context.getRuntime().newNotImplementedError("not supported");
    }

    @JRubyMethod(name={"getpeername"}, rest=true)
    public IRubyObject getpeername(ThreadContext context, IRubyObject[] args2) {
        throw context.getRuntime().newNotImplementedError("not supported");
    }

    @Deprecated
    public static IRubyObject open(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyTCPServer.open(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, rest=true, frame=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject tcpServer = recv2.callMethod(context, "new", args2);
        if (!block.isGiven()) {
            return tcpServer;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, tcpServer);
            return iRubyObject;
        }
        finally {
            tcpServer.callMethod(context, "close");
        }
    }
}

