/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SignalFacade;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SunSignalFacade
implements SignalFacade {
    public IRubyObject trap(final IRubyObject recv2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        SignalHandler oldHandler;
        final JRubySignalHandler handler = new JRubySignalHandler(recv2.getRuntime(), arg1, arg2, arg3.toString());
        try {
            oldHandler = Signal.handle(new Signal(handler.signal), handler);
        }
        catch (Exception e) {
            throw recv2.getRuntime().newArgumentError(e.getMessage());
        }
        if (oldHandler instanceof JRubySignalHandler) {
            return ((JRubySignalHandler)oldHandler).block;
        }
        return RubyProc.newProc(recv2.getRuntime(), CallBlock.newCallClosure(recv2, (RubyModule)recv2, Arity.noArguments(), new BlockCallback(){

            public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
                oldHandler.handle(new Signal(handler.signal));
                return recv2.getRuntime().getNil();
            }
        }, recv2.getRuntime().getCurrentContext()), Block.Type.NORMAL);
    }

    private static final class JRubySignalHandler
    implements SignalHandler {
        private final Ruby runtime;
        private final IRubyObject block;
        private final IRubyObject signal_object;
        private final String signal;

        public JRubySignalHandler(Ruby runtime2, IRubyObject block, IRubyObject signal_object, String signal2) {
            this.runtime = runtime2;
            this.block = block;
            this.signal_object = signal_object;
            this.signal = signal2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Signal signal2) {
            ThreadContext context = this.runtime.getCurrentContext();
            try {
                this.block.callMethod(context, "call");
            }
            catch (RaiseException e) {
                try {
                    this.runtime.getThread().callMethod(context, "main").callMethod(context, "raise", e.getException());
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            catch (MainExitException mee) {
                this.runtime.getThreadService().getMainThread().kill();
            }
            finally {
                Signal.handle(new Signal(this.signal), this);
            }
        }
    }
}

