/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.java.addons.ArrayJavaAddons;
import org.jruby.java.invokers.ConstructorInvoker;
import org.jruby.java.invokers.InstanceFieldGetter;
import org.jruby.java.invokers.InstanceFieldSetter;
import org.jruby.java.invokers.InstanceMethodInvoker;
import org.jruby.java.invokers.StaticFieldGetter;
import org.jruby.java.invokers.StaticFieldSetter;
import org.jruby.java.invokers.StaticMethodInvoker;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Java::JavaClass"}, parent="Java::JavaObject")
public class JavaClass
extends JavaObject {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Constructor[] EMPTY_CONSTRUCTOR_ARRAY = new Constructor[0];
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Map<String, AssignedName> RESERVED_NAMES = new HashMap<String, AssignedName>();
    private static final Map<String, AssignedName> STATIC_RESERVED_NAMES;
    private static final Map<String, AssignedName> INSTANCE_RESERVED_NAMES;
    private final RubyModule JAVA_UTILITIES = this.getRuntime().getJavaSupport().getJavaUtilitiesModule();
    private Map<String, AssignedName> staticAssignedNames;
    private Map<String, AssignedName> instanceAssignedNames;
    private Map<String, NamedInstaller> staticInstallers;
    private Map<String, NamedInstaller> instanceInstallers;
    private ConstructorInvokerInstaller constructorInstaller;
    private List<ConstantField> constantFields;
    private volatile RubyArray constructors;
    private volatile ArrayList<IRubyObject> proxyExtenders;
    private volatile RubyModule proxyModule;
    private volatile RubyClass proxyClass;
    private RubyModule unfinishedProxyModule;
    private RubyClass unfinishedProxyClass;
    private final ReentrantLock proxyLock = new ReentrantLock();
    private static final Callback __jsend_method;

    public RubyModule getProxyModule() {
        RubyModule proxy2 = this.proxyModule;
        if (proxy2 != null) {
            return proxy2;
        }
        if (this.proxyLock.isHeldByCurrentThread()) {
            return this.unfinishedProxyModule;
        }
        return null;
    }

    public RubyClass getProxyClass() {
        RubyClass proxy2 = this.proxyClass;
        if (proxy2 != null) {
            return proxy2;
        }
        if (this.proxyLock.isHeldByCurrentThread()) {
            return this.unfinishedProxyClass;
        }
        return null;
    }

    public void lockProxy() {
        this.proxyLock.lock();
    }

    public void unlockProxy() {
        this.proxyLock.unlock();
    }

    protected Map<String, AssignedName> getStaticAssignedNames() {
        return this.staticAssignedNames;
    }

    protected Map<String, AssignedName> getInstanceAssignedNames() {
        return this.instanceAssignedNames;
    }

    private JavaClass(Ruby runtime2, Class<?> javaClass) {
        super(runtime2, runtime2.getJavaSupport().getJavaClassClass(), javaClass);
        if (javaClass.isInterface()) {
            this.initializeInterface(javaClass);
        } else if (!javaClass.isArray() && !javaClass.isPrimitive()) {
            this.initializeClass(javaClass);
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaClass && this.getValue() == ((JavaClass)other).getValue();
    }

    private void initializeInterface(Class<?> javaClass) {
        HashMap<String, AssignedName> staticNames = new HashMap<String, AssignedName>(STATIC_RESERVED_NAMES);
        ArrayList<ConstantField> constantFields = new ArrayList<ConstantField>();
        HashMap<String, NamedInstaller> staticCallbacks = new HashMap<String, NamedInstaller>();
        Field[] fields2 = EMPTY_FIELD_ARRAY;
        try {
            fields2 = javaClass.getDeclaredFields();
        }
        catch (SecurityException e) {
            try {
                fields2 = javaClass.getFields();
            }
            catch (SecurityException e2) {
                // empty catch block
            }
        }
        int i = fields2.length;
        while (--i >= 0) {
            AssignedName assignedName;
            Field field2 = fields2[i];
            if (javaClass != field2.getDeclaringClass()) continue;
            if (ConstantField.isConstant(field2)) {
                constantFields.add(new ConstantField(field2));
            }
            String name2 = field2.getName();
            int modifiers2 = field2.getModifiers();
            if (!Modifier.isStatic(modifiers2) || (assignedName = (AssignedName)staticNames.get(name2)) != null && assignedName.type < 2) continue;
            staticNames.put(name2, new AssignedName(name2, 2));
            staticCallbacks.put(name2, new StaticFieldGetterInstaller(name2, field2));
            if (Modifier.isFinal(modifiers2)) continue;
            String setName = name2 + '=';
            staticCallbacks.put(setName, new StaticFieldSetterInstaller(setName, field2));
        }
        this.staticAssignedNames = staticNames;
        this.staticInstallers = staticCallbacks;
        this.constantFields = constantFields;
    }

    private void initializeClass(Class<?> javaClass) {
        AssignedName assignedName;
        HashMap<Object, Object> instanceNames;
        HashMap<Object, Object> staticNames;
        Class<?> superclass2 = javaClass.getSuperclass();
        if (superclass2 == null) {
            staticNames = new HashMap<String, AssignedName>();
            instanceNames = new HashMap<String, AssignedName>();
        } else {
            JavaClass superJavaClass = JavaClass.get(this.getRuntime(), superclass2);
            staticNames = new HashMap<String, AssignedName>(superJavaClass.getStaticAssignedNames());
            instanceNames = new HashMap<String, AssignedName>(superJavaClass.getInstanceAssignedNames());
        }
        staticNames.putAll(STATIC_RESERVED_NAMES);
        instanceNames.putAll(INSTANCE_RESERVED_NAMES);
        HashMap<String, NamedInstaller> staticCallbacks = new HashMap<String, NamedInstaller>();
        HashMap<String, NamedInstaller> instanceCallbacks = new HashMap<String, NamedInstaller>();
        ArrayList<ConstantField> constantFields = new ArrayList<ConstantField>();
        Field[] fields2 = EMPTY_FIELD_ARRAY;
        try {
            fields2 = javaClass.getFields();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        int i = fields2.length;
        while (--i >= 0) {
            String setName;
            Field field2 = fields2[i];
            if (javaClass != field2.getDeclaringClass()) continue;
            if (ConstantField.isConstant(field2)) {
                constantFields.add(new ConstantField(field2));
                continue;
            }
            String name2 = field2.getName();
            int modifiers2 = field2.getModifiers();
            if (Modifier.isStatic(modifiers2)) {
                assignedName = (AssignedName)staticNames.get(name2);
                if (assignedName != null && assignedName.type < 2) continue;
                staticNames.put(name2, new AssignedName(name2, 2));
                staticCallbacks.put(name2, new StaticFieldGetterInstaller(name2, field2));
                if (Modifier.isFinal(modifiers2)) continue;
                setName = name2 + '=';
                staticCallbacks.put(setName, new StaticFieldSetterInstaller(setName, field2));
                continue;
            }
            assignedName = (AssignedName)instanceNames.get(name2);
            if (assignedName != null && assignedName.type < 2) continue;
            instanceNames.put(name2, new AssignedName(name2, 2));
            instanceCallbacks.put(name2, new InstanceFieldGetterInstaller(name2, field2));
            if (Modifier.isFinal(modifiers2)) continue;
            setName = name2 + '=';
            instanceCallbacks.put(setName, new InstanceFieldSetterInstaller(setName, field2));
        }
        Method[] methods2 = EMPTY_METHOD_ARRAY;
        for (Class<?> c = javaClass; c != null; c = c.getSuperclass()) {
            try {
                methods2 = javaClass.getMethods();
                break;
            }
            catch (SecurityException e) {
                continue;
            }
        }
        int i2 = methods2.length;
        while (--i2 >= 0) {
            MethodInstaller invoker;
            Method method2 = methods2[i2];
            String name3 = method2.getName();
            if (Modifier.isStatic(method2.getModifiers())) {
                assignedName = (AssignedName)staticNames.get(name3);
                if (assignedName == null) {
                    staticNames.put(name3, new AssignedName(name3, 1));
                } else {
                    if (assignedName.type < 1) continue;
                    if (assignedName.type != 1) {
                        staticCallbacks.remove(name3);
                        staticCallbacks.remove(name3 + '=');
                        staticNames.put(name3, new AssignedName(name3, 1));
                    }
                }
                invoker = (StaticMethodInvokerInstaller)staticCallbacks.get(name3);
                if (invoker == null) {
                    invoker = new StaticMethodInvokerInstaller(name3);
                    staticCallbacks.put(name3, invoker);
                }
                invoker.addMethod(method2, javaClass);
                continue;
            }
            assignedName = (AssignedName)instanceNames.get(name3);
            if (assignedName == null) {
                instanceNames.put(name3, new AssignedName(name3, 1));
            } else {
                if (assignedName.type < 1) continue;
                if (assignedName.type != 1) {
                    instanceCallbacks.remove(name3);
                    instanceCallbacks.remove(name3 + '=');
                    instanceNames.put(name3, new AssignedName(name3, 1));
                }
            }
            invoker = (InstanceMethodInvokerInstaller)instanceCallbacks.get(name3);
            if (invoker == null) {
                invoker = new InstanceMethodInvokerInstaller(name3);
                instanceCallbacks.put(name3, invoker);
            }
            invoker.addMethod(method2, javaClass);
        }
        Constructor[] constructors2 = EMPTY_CONSTRUCTOR_ARRAY;
        try {
            constructors2 = javaClass.getConstructors();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        int i3 = constructors2.length;
        while (--i3 >= 0) {
            Constructor ctor = constructors2[i3];
            if (this.constructorInstaller == null) {
                this.constructorInstaller = new ConstructorInvokerInstaller("__jcreate!");
            }
            this.constructorInstaller.addConstructor(ctor, javaClass);
        }
        this.staticAssignedNames = staticNames;
        this.instanceAssignedNames = instanceNames;
        this.staticInstallers = staticCallbacks;
        this.instanceInstallers = instanceCallbacks;
        this.constantFields = constantFields;
    }

    public void setupProxy(RubyClass proxy2) {
        assert (this.proxyLock.isHeldByCurrentThread());
        proxy2.defineFastMethod("__jsend!", __jsend_method);
        Class javaClass = this.javaClass();
        if (javaClass.isInterface()) {
            this.setupInterfaceProxy(proxy2);
            return;
        }
        assert (this.proxyClass == null);
        this.unfinishedProxyClass = proxy2;
        if (javaClass.isArray() || javaClass.isPrimitive()) {
            this.proxyClass = proxy2;
            this.proxyModule = proxy2;
            return;
        }
        for (ConstantField field2 : this.constantFields) {
            field2.install(proxy2);
        }
        for (NamedInstaller installer : this.staticInstallers.values()) {
            if (installer.type == 2 && installer.hasLocalMethod()) {
                JavaClass.assignAliases((MethodInstaller)installer, this.staticAssignedNames);
            }
            installer.install(proxy2);
        }
        for (NamedInstaller installer : this.instanceInstallers.values()) {
            if (installer.type == 4 && installer.hasLocalMethod()) {
                JavaClass.assignAliases((MethodInstaller)installer, this.instanceAssignedNames);
            }
            installer.install(proxy2);
        }
        if (this.constructorInstaller != null) {
            this.constructorInstaller.install(proxy2);
        }
        Class<?>[] classes2 = EMPTY_CLASS_ARRAY;
        try {
            classes2 = javaClass.getClasses();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        int i = classes2.length;
        while (--i >= 0) {
            Class<?> clazz;
            String simpleName;
            if (javaClass != classes2[i].getDeclaringClass() || (simpleName = JavaClass.getSimpleName(clazz = classes2[i])).length() == 0 || !IdUtil.isConstant(simpleName) || proxy2.getConstantAt(simpleName) != null) continue;
            proxy2.setConstant(simpleName, Java.get_proxy_class(this.JAVA_UTILITIES, JavaClass.get(this.getRuntime(), clazz)));
        }
        this.proxyClass = proxy2;
        this.proxyModule = proxy2;
        this.applyProxyExtenders();
    }

    private static void assignAliases(MethodInstaller installer, Map<String, AssignedName> assignedNames) {
        String name2 = installer.name;
        String rubyCasedName = JavaUtil.getRubyCasedName(name2);
        JavaClass.addUnassignedAlias(rubyCasedName, assignedNames, installer);
        String javaPropertyName = JavaUtil.getJavaPropertyName(name2);
        String rubyPropertyName = null;
        for (Method method2 : installer.methods) {
            Class<?>[] argTypes = method2.getParameterTypes();
            Class<?> resultType = method2.getReturnType();
            int argCount = argTypes.length;
            if (javaPropertyName != null) {
                if (rubyCasedName.startsWith("get_")) {
                    rubyPropertyName = rubyCasedName.substring(4);
                    if (argCount == 0 || argCount == 1 && argTypes[0] == Integer.TYPE) {
                        JavaClass.addUnassignedAlias(javaPropertyName, assignedNames, installer);
                        JavaClass.addUnassignedAlias(rubyPropertyName, assignedNames, installer);
                    }
                } else if (rubyCasedName.startsWith("set_")) {
                    rubyPropertyName = rubyCasedName.substring(4);
                    if (argCount == 1 && resultType == Void.TYPE) {
                        JavaClass.addUnassignedAlias(javaPropertyName + '=', assignedNames, installer);
                        JavaClass.addUnassignedAlias(rubyPropertyName + '=', assignedNames, installer);
                    }
                } else if (rubyCasedName.startsWith("is_")) {
                    rubyPropertyName = rubyCasedName.substring(3);
                    if (resultType == Boolean.TYPE) {
                        JavaClass.addUnassignedAlias(javaPropertyName, assignedNames, installer);
                        JavaClass.addUnassignedAlias(rubyPropertyName, assignedNames, installer);
                    }
                }
            }
            if (resultType != Boolean.TYPE) continue;
            JavaClass.addUnassignedAlias(rubyCasedName + '?', assignedNames, installer);
            if (rubyPropertyName == null) continue;
            JavaClass.addUnassignedAlias(rubyPropertyName + '?', assignedNames, installer);
        }
    }

    private static void addUnassignedAlias(String name2, Map<String, AssignedName> assignedNames, MethodInstaller installer) {
        if (name2 != null) {
            AssignedName assignedName = assignedNames.get(name2);
            if (assignedName == null) {
                installer.addAlias(name2);
                assignedNames.put(name2, new AssignedName(name2, 5));
            } else if (assignedName.type == 5) {
                installer.addAlias(name2);
            } else if (assignedName.type > 5) {
                installer.addAlias(name2);
                assignedNames.put(name2, new AssignedName(name2, 5));
            }
        }
    }

    private void setupInterfaceProxy(RubyClass proxy2) {
        assert (this.javaClass().isInterface());
        assert (this.proxyLock.isHeldByCurrentThread());
        assert (this.proxyClass == null);
        this.proxyClass = proxy2;
    }

    public void setupInterfaceModule(RubyModule module) {
        assert (this.javaClass().isInterface());
        assert (this.proxyLock.isHeldByCurrentThread());
        assert (this.proxyModule == null);
        this.unfinishedProxyModule = module;
        Class javaClass = this.javaClass();
        for (ConstantField field2 : this.constantFields) {
            field2.install(module);
        }
        for (NamedInstaller installer : this.staticInstallers.values()) {
            if (installer.type == 2 && installer.hasLocalMethod()) {
                JavaClass.assignAliases((MethodInstaller)installer, this.staticAssignedNames);
            }
            installer.install(module);
        }
        Class<?>[] classes2 = EMPTY_CLASS_ARRAY;
        try {
            classes2 = javaClass.getClasses();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        int i = classes2.length;
        while (--i >= 0) {
            Class<?> clazz;
            String simpleName;
            if (javaClass != classes2[i].getDeclaringClass() || (simpleName = JavaClass.getSimpleName(clazz = classes2[i])).length() == 0 || !IdUtil.isConstant(simpleName) || module.getConstantAt(simpleName) != null) continue;
            module.const_set(this.getRuntime().newString(simpleName), Java.get_proxy_class(this.JAVA_UTILITIES, JavaClass.get(this.getRuntime(), clazz)));
        }
        this.proxyModule = module;
        this.applyProxyExtenders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyExtender(IRubyObject extender) {
        this.lockProxy();
        try {
            if (!extender.respondsTo("extend_proxy")) {
                throw this.getRuntime().newTypeError("proxy extender must have an extend_proxy method");
            }
            if (this.proxyModule == null) {
                if (this.proxyExtenders == null) {
                    this.proxyExtenders = new ArrayList();
                }
                this.proxyExtenders.add(extender);
            } else {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.PROXY_EXTENDED_LATE, " proxy extender added after proxy class created for " + this, new Object[0]);
                this.extendProxy(extender);
            }
        }
        finally {
            this.unlockProxy();
        }
    }

    private void applyProxyExtenders() {
        ArrayList<IRubyObject> extenders = this.proxyExtenders;
        if (extenders != null) {
            for (IRubyObject extender : extenders) {
                this.extendProxy(extender);
            }
            this.proxyExtenders = null;
        }
    }

    private void extendProxy(IRubyObject extender) {
        extender.callMethod(this.getRuntime().getCurrentContext(), "extend_proxy", this.proxyModule);
    }

    @JRubyMethod(required=1)
    public IRubyObject extend_proxy(IRubyObject extender) {
        this.addProxyExtender(extender);
        return this.getRuntime().getNil();
    }

    public static JavaClass get(Ruby runtime2, Class<?> klass) {
        JavaClass javaClass = runtime2.getJavaSupport().getJavaClassFromCache(klass);
        if (javaClass == null) {
            javaClass = JavaClass.createJavaClass(runtime2, klass);
        }
        return javaClass;
    }

    public static RubyArray getRubyArray(Ruby runtime2, Class<?>[] classes2) {
        IRubyObject[] javaClasses = new IRubyObject[classes2.length];
        int i = classes2.length;
        while (--i >= 0) {
            javaClasses[i] = JavaClass.get(runtime2, classes2[i]);
        }
        return runtime2.newArrayNoCopy(javaClasses);
    }

    private static synchronized JavaClass createJavaClass(Ruby runtime2, Class<?> klass) {
        JavaClass javaClass = runtime2.getJavaSupport().getJavaClassFromCache(klass);
        if (javaClass == null) {
            javaClass = new JavaClass(runtime2, klass);
            runtime2.getJavaSupport().putJavaClassIntoCache(javaClass);
        }
        return javaClass;
    }

    public static RubyClass createJavaClassClass(Ruby runtime2, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaClass", javaModule.fastGetClass("JavaObject"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.includeModule(runtime2.fastGetModule("Comparable"));
        result.defineAnnotatedMethods(JavaClass.class);
        result.getMetaClass().undefineMethod("new");
        result.getMetaClass().undefineMethod("allocate");
        return result;
    }

    public static synchronized JavaClass forNameVerbose(Ruby runtime2, String className) {
        Class klass = runtime2.getJavaSupport().loadJavaClassVerbose(className);
        return JavaClass.get(runtime2, klass);
    }

    public static synchronized JavaClass forNameQuiet(Ruby runtime2, String className) {
        Class klass = runtime2.getJavaSupport().loadJavaClassQuiet(className);
        return JavaClass.get(runtime2, klass);
    }

    @JRubyMethod(name={"for_name"}, required=1, meta=true)
    public static JavaClass for_name(IRubyObject recv2, IRubyObject name2) {
        return JavaClass.forNameVerbose(recv2.getRuntime(), name2.asJavaString());
    }

    @JRubyMethod
    public RubyModule ruby_class() {
        return Java.getProxyClass(this.getRuntime(), this);
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"protected?"})
    public RubyBoolean protected_p() {
        return this.getRuntime().newBoolean(Modifier.isProtected(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"private?"})
    public RubyBoolean private_p() {
        return this.getRuntime().newBoolean(Modifier.isPrivate(this.javaClass().getModifiers()));
    }

    public Class javaClass() {
        return (Class)this.getValue();
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"interface?"})
    public RubyBoolean interface_p() {
        return this.getRuntime().newBoolean(this.javaClass().isInterface());
    }

    @JRubyMethod(name={"array?"})
    public RubyBoolean array_p() {
        return this.getRuntime().newBoolean(this.javaClass().isArray());
    }

    @JRubyMethod(name={"enum?"})
    public RubyBoolean enum_p() {
        return this.getRuntime().newBoolean(this.javaClass().isEnum());
    }

    @JRubyMethod(name={"annotation?"})
    public RubyBoolean annotation_p() {
        return this.getRuntime().newBoolean(this.javaClass().isAnnotation());
    }

    @JRubyMethod(name={"anonymous_class?"})
    public RubyBoolean anonymous_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isAnonymousClass());
    }

    @JRubyMethod(name={"local_class?"})
    public RubyBoolean local_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isLocalClass());
    }

    @JRubyMethod(name={"member_class?"})
    public RubyBoolean member_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isMemberClass());
    }

    @JRubyMethod(name={"synthetic?"})
    public IRubyObject synthetic_p() {
        return this.getRuntime().newBoolean(this.javaClass().isSynthetic());
    }

    @JRubyMethod(name={"name", "to_s"})
    public RubyString name() {
        return this.getRuntime().newString(this.javaClass().getName());
    }

    @JRubyMethod
    public IRubyObject canonical_name() {
        String canonicalName = this.javaClass().getCanonicalName();
        if (canonicalName != null) {
            return this.getRuntime().newString(canonicalName);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"package"})
    public IRubyObject get_package() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getPackage());
    }

    @JRubyMethod
    public IRubyObject class_loader() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getClassLoader());
    }

    @JRubyMethod
    public IRubyObject protection_domain() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getProtectionDomain());
    }

    @JRubyMethod(required=1)
    public IRubyObject resource(IRubyObject name2) {
        return Java.getInstance(this.getRuntime(), this.javaClass().getResource(name2.asJavaString()));
    }

    @JRubyMethod(required=1)
    public IRubyObject resource_as_stream(IRubyObject name2) {
        return Java.getInstance(this.getRuntime(), this.javaClass().getResourceAsStream(name2.asJavaString()));
    }

    @JRubyMethod(required=1)
    public IRubyObject resource_as_string(IRubyObject name2) {
        InputStream in = this.javaClass().getResourceAsStream(name2.asJavaString());
        if (in == null) {
            return this.getRuntime().getNil();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        return this.getRuntime().newString(new ByteList(out.toByteArray(), false));
    }

    @JRubyMethod(required=1)
    public IRubyObject annotation(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return Java.getInstance(this.getRuntime(), this.javaClass().getAnnotation(((JavaClass)annoClass).javaClass()));
    }

    @JRubyMethod
    public IRubyObject annotations() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getAnnotations());
    }

    @JRubyMethod(name={"annotations?"})
    public RubyBoolean annotations_p() {
        return this.getRuntime().newBoolean(this.javaClass().getAnnotations().length > 0);
    }

    @JRubyMethod
    public IRubyObject declared_annotations() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getDeclaredAnnotations());
    }

    @JRubyMethod(name={"declared_annotations?"})
    public RubyBoolean declared_annotations_p() {
        return this.getRuntime().newBoolean(this.javaClass().getDeclaredAnnotations().length > 0);
    }

    @JRubyMethod(name={"annotation_present?"}, required=1)
    public IRubyObject annotation_present_p(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return this.getRuntime().newBoolean(this.javaClass().isAnnotationPresent(((JavaClass)annoClass).javaClass()));
    }

    @JRubyMethod
    public IRubyObject modifiers() {
        return this.getRuntime().newFixnum(this.javaClass().getModifiers());
    }

    @JRubyMethod
    public IRubyObject declaring_class() {
        Class<?> clazz = this.javaClass().getDeclaringClass();
        if (clazz != null) {
            return JavaClass.get(this.getRuntime(), clazz);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enclosing_class() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getEnclosingClass());
    }

    @JRubyMethod
    public IRubyObject enclosing_constructor() {
        Constructor<?> ctor = this.javaClass().getEnclosingConstructor();
        if (ctor != null) {
            return new JavaConstructor(this.getRuntime(), ctor);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enclosing_method() {
        Method meth = this.javaClass().getEnclosingMethod();
        if (meth != null) {
            return new JavaMethod(this.getRuntime(), meth);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enum_constants() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getEnumConstants());
    }

    @JRubyMethod
    public IRubyObject generic_interfaces() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getGenericInterfaces());
    }

    @JRubyMethod
    public IRubyObject generic_superclass() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getGenericSuperclass());
    }

    @JRubyMethod
    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getTypeParameters());
    }

    @JRubyMethod
    public IRubyObject signers() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getSigners());
    }

    private static String getSimpleName(Class<?> clazz) {
        if (clazz.isArray()) {
            return JavaClass.getSimpleName(clazz.getComponentType()) + "[]";
        }
        String className = clazz.getName();
        int len = className.length();
        int i = className.lastIndexOf(36);
        if (i != -1) {
            while (++i < len && Character.isDigit(className.charAt(i))) {
            }
            return className.substring(i);
        }
        return className.substring(className.lastIndexOf(46) + 1);
    }

    @JRubyMethod
    public RubyString simple_name() {
        return this.getRuntime().newString(JavaClass.getSimpleName(this.javaClass()));
    }

    @JRubyMethod
    public IRubyObject superclass() {
        Class superclass2 = this.javaClass().getSuperclass();
        if (superclass2 == null) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), superclass2);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public RubyFixnum op_cmp(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("<=> requires JavaClass (" + other.getType() + " given)");
        }
        JavaClass otherClass = (JavaClass)other;
        if (this.javaClass() == otherClass.javaClass()) {
            return this.getRuntime().newFixnum(0);
        }
        if (otherClass.javaClass().isAssignableFrom(this.javaClass())) {
            return this.getRuntime().newFixnum(-1);
        }
        return this.getRuntime().newFixnum(1);
    }

    @JRubyMethod
    public RubyArray java_instance_methods() {
        return this.java_methods(this.javaClass().getMethods(), false);
    }

    @JRubyMethod
    public RubyArray declared_instance_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), false);
    }

    private RubyArray java_methods(Method[] methods2, boolean isStatic) {
        RubyArray result = this.getRuntime().newArray(methods2.length);
        for (int i = 0; i < methods2.length; ++i) {
            Method method2 = methods2[i];
            if (isStatic != Modifier.isStatic(method2.getModifiers())) continue;
            result.append(JavaMethod.create(this.getRuntime(), method2));
        }
        return result;
    }

    @JRubyMethod
    public RubyArray java_class_methods() {
        return this.java_methods(this.javaClass().getMethods(), true);
    }

    @JRubyMethod
    public RubyArray declared_class_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), true);
    }

    @JRubyMethod(required=1, rest=true)
    public JavaMethod java_method(IRubyObject[] args2) throws ClassNotFoundException {
        String methodName = args2[0].asJavaString();
        Class<?>[] argumentTypes = this.buildArgumentTypes(args2);
        return JavaMethod.create(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
    }

    @JRubyMethod(required=1, rest=true)
    public JavaMethod declared_method(IRubyObject[] args2) throws ClassNotFoundException {
        String methodName = args2[0].asJavaString();
        Class<?>[] argumentTypes = this.buildArgumentTypes(args2);
        return JavaMethod.createDeclared(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
    }

    @JRubyMethod(required=1, rest=true)
    public JavaCallable declared_method_smart(IRubyObject[] args2) throws ClassNotFoundException {
        String methodName = args2[0].asJavaString();
        Class<?>[] argumentTypes = this.buildArgumentTypes(args2);
        JavaCallable callable = JavaClass.getMatchingCallable(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
        if (callable != null) {
            return callable;
        }
        throw this.getRuntime().newNameError("undefined method '" + methodName + "' for class '" + this.javaClass().getName() + "'", methodName);
    }

    public static JavaCallable getMatchingCallable(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        if ("<init>".equals(methodName)) {
            return JavaConstructor.getMatchingConstructor(runtime2, javaClass, argumentTypes);
        }
        return JavaMethod.getMatchingDeclaredMethod(runtime2, javaClass, methodName, argumentTypes);
    }

    private Class<?>[] buildArgumentTypes(IRubyObject[] args2) throws ClassNotFoundException {
        if (args2.length < 1) {
            throw this.getRuntime().newArgumentError(args2.length, 1);
        }
        Class[] argumentTypes = new Class[args2.length - 1];
        for (int i = 1; i < args2.length; ++i) {
            JavaClass type2 = args2[i] instanceof JavaClass ? (JavaClass)args2[i] : (args2[i].respondsTo("java_class") ? (JavaClass)args2[i].callMethod(this.getRuntime().getCurrentContext(), "java_class") : JavaClass.for_name(this, args2[i]));
            argumentTypes[i - 1] = type2.javaClass();
        }
        return argumentTypes;
    }

    @JRubyMethod
    public RubyArray constructors() {
        RubyArray ctors = this.constructors;
        if (ctors != null) {
            return ctors;
        }
        this.constructors = this.buildConstructors(this.javaClass().getConstructors());
        return this.constructors;
    }

    @JRubyMethod
    public RubyArray classes() {
        return JavaClass.getRubyArray(this.getRuntime(), this.javaClass().getClasses());
    }

    @JRubyMethod
    public RubyArray declared_classes() {
        Ruby runtime2 = this.getRuntime();
        RubyArray result = runtime2.newArray();
        Class javaClass = this.javaClass();
        try {
            Class<?>[] classes2 = javaClass.getDeclaredClasses();
            for (int i = 0; i < classes2.length; ++i) {
                if (!Modifier.isPublic(classes2[i].getModifiers())) continue;
                result.append(JavaClass.get(runtime2, classes2[i]));
            }
        }
        catch (SecurityException e) {
            try {
                Class<?>[] classes3 = javaClass.getClasses();
                for (int i = 0; i < classes3.length; ++i) {
                    if (javaClass != classes3[i].getDeclaringClass()) continue;
                    result.append(JavaClass.get(runtime2, classes3[i]));
                }
            }
            catch (SecurityException e2) {
                // empty catch block
            }
        }
        return result;
    }

    @JRubyMethod
    public RubyArray declared_constructors() {
        return this.buildConstructors(this.javaClass().getDeclaredConstructors());
    }

    private RubyArray buildConstructors(Constructor<?>[] constructors2) {
        RubyArray result = this.getRuntime().newArray(constructors2.length);
        for (int i = 0; i < constructors2.length; ++i) {
            result.append(new JavaConstructor(this.getRuntime(), constructors2[i]));
        }
        return result;
    }

    @JRubyMethod(rest=true)
    public JavaConstructor constructor(IRubyObject[] args2) {
        try {
            Class<?>[] parameterTypes = this.buildClassArgs(args2);
            Constructor constructor2 = this.javaClass().getConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor2);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    @JRubyMethod(rest=true)
    public JavaConstructor declared_constructor(IRubyObject[] args2) {
        try {
            Class<?>[] parameterTypes = this.buildClassArgs(args2);
            Constructor constructor2 = this.javaClass().getDeclaredConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor2);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    private Class<?>[] buildClassArgs(IRubyObject[] args2) {
        JavaSupport javaSupport = this.getRuntime().getJavaSupport();
        Class[] parameterTypes = new Class[args2.length];
        int i = args2.length;
        while (--i >= 0) {
            String name2 = args2[i].asJavaString();
            parameterTypes[i] = javaSupport.loadJavaClassVerbose(name2);
        }
        return parameterTypes;
    }

    @JRubyMethod
    public JavaClass array_class() {
        return JavaClass.get(this.getRuntime(), Array.newInstance(this.javaClass(), 0).getClass());
    }

    @JRubyMethod(required=1)
    public JavaObject new_array(IRubyObject lengthArgument) {
        if (lengthArgument instanceof RubyInteger) {
            int length2 = (int)((RubyInteger)lengthArgument).getLongValue();
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), length2));
        }
        if (lengthArgument instanceof RubyArray) {
            List list2 = ((RubyArray)lengthArgument).getList();
            int length3 = list2.size();
            if (length3 == 0) {
                throw this.getRuntime().newArgumentError("empty dimensions specifier for java array");
            }
            int[] dimensions2 = new int[length3];
            int i = length3;
            while (--i >= 0) {
                IRubyObject dimensionLength = (IRubyObject)list2.get(i);
                if (!(dimensionLength instanceof RubyInteger)) {
                    throw this.getRuntime().newTypeError(dimensionLength, this.getRuntime().getInteger());
                }
                dimensions2[i] = (int)((RubyInteger)dimensionLength).getLongValue();
            }
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), dimensions2));
        }
        throw this.getRuntime().newArgumentError("invalid length or dimensions specifier for java array - must be Integer or Array of Integer");
    }

    public IRubyObject emptyJavaArray(ThreadContext context) {
        JavaArray javaArray = new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), 0));
        RubyClass proxyClass = (RubyClass)Java.get_proxy_class(javaArray, this.array_class());
        ArrayJavaProxy proxy2 = new ArrayJavaProxy(context.getRuntime(), proxyClass);
        proxy2.dataWrapStruct(javaArray);
        return proxy2;
    }

    public IRubyObject javaArraySubarray(ThreadContext context, JavaArray fromArray, int index2, int size2) {
        int actualLength = Array.getLength(fromArray.getValue());
        if (index2 >= actualLength) {
            return context.getRuntime().getNil();
        }
        if (index2 + size2 > actualLength) {
            size2 = actualLength - index2;
        }
        Object newArray = Array.newInstance(this.javaClass(), size2);
        JavaArray javaArray = new JavaArray(this.getRuntime(), newArray);
        System.arraycopy(fromArray.getValue(), index2, newArray, 0, size2);
        RubyClass proxyClass = (RubyClass)Java.get_proxy_class(javaArray, this.array_class());
        ArrayJavaProxy proxy2 = new ArrayJavaProxy(context.getRuntime(), proxyClass);
        proxy2.dataWrapStruct(javaArray);
        return proxy2;
    }

    public IRubyObject concatArrays(ThreadContext context, JavaArray original, JavaArray additional) {
        int oldLength = (int)original.length().getLongValue();
        int addLength = (int)additional.length().getLongValue();
        Object newArray = Array.newInstance(this.javaClass(), oldLength + addLength);
        JavaArray javaArray = new JavaArray(this.getRuntime(), newArray);
        System.arraycopy(original.getValue(), 0, newArray, 0, oldLength);
        System.arraycopy(additional.getValue(), 0, newArray, oldLength, addLength);
        RubyClass proxyClass = (RubyClass)Java.get_proxy_class(javaArray, this.array_class());
        ArrayJavaProxy proxy2 = new ArrayJavaProxy(context.getRuntime(), proxyClass);
        proxy2.dataWrapStruct(javaArray);
        return proxy2;
    }

    public IRubyObject concatArrays(ThreadContext context, JavaArray original, IRubyObject additional) {
        int oldLength = (int)original.length().getLongValue();
        int addLength = (int)((RubyFixnum)RuntimeHelpers.invoke(context, additional, "length")).getLongValue();
        Object newArray = Array.newInstance(this.javaClass(), oldLength + addLength);
        JavaArray javaArray = new JavaArray(this.getRuntime(), newArray);
        System.arraycopy(original.getValue(), 0, newArray, 0, oldLength);
        RubyClass proxyClass = (RubyClass)Java.get_proxy_class(javaArray, this.array_class());
        ArrayJavaProxy proxy2 = new ArrayJavaProxy(context.getRuntime(), proxyClass);
        proxy2.dataWrapStruct(javaArray);
        Ruby runtime2 = context.getRuntime();
        for (int i = 0; i < addLength; ++i) {
            RuntimeHelpers.invoke(context, (IRubyObject)proxy2, "[]=", (IRubyObject)runtime2.newFixnum(oldLength + i), RuntimeHelpers.invoke(context, additional, "[]", runtime2.newFixnum(i)));
        }
        return proxy2;
    }

    public IRubyObject javaArrayFromRubyArray(ThreadContext context, IRubyObject fromArray) {
        Ruby runtime2 = context.getRuntime();
        if (!(fromArray instanceof RubyArray)) {
            throw runtime2.newTypeError(fromArray, runtime2.getArray());
        }
        RubyArray rubyArray = (RubyArray)fromArray;
        JavaArray javaArray = new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), rubyArray.size()));
        if (this.javaClass().isArray()) {
            for (int i = 0; i < rubyArray.size(); ++i) {
                JavaClass componentType = this.component_type();
                IRubyObject wrappedComponentArray = componentType.javaArrayFromRubyArray(context, rubyArray.eltInternal(i));
                javaArray.setWithExceptionHandling(i, JavaUtil.unwrapJavaObject(wrappedComponentArray));
            }
        } else {
            ArrayJavaAddons.copyDataToJavaArray(context, rubyArray, javaArray);
        }
        RubyClass proxyClass = (RubyClass)Java.get_proxy_class(javaArray, this.array_class());
        ArrayJavaProxy proxy2 = new ArrayJavaProxy(runtime2, proxyClass);
        proxy2.dataWrapStruct(javaArray);
        return proxy2;
    }

    @JRubyMethod
    public RubyArray fields() {
        return this.buildFieldResults(this.javaClass().getFields());
    }

    @JRubyMethod
    public RubyArray declared_fields() {
        return this.buildFieldResults(this.javaClass().getDeclaredFields());
    }

    private RubyArray buildFieldResults(Field[] fields2) {
        RubyArray result = this.getRuntime().newArray(fields2.length);
        for (int i = 0; i < fields2.length; ++i) {
            result.append(new JavaField(this.getRuntime(), fields2[i]));
        }
        return result;
    }

    @JRubyMethod(required=1)
    public JavaField field(IRubyObject name2) {
        String stringName = name2.asJavaString();
        Field field2 = null;
        try {
            field2 = this.javaClass().getField(stringName);
            return new JavaField(this.getRuntime(), field2);
        }
        catch (NoSuchFieldException nsfe) {
            String newName = JavaUtil.getJavaCasedName(stringName);
            if (newName != null) {
                try {
                    field2 = this.javaClass().getField(newName);
                    return new JavaField(this.getRuntime(), field2);
                }
                catch (NoSuchFieldException nsfe2) {
                    // empty catch block
                }
            }
            throw this.undefinedFieldError(stringName);
        }
    }

    @JRubyMethod(required=1)
    public JavaField declared_field(IRubyObject name2) {
        String stringName = name2.asJavaString();
        Field field2 = null;
        try {
            field2 = this.javaClass().getDeclaredField(stringName);
            return new JavaField(this.getRuntime(), field2);
        }
        catch (NoSuchFieldException nsfe) {
            String newName = JavaUtil.getJavaCasedName(stringName);
            if (newName != null) {
                try {
                    field2 = this.javaClass().getDeclaredField(newName);
                    return new JavaField(this.getRuntime(), field2);
                }
                catch (NoSuchFieldException nsfe2) {
                    // empty catch block
                }
            }
            throw this.undefinedFieldError(stringName);
        }
    }

    private RaiseException undefinedFieldError(String name2) {
        return this.getRuntime().newNameError("undefined field '" + name2 + "' for class '" + this.javaClass().getName() + "'", name2);
    }

    @JRubyMethod
    public RubyArray interfaces() {
        return JavaClass.getRubyArray(this.getRuntime(), this.javaClass().getInterfaces());
    }

    @JRubyMethod(name={"primitive?"})
    public RubyBoolean primitive_p() {
        return this.getRuntime().newBoolean(this.isPrimitive());
    }

    @JRubyMethod(name={"assignable_from?"}, required=1)
    public RubyBoolean assignable_from_p(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("assignable_from requires JavaClass (" + other.getType() + " given)");
        }
        Class otherClass = ((JavaClass)other).javaClass();
        return JavaClass.assignable(this.javaClass(), otherClass) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    static boolean assignable(Class<?> thisClass, Class<?> otherClass) {
        if (!thisClass.isPrimitive() && otherClass == Void.TYPE || thisClass.isAssignableFrom(otherClass)) {
            return true;
        }
        otherClass = JavaUtil.primitiveToWrapper(otherClass);
        if ((thisClass = JavaUtil.primitiveToWrapper(thisClass)).isAssignableFrom(otherClass)) {
            return true;
        }
        if (Number.class.isAssignableFrom(thisClass)) {
            if (Number.class.isAssignableFrom(otherClass)) {
                return true;
            }
            if (otherClass.equals(Character.class)) {
                return true;
            }
        }
        return thisClass.equals(Character.class) && Number.class.isAssignableFrom(otherClass);
    }

    private boolean isPrimitive() {
        return this.javaClass().isPrimitive();
    }

    @JRubyMethod
    public JavaClass component_type() {
        if (!this.javaClass().isArray()) {
            throw this.getRuntime().newTypeError("not a java array-class");
        }
        return JavaClass.get(this.getRuntime(), this.javaClass().getComponentType());
    }

    static {
        RESERVED_NAMES.put("__id__", new AssignedName("__id__", 0));
        RESERVED_NAMES.put("__send__", new AssignedName("__send__", 0));
        RESERVED_NAMES.put("class", new AssignedName("class", 0));
        RESERVED_NAMES.put("initialize", new AssignedName("initialize", 0));
        RESERVED_NAMES.put("object_id", new AssignedName("object_id", 0));
        RESERVED_NAMES.put("private", new AssignedName("private", 0));
        RESERVED_NAMES.put("protected", new AssignedName("protected", 0));
        RESERVED_NAMES.put("public", new AssignedName("public", 0));
        RESERVED_NAMES.put("id", new AssignedName("id", 4));
        STATIC_RESERVED_NAMES = new HashMap<String, AssignedName>(RESERVED_NAMES);
        STATIC_RESERVED_NAMES.put("new", new AssignedName("new", 0));
        INSTANCE_RESERVED_NAMES = new HashMap<String, AssignedName>(RESERVED_NAMES);
        __jsend_method = new Callback(){

            public IRubyObject execute(IRubyObject self, IRubyObject[] args2, Block block) {
                String name2 = args2[0].asJavaString();
                DynamicMethod method2 = self.getMetaClass().searchMethod(name2);
                int v = method2.getArity().getValue();
                IRubyObject[] newArgs = new IRubyObject[args2.length - 1];
                System.arraycopy(args2, 1, newArgs, 0, newArgs.length);
                if (v < 0 || v == newArgs.length) {
                    return RuntimeHelpers.invoke(self.getRuntime().getCurrentContext(), self, name2, newArgs, block);
                }
                RubyClass superClass = self.getMetaClass().getSuperClass();
                return RuntimeHelpers.invokeAs(self.getRuntime().getCurrentContext(), superClass, self, name2, newArgs, CallType.SUPER, block);
            }

            public Arity getArity() {
                return Arity.optional();
            }
        };
    }

    private static class ConstantField {
        static final int CONSTANT = 25;
        final Field field;

        ConstantField(Field field2) {
            this.field = field2;
        }

        void install(RubyModule proxy2) {
            if (proxy2.fastGetConstantAt(this.field.getName()) == null) {
                if (!Ruby.isSecurityRestricted()) {
                    this.field.setAccessible(true);
                }
                try {
                    proxy2.setConstant(this.field.getName(), JavaUtil.convertJavaToUsableRubyObject(proxy2.getRuntime(), this.field.get(null)));
                }
                catch (IllegalAccessException iae) {
                    throw proxy2.getRuntime().newTypeError("illegal access on setting variable: " + iae.getMessage());
                }
            }
        }

        static boolean isConstant(Field field2) {
            return (field2.getModifiers() & 0x19) == 25 && Character.isUpperCase(field2.getName().charAt(0));
        }
    }

    private static class InstanceMethodInvokerInstaller
    extends MethodInstaller {
        InstanceMethodInvokerInstaller(String name2) {
            super(name2, 4);
        }

        void install(RubyModule proxy2) {
            if (this.hasLocalMethod()) {
                InstanceMethodInvoker method2 = new InstanceMethodInvoker(proxy2, this.methods);
                proxy2.addMethod(this.name, method2);
                if (this.aliases != null && this.isPublic()) {
                    proxy2.defineAliases(this.aliases, this.name);
                    this.aliases = null;
                }
            }
        }
    }

    private static class StaticMethodInvokerInstaller
    extends MethodInstaller {
        StaticMethodInvokerInstaller(String name2) {
            super(name2, 2);
        }

        void install(RubyModule proxy2) {
            if (this.hasLocalMethod()) {
                RubyClass singleton = proxy2.getSingletonClass();
                StaticMethodInvoker method2 = new StaticMethodInvoker(singleton, (List<Method>)this.methods);
                singleton.addMethod(this.name, method2);
                if (this.aliases != null && this.isPublic()) {
                    singleton.defineAliases(this.aliases, this.name);
                    this.aliases = null;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorInvokerInstaller
    extends MethodInstaller {
        private boolean haveLocalConstructor;
        protected List<Constructor> constructors;

        ConstructorInvokerInstaller(String name2) {
            super(name2, 2);
        }

        void addConstructor(Constructor ctor, Class<?> javaClass) {
            if (this.constructors == null) {
                this.constructors = new ArrayList<Constructor>();
            }
            if (!Ruby.isSecurityRestricted()) {
                ctor.setAccessible(true);
            }
            this.constructors.add(ctor);
            this.haveLocalConstructor |= javaClass == ctor.getDeclaringClass();
        }

        @Override
        void install(RubyModule proxy2) {
            if (this.haveLocalConstructor) {
                ConstructorInvoker method2 = new ConstructorInvoker(proxy2, this.constructors);
                proxy2.addMethod(this.name, method2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MethodInstaller
    extends NamedInstaller {
        private boolean haveLocalMethod;
        protected List<Method> methods;
        protected List<String> aliases;

        MethodInstaller() {
        }

        MethodInstaller(String name2, int type2) {
            super(name2, type2);
        }

        void addMethod(Method method2, Class<?> javaClass) {
            if (this.methods == null) {
                this.methods = new ArrayList<Method>();
            }
            if (!Ruby.isSecurityRestricted()) {
                method2.setAccessible(true);
            }
            this.methods.add(method2);
            this.haveLocalMethod |= javaClass == method2.getDeclaringClass();
        }

        void addAlias(String alias) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            if (!this.aliases.contains(alias)) {
                this.aliases.add(alias);
            }
        }

        @Override
        boolean hasLocalMethod() {
            return this.haveLocalMethod;
        }
    }

    private static class InstanceFieldSetterInstaller
    extends FieldInstaller {
        InstanceFieldSetterInstaller() {
        }

        InstanceFieldSetterInstaller(String name2, Field field2) {
            super(name2, 3, field2);
        }

        void install(RubyModule proxy2) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                proxy2.addMethod(this.name, new InstanceFieldSetter(this.name, proxy2, this.field));
            }
        }
    }

    private static class InstanceFieldGetterInstaller
    extends FieldInstaller {
        InstanceFieldGetterInstaller() {
        }

        InstanceFieldGetterInstaller(String name2, Field field2) {
            super(name2, 3, field2);
        }

        void install(RubyModule proxy2) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                proxy2.addMethod(this.name, new InstanceFieldGetter(this.name, proxy2, this.field));
            }
        }
    }

    private static class StaticFieldSetterInstaller
    extends FieldInstaller {
        StaticFieldSetterInstaller() {
        }

        StaticFieldSetterInstaller(String name2, Field field2) {
            super(name2, 1, field2);
        }

        void install(RubyModule proxy2) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                proxy2.getSingletonClass().addMethod(this.name, new StaticFieldSetter(this.name, proxy2, this.field));
            }
        }
    }

    private static class StaticFieldGetterInstaller
    extends FieldInstaller {
        StaticFieldGetterInstaller() {
        }

        StaticFieldGetterInstaller(String name2, Field field2) {
            super(name2, 1, field2);
        }

        void install(RubyModule proxy2) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                proxy2.getSingletonClass().addMethod(this.name, new StaticFieldGetter(this.name, proxy2, this.field));
            }
        }
    }

    private static abstract class FieldInstaller
    extends NamedInstaller {
        Field field;

        FieldInstaller() {
        }

        FieldInstaller(String name2, int type2, Field field2) {
            super(name2, type2);
            this.field = field2;
        }
    }

    private static abstract class NamedInstaller {
        static final int STATIC_FIELD = 1;
        static final int STATIC_METHOD = 2;
        static final int INSTANCE_FIELD = 3;
        static final int INSTANCE_METHOD = 4;
        static final int CONSTRUCTOR = 5;
        String name;
        int type;
        Visibility visibility = Visibility.PUBLIC;
        boolean isProtected;

        NamedInstaller() {
        }

        NamedInstaller(String name2, int type2) {
            this.name = name2;
            this.type = type2;
        }

        abstract void install(RubyModule var1);

        boolean hasLocalMethod() {
            return true;
        }

        boolean isPublic() {
            return this.visibility == Visibility.PUBLIC;
        }

        boolean isProtected() {
            return this.visibility == Visibility.PROTECTED;
        }
    }

    private static class AssignedName {
        static final int RESERVED = 0;
        static final int METHOD = 1;
        static final int FIELD = 2;
        static final int PROTECTED_METHOD = 3;
        static final int WEAKLY_RESERVED = 4;
        static final int ALIAS = 5;
        static final int PROTECTED_FIELD = 6;
        String name;
        int type;

        AssignedName() {
        }

        AssignedName(String name2, int type2) {
            this.name = name2;
            this.type = type2;
        }
    }
}

